/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.functions;

import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import joptsimple.internal.Strings;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.Declarable;
import org.apache.geode.cache.asyncqueue.AsyncEventListener;
import org.apache.geode.cache.asyncqueue.AsyncEventQueueFactory;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.ClassNameType;
import org.apache.geode.cache.configuration.DeclarableType;
import org.apache.geode.cache.configuration.ParameterType;
import org.apache.geode.cache.execute.FunctionContext;
import org.apache.geode.cache.wan.GatewayEventFilter;
import org.apache.geode.cache.wan.GatewayEventSubstitutionFilter;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.internal.ClassPathLoader;
import org.apache.geode.internal.InternalDataSerializer;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.cli.CliFunction;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.logging.log4j.Logger;

public class CreateAsyncEventQueueFunction
extends CliFunction<CacheConfig.AsyncEventQueue> {
    private static final Logger logger = LogService.getLogger();
    private static final long serialVersionUID = 1L;

    @Override
    public CliFunctionResult executeFunction(FunctionContext<CacheConfig.AsyncEventQueue> context) {
        String memberId = "";
        try {
            String[] gatewayEventFilters;
            CacheConfig.AsyncEventQueue config = (CacheConfig.AsyncEventQueue)context.getArguments();
            InternalCache cache = (InternalCache)context.getCache();
            DistributedMember member = cache.getDistributedSystem().getDistributedMember();
            memberId = member.getId();
            if (!member.getName().equals("")) {
                memberId = member.getName();
            }
            AsyncEventQueueFactory asyncEventQueueFactory = cache.createAsyncEventQueueFactory().setParallel(config.isParallel().booleanValue()).setBatchConflationEnabled(config.isEnableBatchConflation().booleanValue()).setBatchSize(Integer.parseInt(config.getBatchSize())).setBatchTimeInterval(Integer.parseInt(config.getBatchTimeInterval())).setPersistent(config.isPersistent().booleanValue()).setDiskStoreName(config.getDiskStoreName()).setDiskSynchronous(config.isDiskSynchronous().booleanValue()).setForwardExpirationDestroy(config.isForwardExpirationDestroy()).setMaximumQueueMemory(Integer.parseInt(config.getMaximumQueueMemory())).setDispatcherThreads(Integer.parseInt(config.getDispatcherThreads())).setOrderPolicy(GatewaySender.OrderPolicy.valueOf((String)config.getOrderPolicy()));
            if (config.isPauseEventProcessing().booleanValue()) {
                asyncEventQueueFactory.pauseEventDispatching();
            }
            for (String gatewayEventFilter : gatewayEventFilters = (String[])config.getGatewayEventFilters().stream().map(ClassNameType::getClassName).toArray(String[]::new)) {
                asyncEventQueueFactory.addGatewayEventFilter((GatewayEventFilter)this.newInstance(gatewayEventFilter));
            }
            DeclarableType gatewayEventSubstitutionFilter = config.getGatewayEventSubstitutionFilter();
            if (gatewayEventSubstitutionFilter != null) {
                String gatewaySubstitutionFilter = gatewayEventSubstitutionFilter.getClassName();
                asyncEventQueueFactory.setGatewayEventSubstitutionListener((GatewayEventSubstitutionFilter)this.newInstance(gatewaySubstitutionFilter));
            }
            String listenerClassName = config.getAsyncEventListener().getClassName();
            Class listenerClass = InternalDataSerializer.getCachedClass((String)listenerClassName);
            Object listenerInstance = listenerClass.newInstance();
            List parameters = config.getAsyncEventListener().getParameters();
            Properties listenerProperties = new Properties();
            for (ParameterType p : parameters) {
                listenerProperties.put(p.getName(), p.getString());
            }
            if (!listenerProperties.isEmpty()) {
                if (!(listenerInstance instanceof Declarable)) {
                    throw new IllegalArgumentException("Listener properties were provided, but the listener specified does not implement Declarable.");
                }
                ((Declarable)listenerInstance).initialize((Cache)cache, listenerProperties);
                this.legacyInit((Declarable)listenerInstance, listenerProperties);
                HashMap<Declarable, Properties> declarablesMap = new HashMap<Declarable, Properties>();
                declarablesMap.put((Declarable)listenerInstance, listenerProperties);
                cache.addDeclarableProperties(declarablesMap);
            }
            asyncEventQueueFactory.create(config.getId(), (AsyncEventListener)listenerInstance);
            return new CliFunctionResult(memberId, CliFunctionResult.StatusState.OK, "Success");
        }
        catch (CacheClosedException cce) {
            return new CliFunctionResult(memberId, CliFunctionResult.StatusState.ERROR, null);
        }
        catch (Exception e) {
            logger.error("Could not create async event queue: {}", (Object)e.getMessage(), (Object)e);
            return new CliFunctionResult(memberId, (Object)e, null);
        }
    }

    private void legacyInit(Declarable listenerInstance, Properties listenerProperties) {
        listenerInstance.init(listenerProperties);
    }

    private Object newInstance(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        if (Strings.isNullOrEmpty((String)className)) {
            return null;
        }
        return ClassPathLoader.getLatest().forName(className).newInstance();
    }

    public String getId() {
        return CreateAsyncEventQueueFunction.class.getName();
    }
}

