/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.cli.converters;

import java.util.Arrays;
import java.util.Set;
import java.util.TreeSet;
import org.apache.geode.management.internal.cli.converters.BaseStringConverter;
import org.apache.geode.management.internal.cli.shell.Gfsh;

public class MemberIdNameConverter
extends BaseStringConverter {
    @Override
    public String getConverterHint() {
        return "geode.converter.member.idOrName:disable-string-converter";
    }

    @Override
    public Set<String> getCompletionValues() {
        TreeSet<String> nonLocatorMembers = new TreeSet<String>();
        Gfsh gfsh = this.getGfsh();
        if (gfsh != null && gfsh.isConnectedAndReady()) {
            nonLocatorMembers.addAll(Arrays.asList(gfsh.getOperationInvoker().getDistributedSystemMXBean().listMembers()));
            String[] locatorMembers = gfsh.getOperationInvoker().getDistributedSystemMXBean().listLocatorMembers(true);
            if (locatorMembers != null && locatorMembers.length != 0) {
                nonLocatorMembers.removeAll(Arrays.asList(locatorMembers));
            }
        }
        return nonLocatorMembers;
    }

    Gfsh getGfsh() {
        return Gfsh.getCurrentInstance();
    }
}

