/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.string;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.executor.string.StringExecutor;

public class MGetExecutor
extends StringExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        Region<ByteArrayWrapper, ByteArrayWrapper> r = context.getRegionProvider().getStringsRegion();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the MGET command is \"MGET key [key ...]\""));
            return;
        }
        ArrayList<ByteArrayWrapper> keys = new ArrayList<ByteArrayWrapper>();
        for (int i = 1; i < commandElems.size(); ++i) {
            byte[] keyArray = commandElems.get(i);
            ByteArrayWrapper key = new ByteArrayWrapper(keyArray);
            keys.add(key);
        }
        Map results = r.getAll(keys);
        ArrayList values = new ArrayList();
        for (ByteArrayWrapper key : keys) {
            values.add(results.get(key));
        }
        this.respondBulkStrings(command, context, values);
    }
}

