/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.sortedset;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.GeoCoder;
import org.apache.geode.redis.internal.executor.sortedset.GeoSortedSetExecutor;

public class GeoDistExecutor
extends GeoSortedSetExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        List<byte[]> commandElems = command.getProcessedCommand();
        ByteArrayWrapper key = command.getKey();
        if (commandElems.size() < 4 || commandElems.size() > 5) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the GEODIST command is \"GEODIST key member member [unit]\""));
            return;
        }
        Region<ByteArrayWrapper, ByteArrayWrapper> keyRegion = this.getRegion(context, key);
        ByteArrayWrapper hw1 = (ByteArrayWrapper)keyRegion.get((Object)new ByteArrayWrapper(commandElems.get(2)));
        ByteArrayWrapper hw2 = (ByteArrayWrapper)keyRegion.get((Object)new ByteArrayWrapper(commandElems.get(3)));
        if (hw1 == null || hw2 == null) {
            command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
            return;
        }
        double dist = GeoCoder.geoDist(hw1.toString(), hw2.toString());
        if (commandElems.size() == 5) {
            String unit = new String(commandElems.get(4));
            dist *= GeoCoder.parseUnitScale(unit);
        }
        this.respondBulkStrings(command, context, Double.toString(dist));
    }
}

