/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.list;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.Extendable;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.list.ListExecutor;

public abstract class PopExecutor
extends ListExecutor
implements Extendable {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        ByteArrayWrapper valueWrapper;
        boolean indexChanged;
        Integer opp;
        int incr;
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), this.getArgsError()));
            return;
        }
        ByteArrayWrapper key = command.getKey();
        this.checkDataType(key, RedisDataType.REDIS_LIST, context);
        Region<Object, Object> keyRegion = this.getRegion(context, key);
        if (keyRegion == null || keyRegion.size() == 2) {
            command.setResponse(Coder.getNilResponse(context.getByteBufAllocator()));
            return;
        }
        String indexKey = this.popType() == ListExecutor.ListDirection.LEFT ? "head" : "tail";
        String oppositeKey = this.popType() == ListExecutor.ListDirection.RIGHT ? "head" : "tail";
        Integer index = 0;
        int originalIndex = index;
        int n = incr = this.popType() == ListExecutor.ListDirection.LEFT ? 1 : -1;
        while (!(index = (Integer)keyRegion.get((Object)indexKey)).equals(opp = (Integer)keyRegion.get((Object)oppositeKey)) && !(indexChanged = keyRegion.replace((Object)indexKey, (Object)index, (Object)(index + incr)))) {
        }
        boolean removed = false;
        int i = 0;
        do {
            if ((valueWrapper = (ByteArrayWrapper)keyRegion.get((Object)index)) != null) {
                removed = keyRegion.remove((Object)index, (Object)valueWrapper);
            }
            if (removed) break;
            index = index + incr;
            Integer metaIndex = (Integer)keyRegion.get((Object)indexKey);
            if (i < 1 && (this.popType() == ListExecutor.ListDirection.LEFT && metaIndex < originalIndex || this.popType() == ListExecutor.ListDirection.RIGHT && metaIndex > originalIndex)) {
                index = metaIndex;
            }
            ++i;
        } while (keyRegion.size() != 2);
        this.respondBulkStrings(command, context, valueWrapper);
    }

    protected abstract ListExecutor.ListDirection popType();
}

