/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor.list;

import java.util.List;
import org.apache.geode.cache.Region;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.AbstractExecutor;

public abstract class ListExecutor
extends AbstractExecutor {
    protected static final int LIST_EMPTY_SIZE = 2;

    protected Region<Object, Object> getOrCreateRegion(ExecutionHandlerContext context, ByteArrayWrapper key, RedisDataType type) {
        return context.getRegionProvider().getOrCreateRegion(key, type, context);
    }

    protected Region<Object, Object> getRegion(ExecutionHandlerContext context, ByteArrayWrapper key) {
        return context.getRegionProvider().getRegion(key);
    }

    protected void pushElements(ByteArrayWrapper key, List<byte[]> commandElems, int startIndex, int endIndex, Region<Object, Object> keyRegion, ListDirection pushType, ExecutionHandlerContext context) {
        String indexKey = pushType == ListDirection.LEFT ? "head" : "tail";
        String oppositeKey = pushType == ListDirection.RIGHT ? "head" : "tail";
        Integer index = (Integer)keyRegion.get((Object)indexKey);
        Integer opp = (Integer)keyRegion.get((Object)oppositeKey);
        if (index != null && !index.equals(opp)) {
            index = index + (pushType == ListDirection.LEFT ? -1 : 1);
        }
        for (int i = startIndex; i < endIndex; ++i) {
            boolean indexSet;
            Integer existingIndex;
            Object oldValue;
            byte[] value = commandElems.get(i);
            ByteArrayWrapper wrapper = new ByteArrayWrapper(value);
            do {
                if ((oldValue = keyRegion.putIfAbsent((Object)index, (Object)wrapper)) == null) continue;
                index = index + (pushType == ListDirection.LEFT ? -1 : 1);
            } while (oldValue != null);
            do {
                existingIndex = (Integer)keyRegion.get((Object)indexKey);
            } while (index != null && (pushType == ListDirection.RIGHT && existingIndex < index || pushType == ListDirection.LEFT && existingIndex > index) && !(indexSet = keyRegion.replace((Object)indexKey, (Object)existingIndex, (Object)index)));
        }
    }

    protected static enum ListDirection {
        LEFT,
        RIGHT;

    }
}

