/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis.internal.executor;

import java.util.List;
import org.apache.geode.cache.UnsupportedOperationInTransactionException;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.Command;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.executor.AbstractExecutor;

public class DelExecutor
extends AbstractExecutor {
    @Override
    public void executeCommand(Command command, ExecutionHandlerContext context) {
        if (context.hasTransaction()) {
            throw new UnsupportedOperationInTransactionException();
        }
        List<byte[]> commandElems = command.getProcessedCommand();
        if (commandElems.size() < 2) {
            command.setResponse(Coder.getErrorResponse(context.getByteBufAllocator(), "The wrong number of arguments or syntax was provided, the format for the DEL command is \"DEL key [key ...]\""));
            return;
        }
        int numRemoved = 0;
        for (int i = 1; i < commandElems.size(); ++i) {
            RedisDataType type;
            byte[] byteKey = commandElems.get(i);
            ByteArrayWrapper key = new ByteArrayWrapper(byteKey);
            if (!this.removeEntry(key, type = context.getKeyRegistrar().getType(key), context)) continue;
            ++numRemoved;
        }
        command.setResponse(Coder.getIntegerResponse(context.getByteBufAllocator(), numRemoved));
    }
}

