/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.redis;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.oio.OioServerSocketChannel;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.util.concurrent.Future;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.net.ssl.KeyManagerFactory;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.LogWriter;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.annotations.internal.MakeNotStatic;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.CacheFactory;
import org.apache.geode.cache.CacheListener;
import org.apache.geode.cache.DataPolicy;
import org.apache.geode.cache.EntryEvent;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.RegionFactory;
import org.apache.geode.cache.RegionShortcut;
import org.apache.geode.cache.util.CacheListenerAdapter;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.internal.cache.GemFireCacheImpl;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegionFactory;
import org.apache.geode.internal.hll.HyperLogLogPlus;
import org.apache.geode.internal.inet.LocalHostUtil;
import org.apache.geode.internal.net.SSLConfig;
import org.apache.geode.internal.net.SSLConfigurationFactory;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.redis.internal.ByteArrayWrapper;
import org.apache.geode.redis.internal.ByteToCommandDecoder;
import org.apache.geode.redis.internal.Coder;
import org.apache.geode.redis.internal.ExecutionHandlerContext;
import org.apache.geode.redis.internal.KeyRegistrar;
import org.apache.geode.redis.internal.PubSub;
import org.apache.geode.redis.internal.PubSubImpl;
import org.apache.geode.redis.internal.RedisDataType;
import org.apache.geode.redis.internal.RedisLockService;
import org.apache.geode.redis.internal.RegionProvider;
import org.apache.geode.redis.internal.Subscriptions;
import org.apache.geode.redis.internal.executor.set.DeltaSet;
import org.apache.geode.redis.internal.executor.set.GeodeRedisSetWithFunctions;

@Experimental
public class GeodeRedisServer {
    @MakeNotStatic
    private static Thread mainThread = null;
    public static final int DEFAULT_REDIS_SERVER_PORT = 6379;
    private final int numWorkerThreads;
    private final int numSelectorThreads;
    private final int serverPort;
    private final String bindAddress;
    private static final int connectTimeoutMillis = 1000;
    private boolean singleThreadPerConnection;
    private final String logLevel;
    private Cache cache;
    private Channel serverChannel;
    private LogWriter logger;
    private RegionProvider regionCache;
    private final MetaCacheListener metaListener;
    private EventLoopGroup bossGroup;
    private EventLoopGroup workerGroup;
    private static final int numExpirationThreads = 1;
    private final ScheduledExecutorService expirationExecutor;
    private final ConcurrentMap<ByteArrayWrapper, ScheduledFuture<?>> expirationFutures;
    public static final String STRING_REGION = "ReDiS_StRiNgS";
    public static final String HASH_REGION = "ReDiS_HASH";
    public static final String SET_REGION = "ReDiS_SET";
    public static final String HLL_REGION = "ReDiS_HlL";
    public static final String REDIS_META_DATA_REGION = "ReDiS_MeTa_DaTa";
    public static final String DEFAULT_REGION_SYS_PROP_NAME = "gemfireredis.regiontype";
    public static final String NUM_THREADS_SYS_PROP_NAME = "gemfireredis.numthreads";
    public final RegionShortcut DEFAULT_REGION_TYPE;
    private boolean shutdown;
    private boolean started;
    private KeyRegistrar keyRegistrar;
    private PubSub pubSub;
    private RedisLockService hashLockService;

    @VisibleForTesting
    public KeyRegistrar getKeyRegistrar() {
        return this.keyRegistrar;
    }

    private static RegionShortcut setRegionType() {
        RegionShortcut type;
        String regionType = System.getProperty(DEFAULT_REGION_SYS_PROP_NAME, "PARTITION_REDUNDANT");
        try {
            type = RegionShortcut.valueOf((String)regionType);
        }
        catch (Exception e) {
            type = RegionShortcut.PARTITION_REDUNDANT;
        }
        return type;
    }

    private int setNumWorkerThreads() {
        int threads;
        String prop = System.getProperty(NUM_THREADS_SYS_PROP_NAME);
        int numCores = Runtime.getRuntime().availableProcessors();
        int def = 4 * numCores;
        if (prop == null || prop.isEmpty()) {
            return def;
        }
        try {
            threads = Integer.parseInt(prop);
        }
        catch (NumberFormatException e) {
            return def;
        }
        return threads;
    }

    public GeodeRedisServer(int port) {
        this(null, port, null);
    }

    public GeodeRedisServer(String bindAddress, int port) {
        this(bindAddress, port, null);
    }

    public GeodeRedisServer(String bindAddress, int port, String logLevel) {
        this.serverPort = port <= 0 ? 6379 : port;
        this.bindAddress = bindAddress;
        this.logLevel = logLevel;
        this.numWorkerThreads = this.setNumWorkerThreads();
        this.singleThreadPerConnection = this.numWorkerThreads == 0;
        this.numSelectorThreads = 1;
        this.metaListener = new MetaCacheListener();
        this.expirationFutures = new ConcurrentHashMap();
        this.expirationExecutor = Executors.newScheduledThreadPool(1, new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("GemFireRedis-ScheduledExecutor-" + this.counter.incrementAndGet());
                t.setDaemon(true);
                return t;
            }
        });
        this.DEFAULT_REGION_TYPE = GeodeRedisServer.setRegionType();
        this.shutdown = false;
        this.started = false;
    }

    private InetAddress getBindAddress() throws UnknownHostException {
        return this.bindAddress == null || this.bindAddress.isEmpty() ? LocalHostUtil.getLocalHost() : InetAddress.getByName(this.bindAddress);
    }

    public synchronized void start() {
        if (!this.started) {
            try {
                this.startGemFire();
                this.initializeRedis();
                this.startRedisServer();
            }
            catch (IOException | InterruptedException e) {
                throw new RuntimeException("Could not start Server", e);
            }
            this.started = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void startGemFire() {
        GemFireCacheImpl cache = GemFireCacheImpl.getInstance();
        if (cache == null) {
            Class<GeodeRedisServer> clazz = GeodeRedisServer.class;
            // MONITORENTER : org.apache.geode.redis.GeodeRedisServer.class
            cache = GemFireCacheImpl.getInstance();
            if (cache == null) {
                CacheFactory cacheFactory = new CacheFactory();
                if (this.logLevel != null) {
                    cacheFactory.set("log-level", this.logLevel);
                }
                cache = cacheFactory.create();
            }
            // MONITOREXIT : clazz
        }
        this.cache = cache;
        this.logger = cache.getLogger();
    }

    @VisibleForTesting
    public RegionProvider getRegionCache() {
        return this.regionCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeRedis() {
        Cache cache = this.cache;
        synchronized (cache) {
            Region redisMetaData;
            Region redisSet;
            Region redisHash;
            Region hLLRegion;
            RegionFactory regionFactory;
            InternalCache gemFireCache = (InternalCache)this.cache;
            Region stringsRegion = this.cache.getRegion(STRING_REGION);
            if (stringsRegion == null) {
                regionFactory = gemFireCache.createRegionFactory(this.DEFAULT_REGION_TYPE);
                stringsRegion = regionFactory.create(STRING_REGION);
            }
            if ((hLLRegion = this.cache.getRegion(HLL_REGION)) == null) {
                regionFactory = gemFireCache.createRegionFactory(this.DEFAULT_REGION_TYPE);
                hLLRegion = regionFactory.create(HLL_REGION);
            }
            if ((redisHash = this.cache.getRegion(HASH_REGION)) == null) {
                regionFactory = gemFireCache.createRegionFactory(this.DEFAULT_REGION_TYPE);
                redisHash = regionFactory.create(HASH_REGION);
            }
            if ((redisSet = this.cache.getRegion(SET_REGION)) == null) {
                regionFactory = gemFireCache.createRegionFactory(this.DEFAULT_REGION_TYPE);
                redisSet = regionFactory.create(SET_REGION);
            }
            if ((redisMetaData = this.cache.getRegion(REDIS_META_DATA_REGION)) == null) {
                InternalRegionFactory redisMetaDataFactory = gemFireCache.createInternalRegionFactory();
                redisMetaDataFactory.addCacheListener((CacheListener)this.metaListener);
                redisMetaDataFactory.setDataPolicy(DataPolicy.REPLICATE);
                redisMetaDataFactory.setInternalRegion(true).setIsUsedForMetaRegion(true);
                redisMetaData = redisMetaDataFactory.create(REDIS_META_DATA_REGION);
            }
            this.keyRegistrar = new KeyRegistrar((Region<String, RedisDataType>)redisMetaData);
            this.hashLockService = new RedisLockService();
            this.pubSub = new PubSubImpl(new Subscriptions());
            this.regionCache = new RegionProvider((Region<ByteArrayWrapper, ByteArrayWrapper>)stringsRegion, (Region<ByteArrayWrapper, HyperLogLogPlus>)hLLRegion, this.keyRegistrar, this.expirationFutures, this.expirationExecutor, this.DEFAULT_REGION_TYPE, (Region<ByteArrayWrapper, Map<ByteArrayWrapper, ByteArrayWrapper>>)redisHash, (Region<ByteArrayWrapper, DeltaSet>)redisSet);
            redisMetaData.put((Object)REDIS_META_DATA_REGION, (Object)RedisDataType.REDIS_PROTECTED);
            redisMetaData.put((Object)HLL_REGION, (Object)RedisDataType.REDIS_PROTECTED);
            redisMetaData.put((Object)STRING_REGION, (Object)RedisDataType.REDIS_PROTECTED);
            redisMetaData.put((Object)SET_REGION, (Object)RedisDataType.REDIS_PROTECTED);
            redisMetaData.put((Object)HASH_REGION, (Object)RedisDataType.REDIS_PROTECTED);
            GeodeRedisSetWithFunctions.registerFunctions();
        }
        this.checkForRegions();
        this.registerLockServiceMBean();
    }

    @VisibleForTesting
    public RedisLockService getLockService() {
        return this.hashLockService;
    }

    private void registerLockServiceMBean() {
        ManagementService sms = SystemManagementService.getManagementService((Cache)this.cache);
        try {
            ObjectName mbeanON = new ObjectName("GemFire:service=RedisLockService,type=Member");
            sms.registerMBean((Object)this.hashLockService, mbeanON);
            MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            Set<ObjectName> names = platformMBeanServer.queryNames(mbeanON, null);
            if (names.isEmpty()) {
                platformMBeanServer.registerMBean(this.hashLockService, mbeanON);
                this.logger.info("Registered RedisLockServiceMBean on " + mbeanON);
            }
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            throw new GemFireConfigException("Error while configuring RedisLockServiceMBean", (Throwable)e);
        }
    }

    private void checkForRegions() {
        Set<Map.Entry<String, RedisDataType>> entrySet = this.keyRegistrar.keyInfos();
        for (Map.Entry entry : entrySet) {
            String regionName = (String)entry.getKey();
            RedisDataType type = (RedisDataType)((Object)entry.getValue());
            Region newRegion = this.cache.getRegion(regionName);
            if (newRegion != null || type == RedisDataType.REDIS_STRING || type == RedisDataType.REDIS_HLL || type == RedisDataType.REDIS_PROTECTED) continue;
            try {
                this.regionCache.createRemoteRegionReferenceLocally(Coder.stringToByteArrayWrapper(regionName), type);
            }
            catch (Exception e) {
                if (!this.logger.errorEnabled()) continue;
                this.logger.error((Throwable)e);
            }
        }
    }

    private void startRedisServer() throws IOException, InterruptedException {
        Class<? extends ServerChannel> socketClass;
        ThreadFactory selectorThreadFactory = new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("GeodeRedisServer-SelectorThread-" + this.counter.incrementAndGet());
                t.setDaemon(true);
                return t;
            }
        };
        ThreadFactory workerThreadFactory = new ThreadFactory(){
            private final AtomicInteger counter = new AtomicInteger();

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r);
                t.setName("GeodeRedisServer-WorkerThread-" + this.counter.incrementAndGet());
                return t;
            }
        };
        this.bossGroup = null;
        this.workerGroup = null;
        if (this.singleThreadPerConnection) {
            socketClass = this.startRedisServiceSingleThreadPerConnection(selectorThreadFactory, workerThreadFactory);
        } else {
            this.bossGroup = new NioEventLoopGroup(this.numSelectorThreads, selectorThreadFactory);
            this.workerGroup = new NioEventLoopGroup(this.numWorkerThreads, workerThreadFactory);
            socketClass = NioServerSocketChannel.class;
        }
        InternalDistributedSystem system = (InternalDistributedSystem)this.cache.getDistributedSystem();
        String pwd = system.getConfig().getRedisPassword();
        final byte[] pwdB = Coder.stringToBytes(pwd);
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group(this.bossGroup, this.workerGroup).channel(socketClass)).childHandler(new ChannelInitializer<SocketChannel>(){

            @Override
            public void initChannel(SocketChannel ch) {
                if (GeodeRedisServer.this.logger.fineEnabled()) {
                    GeodeRedisServer.this.logger.fine("GeodeRedisServer-Connection established with " + ch.remoteAddress());
                }
                ChannelPipeline p = ch.pipeline();
                GeodeRedisServer.this.addSSLIfEnabled(ch, p);
                p.addLast(ByteToCommandDecoder.class.getSimpleName(), (ChannelHandler)new ByteToCommandDecoder());
                p.addLast(ExecutionHandlerContext.class.getSimpleName(), (ChannelHandler)new ExecutionHandlerContext(ch, GeodeRedisServer.this.cache, GeodeRedisServer.this.regionCache, GeodeRedisServer.this, pwdB, GeodeRedisServer.this.keyRegistrar, GeodeRedisServer.this.pubSub, GeodeRedisServer.this.hashLockService));
            }
        }).option(ChannelOption.SO_REUSEADDR, true)).option(ChannelOption.SO_RCVBUF, this.getBufferSize())).childOption(ChannelOption.SO_KEEPALIVE, true).childOption(ChannelOption.CONNECT_TIMEOUT_MILLIS, 1000).childOption(ChannelOption.ALLOCATOR, PooledByteBufAllocator.DEFAULT);
        ChannelFuture f = b.bind(new InetSocketAddress(this.getBindAddress(), this.serverPort)).sync();
        if (this.logger.infoEnabled()) {
            String logMessage = "GeodeRedisServer started {" + this.getBindAddress() + ":" + this.serverPort + "}, Selector threads: " + this.numSelectorThreads;
            logMessage = this.singleThreadPerConnection ? logMessage + ", One worker thread per connection" : logMessage + ", Worker threads: " + this.numWorkerThreads;
            this.logger.info(logMessage);
        }
        this.serverChannel = f.channel();
    }

    private Class<? extends ServerChannel> startRedisServiceSingleThreadPerConnection(ThreadFactory selectorThreadFactory, ThreadFactory workerThreadFactory) {
        this.bossGroup = new OioEventLoopGroup(Integer.MAX_VALUE, selectorThreadFactory);
        this.workerGroup = new OioEventLoopGroup(Integer.MAX_VALUE, workerThreadFactory);
        return OioServerSocketChannel.class;
    }

    private void addSSLIfEnabled(SocketChannel ch, ChannelPipeline p) {
        SslContext sslContext;
        SSLConfig sslConfigForComponent = SSLConfigurationFactory.getSSLConfigForComponent((DistributionConfig)((InternalDistributedSystem)this.cache.getDistributedSystem()).getConfig(), (SecurableCommunicationChannel)SecurableCommunicationChannel.SERVER);
        if (!sslConfigForComponent.isEnabled()) {
            return;
        }
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(new FileInputStream(sslConfigForComponent.getKeystore()), sslConfigForComponent.getKeystorePassword().toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, sslConfigForComponent.getKeystorePassword().toCharArray());
            SslContextBuilder sslContextBuilder = SslContextBuilder.forServer(kmf);
            sslContext = sslContextBuilder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        p.addLast(sslContext.newHandler(ch.alloc()));
    }

    private void afterKeyCreate(EntryEvent<String, RedisDataType> event) {
        if (event.isOriginRemote()) {
            String key = (String)event.getKey();
            RedisDataType value = (RedisDataType)((Object)event.getNewValue());
            if (value != RedisDataType.REDIS_STRING && value != RedisDataType.REDIS_HLL && value != RedisDataType.REDIS_PROTECTED) {
                try {
                    this.regionCache.createRemoteRegionReferenceLocally(Coder.stringToByteArrayWrapper(key), value);
                }
                catch (RegionDestroyedException regionDestroyedException) {
                    // empty catch block
                }
            }
        }
    }

    private void afterKeyDestroy(EntryEvent<String, RedisDataType> event) {
        if (event.isOriginRemote()) {
            ByteArrayWrapper kW;
            Region<?, ?> r;
            String key = (String)event.getKey();
            RedisDataType value = (RedisDataType)((Object)event.getOldValue());
            if (value != null && value != RedisDataType.REDIS_STRING && value != RedisDataType.REDIS_HLL && value != RedisDataType.REDIS_PROTECTED && (r = this.regionCache.getRegion(kW = Coder.stringToByteArrayWrapper(key))) != null) {
                this.regionCache.removeRegionReferenceLocally(kW, value);
            }
        }
    }

    private int getBufferSize() {
        InternalDistributedSystem system = (InternalDistributedSystem)this.cache.getDistributedSystem();
        return system.getConfig().getSocketBufferSize();
    }

    public synchronized void shutdown() {
        if (!this.shutdown) {
            if (this.logger.infoEnabled()) {
                this.logger.info("GeodeRedisServer shutting down");
            }
            ChannelFuture closeFuture = this.serverChannel.closeFuture();
            Future<?> c = this.workerGroup.shutdownGracefully();
            Future<?> c2 = this.bossGroup.shutdownGracefully();
            this.serverChannel.close();
            c.syncUninterruptibly();
            c2.syncUninterruptibly();
            this.regionCache.close();
            if (mainThread != null) {
                mainThread.interrupt();
            }
            for (ScheduledFuture f : this.expirationFutures.values()) {
                f.cancel(true);
            }
            this.expirationFutures.clear();
            this.expirationExecutor.shutdownNow();
            closeFuture.syncUninterruptibly();
            this.shutdown = true;
        }
    }

    public static void main(String[] args) {
        int port = 6379;
        String bindAddress = null;
        String logLevel = null;
        for (String arg : args) {
            if (arg.startsWith("-port")) {
                port = GeodeRedisServer.getPort(arg);
                continue;
            }
            if (arg.startsWith("-bind-address")) {
                bindAddress = GeodeRedisServer.getBindAddress(arg);
                continue;
            }
            if (!arg.startsWith("-log-level")) continue;
            logLevel = GeodeRedisServer.getLogLevel(arg);
        }
        mainThread = Thread.currentThread();
        GeodeRedisServer server = new GeodeRedisServer(bindAddress, port, logLevel);
        server.start();
        while (true) {
            try {
                while (true) {
                    Thread.sleep(Long.MAX_VALUE);
                }
            }
            catch (InterruptedException e1) {
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    private static int getPort(String arg) {
        int port = 6379;
        if (arg != null && arg.length() > 6 && arg.startsWith("-port")) {
            String p = arg.substring(arg.indexOf(61) + 1);
            p = p.trim();
            try {
                port = Integer.parseInt(p);
            }
            catch (NumberFormatException e) {
                System.out.println("Unable to parse port, using default port");
            }
        }
        return port;
    }

    private static String getBindAddress(String arg) {
        String address = null;
        if (arg != null && arg.length() > 14 && arg.startsWith("-bind-address")) {
            String p = arg.substring(arg.indexOf(61) + 1);
            address = p.trim();
        }
        return address;
    }

    private static String getLogLevel(String arg) {
        String logLevel = null;
        if (arg != null && arg.length() > 11 && arg.startsWith("-log-level")) {
            String p = arg.substring(arg.indexOf(61) + 1);
            logLevel = p.trim();
        }
        return logLevel;
    }

    private class MetaCacheListener
    extends CacheListenerAdapter<String, RedisDataType> {
        private MetaCacheListener() {
        }

        public void afterCreate(EntryEvent<String, RedisDataType> event) {
            GeodeRedisServer.this.afterKeyCreate((EntryEvent<String, RedisDataType>)event);
        }

        public void afterDestroy(EntryEvent<String, RedisDataType> event) {
            GeodeRedisServer.this.afterKeyDestroy((EntryEvent<String, RedisDataType>)event);
        }
    }
}

