/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.protocol.protobuf.security;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionDestroyedException;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.DistributionManager;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.protocol.protobuf.security.SecureFunctionService;
import org.apache.geode.internal.protocol.protobuf.security.Security;

public class SecureFunctionServiceImpl
implements SecureFunctionService {
    private final Security security;
    private final InternalCache internalCache;

    public SecureFunctionServiceImpl(InternalCache internalCache, Security security) {
        this.security = security;
        this.internalCache = internalCache;
    }

    @Override
    public List<Object> executeFunctionOnRegion(String functionID, String regionName, Object arguments, Set<?> keyFilter) {
        Function<Object> function = this.authorizeAndGetFunction(regionName, functionID, arguments);
        Region region = this.getRegion(regionName);
        Execution<Object, Object, List<Object>> execution = FunctionService.onRegion(region);
        if (keyFilter != null) {
            execution = execution.withFilter(keyFilter);
        }
        return this.executeFunction(execution, functionID, function, arguments);
    }

    private List<Object> executeFunction(Execution<Object, Object, List<Object>> execution, String functionID, Function<Object> function, Object arguments) {
        if (arguments != null) {
            execution = execution.setArguments(arguments);
        }
        ResultCollector<Object, List<Object>> collector = execution.execute(functionID);
        if (function.hasResult()) {
            return collector.getResult();
        }
        return Collections.emptyList();
    }

    private <T> Function<T> authorizeAndGetFunction(String regionName, String functionID, Object arguments) {
        Function function = FunctionService.getFunction(functionID);
        if (function == null) {
            throw new IllegalArgumentException(String.format("Function named %s is not registered to FunctionService", functionID));
        }
        function.getRequiredPermissions(regionName, arguments).forEach(this.security::authorize);
        return function;
    }

    @Override
    public List<Object> executeFunctionOnMember(String functionID, Object arguments, List<String> memberNameList) {
        Function<Object> function = this.authorizeAndGetFunction(null, functionID, arguments);
        Execution execution = FunctionService.onMembers(this.getMemberIDs(functionID, memberNameList));
        return this.executeFunction(execution, functionID, function, arguments);
    }

    @Override
    public List<Object> executeFunctionOnGroups(String functionID, Object arguments, List<String> groupNameList) {
        Function<Object> function = this.authorizeAndGetFunction(null, functionID, arguments);
        Execution execution = FunctionService.onMember(groupNameList.toArray(new String[0]));
        return this.executeFunction(execution, functionID, function, arguments);
    }

    private Set<DistributedMember> getMemberIDs(String functionID, List<String> memberNameList) {
        HashSet<DistributedMember> memberIds = new HashSet<DistributedMember>(memberNameList.size());
        DistributionManager distributionManager = this.internalCache.getDistributionManager();
        for (String name : memberNameList) {
            DistributedMember member = distributionManager.getMemberWithName(name);
            if (member == null) {
                throw new IllegalArgumentException("Member " + name + " not found to execute \"" + functionID + "\"");
            }
            memberIds.add(member);
        }
        if (memberIds.isEmpty()) {
            throw new IllegalArgumentException("No members found to execute \"" + functionID + "\"");
        }
        return memberIds;
    }

    private <K, V> Region<K, V> getRegion(String regionName) {
        Region region = this.internalCache.getRegion(regionName);
        if (region == null) {
            throw new RegionDestroyedException("Region not found " + regionName, regionName);
        }
        return region;
    }
}

