/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.beans;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.JMRuntimeException;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.geode.Statistics;
import org.apache.geode.StatisticsType;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.DiskStore;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.internal.CommandProcessor;
import org.apache.geode.cache.wan.GatewayReceiver;
import org.apache.geode.cache.wan.GatewaySender;
import org.apache.geode.distributed.Locator;
import org.apache.geode.distributed.LocatorLauncher;
import org.apache.geode.distributed.ServerLauncher;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.DistributionStats;
import org.apache.geode.distributed.internal.InternalDistributedSystem;
import org.apache.geode.distributed.internal.locks.DLockService;
import org.apache.geode.distributed.internal.locks.DLockStats;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.cache.CachePerfStats;
import org.apache.geode.internal.cache.DirectoryHolder;
import org.apache.geode.internal.cache.DiskDirectoryStats;
import org.apache.geode.internal.cache.DiskRegion;
import org.apache.geode.internal.cache.DiskStoreImpl;
import org.apache.geode.internal.cache.DiskStoreStats;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.cache.InternalRegion;
import org.apache.geode.internal.cache.PartitionedRegion;
import org.apache.geode.internal.cache.PartitionedRegionStats;
import org.apache.geode.internal.cache.control.ResourceManagerStats;
import org.apache.geode.internal.cache.execute.metrics.FunctionServiceStats;
import org.apache.geode.internal.inet.LocalHostUtil;
import org.apache.geode.internal.lang.SystemUtils;
import org.apache.geode.internal.logging.log4j.LogMarker;
import org.apache.geode.internal.offheap.MemoryAllocator;
import org.apache.geode.internal.offheap.OffHeapMemoryStats;
import org.apache.geode.internal.process.PidUnavailableException;
import org.apache.geode.internal.process.ProcessUtils;
import org.apache.geode.internal.serialization.Version;
import org.apache.geode.internal.statistics.OsStatisticsProvider;
import org.apache.geode.internal.statistics.StatSamplerStats;
import org.apache.geode.internal.statistics.StatisticsManager;
import org.apache.geode.internal.statistics.VMStatsContract;
import org.apache.geode.internal.statistics.platform.LinuxSystemStats;
import org.apache.geode.internal.statistics.platform.ProcessStats;
import org.apache.geode.internal.stats50.VMStats50;
import org.apache.geode.internal.tcp.ConnectionTable;
import org.apache.geode.logging.internal.executors.LoggingThread;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.logging.internal.spi.LogFile;
import org.apache.geode.management.GemFireProperties;
import org.apache.geode.management.JVMMetrics;
import org.apache.geode.management.OSMetrics;
import org.apache.geode.management.internal.ManagementConstants;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.beans.BeanUtilFuncs;
import org.apache.geode.management.internal.beans.QueryDataFunction;
import org.apache.geode.management.internal.beans.stats.AggregateRegionStatsMonitor;
import org.apache.geode.management.internal.beans.stats.GCStatsMonitor;
import org.apache.geode.management.internal.beans.stats.MBeanStatsMonitor;
import org.apache.geode.management.internal.beans.stats.MemberLevelDiskMonitor;
import org.apache.geode.management.internal.beans.stats.StatType;
import org.apache.geode.management.internal.beans.stats.StatsAverageLatency;
import org.apache.geode.management.internal.beans.stats.StatsLatency;
import org.apache.geode.management.internal.beans.stats.StatsRate;
import org.apache.geode.management.internal.beans.stats.VMStatsMonitor;
import org.apache.logging.log4j.Logger;

public class MemberMBeanBridge {
    private static final Logger logger = LogService.getLogger();
    private static final String MEMBER_LEVEL_DISK_MONITOR = "MemberLevelDiskMonitor";
    private static final String MEMBER_LEVEL_REGION_MONITOR = "MemberLevelRegionMonitor";
    private static final long MBFactor = 0x100000L;
    private final OsStatisticsProvider osStatisticsProvider;
    private InternalCache cache;
    private DistributionConfig config;
    private GemFireProperties gemFirePropertyData;
    private final InternalDistributedSystem system;
    private final StatisticsManager statisticsManager;
    private CommandProcessor commandProcessor;
    private String commandServiceInitError;
    private MemoryMXBean memoryMXBean;
    private ThreadMXBean threadMXBean;
    private OperatingSystemMXBean osBean;
    private String hostname;
    private int processId;
    private ObjectName osObjectName;
    private final MBeanStatsMonitor monitor;
    private SystemManagementService service;
    private final MemberLevelDiskMonitor diskMonitor;
    private final AggregateRegionStatsMonitor regionMonitor;
    private StatsRate createsRate;
    private StatsRate bytesReceivedRate;
    private StatsRate bytesSentRate;
    private StatsRate destroysRate;
    private StatsRate functionExecutionRate;
    private StatsRate getsRate;
    private StatsRate putAllRate;
    private StatsRate putsRate;
    private StatsRate transactionCommitsRate;
    private StatsRate diskReadsRate;
    private StatsRate diskWritesRate;
    private StatsAverageLatency listenerCallsAvgLatency;
    private StatsAverageLatency writerCallsAvgLatency;
    private StatsAverageLatency putsAvgLatency;
    private StatsAverageLatency getsAvgLatency;
    private StatsAverageLatency putAllAvgLatency;
    private StatsAverageLatency loadsAverageLatency;
    private StatsAverageLatency netLoadsAverageLatency;
    private StatsAverageLatency netSearchAverageLatency;
    private StatsAverageLatency transactionCommitsAvgLatency;
    private StatsAverageLatency diskFlushAvgLatency;
    private StatsAverageLatency deserializationAvgLatency;
    private StatsLatency deserializationLatency;
    private StatsRate deserializationRate;
    private StatsAverageLatency serializationAvgLatency;
    private StatsLatency serializationLatency;
    private StatsRate serializationRate;
    private StatsAverageLatency pdxDeserializationAvgLatency;
    private StatsRate pdxDeserializationRate;
    private StatsRate lruDestroyRate;
    private StatsRate lruEvictionRate;
    private String gemFireVersion;
    private String classPath;
    private String name;
    private String id;
    private final String osName;
    private final GCStatsMonitor gcMonitor;
    private final VMStatsMonitor vmStatsMonitor;
    private final MBeanStatsMonitor systemStatsMonitor;
    private float instCreatesRate;
    private float instGetsRate;
    private float instPutsRate;
    private float instPutAllRate;
    private Statistics systemStat;
    private boolean cacheServer;
    private String redundancyZone;
    private ResourceManagerStats resourceManagerStats;
    private volatile boolean lockServicesStatsAdded;

    MemberMBeanBridge(InternalCache cache, SystemManagementService service) {
        block9: {
            block8: {
                this.osStatisticsProvider = OsStatisticsProvider.build();
                this.osName = System.getProperty("os.name", "unknown");
                this.redundancyZone = "";
                this.cache = cache;
                this.service = service;
                this.system = (InternalDistributedSystem)cache.getDistributedSystem();
                this.statisticsManager = this.system.getStatisticsManager();
                this.redundancyZone = this.system.getDistributionManager().getRedundancyZone(cache.getInternalDistributedSystem().getDistributedMember());
                this.config = this.system.getConfig();
                try {
                    this.commandProcessor = cache.getService(CommandProcessor.class);
                }
                catch (Exception e) {
                    this.commandServiceInitError = e.getMessage();
                    logger.info(LogMarker.CONFIG_MARKER, "Command processor could not be initialized. {}", (Object)e.getMessage());
                }
                this.initGemfireProperties();
                try {
                    this.hostname = LocalHostUtil.getLocalHostName();
                }
                catch (UnknownHostException ignore) {
                    this.hostname = "localhost";
                }
                try {
                    this.osObjectName = new ObjectName("java.lang:type=OperatingSystem");
                }
                catch (NullPointerException | MalformedObjectNameException ex) {
                    if (!logger.isDebugEnabled()) break block8;
                    logger.debug(ex.getMessage(), (Throwable)ex);
                }
            }
            this.memoryMXBean = ManagementFactory.getMemoryMXBean();
            this.threadMXBean = ManagementFactory.getThreadMXBean();
            this.osBean = ManagementFactory.getOperatingSystemMXBean();
            this.monitor = new MBeanStatsMonitor("MemberMXBeanMonitor");
            this.diskMonitor = new MemberLevelDiskMonitor(MEMBER_LEVEL_DISK_MONITOR);
            this.regionMonitor = new AggregateRegionStatsMonitor(MEMBER_LEVEL_REGION_MONITOR);
            this.gcMonitor = new GCStatsMonitor("GCStatsMonitor");
            this.vmStatsMonitor = new VMStatsMonitor("VMStatsMonitor");
            this.systemStatsMonitor = new MBeanStatsMonitor("SystemStatsManager");
            this.gemFireVersion = GemFireVersion.asString();
            this.classPath = ManagementFactory.getRuntimeMXBean().getClassPath();
            this.name = cache.getDistributedSystem().getDistributedMember().getName();
            this.id = cache.getDistributedSystem().getDistributedMember().getId();
            try {
                this.processId = ProcessUtils.identifyPid();
            }
            catch (PidUnavailableException ex) {
                if (!logger.isDebugEnabled()) break block9;
                logger.debug(ex.getMessage(), (Throwable)ex);
            }
        }
        FunctionService.registerFunction(new QueryDataFunction());
        this.resourceManagerStats = cache.getInternalResourceManager().getStats();
    }

    @VisibleForTesting
    public MemberMBeanBridge(InternalDistributedSystem system, StatisticsManager statisticsManager) {
        this.osStatisticsProvider = OsStatisticsProvider.build();
        this.osName = System.getProperty("os.name", "unknown");
        this.redundancyZone = "";
        this.monitor = new MBeanStatsMonitor("MemberMXBeanMonitor");
        this.diskMonitor = new MemberLevelDiskMonitor(MEMBER_LEVEL_DISK_MONITOR);
        this.regionMonitor = new AggregateRegionStatsMonitor(MEMBER_LEVEL_REGION_MONITOR);
        this.gcMonitor = new GCStatsMonitor("GCStatsMonitor");
        this.vmStatsMonitor = new VMStatsMonitor("VMStatsMonitor");
        this.systemStatsMonitor = new MBeanStatsMonitor("SystemStatsManager");
        this.system = system;
        this.statisticsManager = statisticsManager;
        this.initializeStats();
    }

    MemberMBeanBridge init() {
        OffHeapMemoryStats offHeapStats;
        CachePerfStats cachePerfStats = this.cache.getCachePerfStats();
        this.addCacheStats(cachePerfStats);
        this.addFunctionStats(this.system.getFunctionStatsManager().getFunctionServiceStats());
        if (this.system.getDistributionManager().getStats() instanceof DistributionStats) {
            DistributionStats distributionStats = (DistributionStats)this.system.getDistributionManager().getStats();
            this.addDistributionStats(distributionStats);
        }
        this.systemStat = this.fetchSystemStats();
        MemoryAllocator allocator = this.cache.getOffHeapStore();
        if (null != allocator && null != (offHeapStats = allocator.getStats())) {
            this.addOffHeapStats(offHeapStats);
        }
        this.addProcessStats(this.fetchProcessStats());
        this.addStatSamplerStats(this.fetchStatSamplerStats());
        this.addVMStats(this.fetchVMStats());
        this.initializeStats();
        return this;
    }

    private Statistics fetchSystemStats() {
        Statistics[] systemStats;
        if (this.osStatisticsProvider.osStatsSupported() && (systemStats = this.system.findStatisticsByType(LinuxSystemStats.getType())) != null) {
            return systemStats[0];
        }
        return null;
    }

    private void addOffHeapStats(OffHeapMemoryStats offHeapStats) {
        Statistics offHeapMemoryStatistics = offHeapStats.getStats();
        this.monitor.addStatisticsToMonitor(offHeapMemoryStatistics);
    }

    @VisibleForTesting
    public void addCacheStats(CachePerfStats cachePerfStats) {
        Statistics cachePerfStatistics = cachePerfStats.getStats();
        this.monitor.addStatisticsToMonitor(cachePerfStatistics);
    }

    @VisibleForTesting
    public void addFunctionStats(FunctionServiceStats functionServiceStats) {
        Statistics functionStatistics = functionServiceStats.getStats();
        this.monitor.addStatisticsToMonitor(functionStatistics);
    }

    @VisibleForTesting
    public void addDistributionStats(DistributionStats distributionStats) {
        Statistics dsStats = distributionStats.getStats();
        this.monitor.addStatisticsToMonitor(dsStats);
    }

    void addDiskStore(DiskStore dsi) {
        DiskStoreImpl impl = (DiskStoreImpl)dsi;
        this.addDiskStoreStats(impl.getStats());
    }

    @VisibleForTesting
    public void addDiskStoreStats(DiskStoreStats stats) {
        this.diskMonitor.addStatisticsToMonitor(stats.getStats());
    }

    void removeDiskStore(DiskStore dsi) {
        DiskStoreImpl impl = (DiskStoreImpl)dsi;
        this.removeDiskStoreStats(impl.getStats());
    }

    private void removeDiskStoreStats(DiskStoreStats stats) {
        this.diskMonitor.removeStatisticsFromMonitor(stats.getStats());
    }

    void addRegion(Region region) {
        if (region.getAttributes().getPartitionAttributes() != null) {
            this.addPartitionedRegionStats(((PartitionedRegion)region).getPrStats());
        }
        InternalRegion internalRegion = (InternalRegion)region;
        this.addLRUStats(internalRegion.getEvictionStatistics());
        DiskRegion dr = internalRegion.getDiskRegion();
        if (dr != null) {
            for (DirectoryHolder dh : dr.getDirectories()) {
                this.addDirectoryStats(dh.getDiskDirectoryStats());
            }
        }
    }

    @VisibleForTesting
    public void addPartitionedRegionStats(PartitionedRegionStats parStats) {
        this.regionMonitor.addStatisticsToMonitor(parStats.getStats());
    }

    private void addLRUStats(Statistics lruStats) {
        if (lruStats != null) {
            this.regionMonitor.addStatisticsToMonitor(lruStats);
        }
    }

    private void addDirectoryStats(DiskDirectoryStats diskDirStats) {
        this.regionMonitor.addStatisticsToMonitor(diskDirStats.getStats());
    }

    void removeRegion(Region region) {
        if (region.getAttributes().getPartitionAttributes() != null) {
            this.removePartitionedRegionStats(((PartitionedRegion)region).getPrStats());
        }
        InternalRegion internalRegion = (InternalRegion)region;
        this.removeLRUStats(internalRegion.getEvictionStatistics());
        DiskRegion diskRegion = internalRegion.getDiskRegion();
        if (diskRegion != null) {
            for (DirectoryHolder directoryHolder : diskRegion.getDirectories()) {
                this.removeDirectoryStats(directoryHolder.getDiskDirectoryStats());
            }
        }
    }

    @VisibleForTesting
    public void removePartitionedRegionStats(PartitionedRegionStats parStats) {
        this.regionMonitor.removePartitionStatistics(parStats.getStats());
    }

    private void removeLRUStats(Statistics statistics) {
        if (statistics != null) {
            this.regionMonitor.removeLRUStatistics(statistics);
        }
    }

    private void removeDirectoryStats(DiskDirectoryStats diskDirStats) {
        this.regionMonitor.removeDirectoryStatistics(diskDirStats.getStats());
    }

    void addLockServiceStats(DLockService lock) {
        if (!this.lockServicesStatsAdded) {
            DLockStats stats = (DLockStats)lock.getStats();
            this.addLockServiceStats(stats);
            this.lockServicesStatsAdded = true;
        }
    }

    @VisibleForTesting
    public void addLockServiceStats(DLockStats stats) {
        this.monitor.addStatisticsToMonitor(stats.getStats());
    }

    private ProcessStats fetchProcessStats() {
        return this.system.getStatSampler().getProcessStats();
    }

    private StatSamplerStats fetchStatSamplerStats() {
        return this.system.getStatSampler().getStatSamplerStats();
    }

    @VisibleForTesting
    public void addProcessStats(ProcessStats processStats) {
        if (processStats != null) {
            this.systemStatsMonitor.addStatisticsToMonitor(processStats.getStatistics());
        }
    }

    @VisibleForTesting
    public void addStatSamplerStats(StatSamplerStats statSamplerStats) {
        if (statSamplerStats != null) {
            this.systemStatsMonitor.addStatisticsToMonitor(statSamplerStats.getStats());
        }
    }

    private VMStatsContract fetchVMStats() {
        return this.system.getStatSampler().getVMStats();
    }

    @VisibleForTesting
    public void addVMStats(VMStatsContract vmStatsContract) {
        if (vmStatsContract instanceof VMStats50) {
            Statistics[] gcStats;
            StatisticsType gcType;
            Statistics vmHeapStats;
            VMStats50 vmStats50 = (VMStats50)vmStatsContract;
            Statistics vmStats = vmStats50.getVMStats();
            if (vmStats != null) {
                this.vmStatsMonitor.addStatisticsToMonitor(vmStats);
            }
            if ((vmHeapStats = vmStats50.getVMHeapStats()) != null) {
                this.vmStatsMonitor.addStatisticsToMonitor(vmHeapStats);
            }
            if ((gcType = VMStats50.getGCType()) != null && (gcStats = this.statisticsManager.findStatisticsByType(gcType)) != null && gcStats.length > 0) {
                for (Statistics gcStat : gcStats) {
                    if (gcStat == null) continue;
                    this.gcMonitor.addStatisticsToMonitor(gcStat);
                }
            }
        }
    }

    private Number getMemberLevelStatistic(String statName) {
        return this.monitor.getStatistic(statName);
    }

    private Number getVMStatistic(String statName) {
        return this.vmStatsMonitor.getStatistic(statName);
    }

    private Number getGCStatistic(String statName) {
        return this.gcMonitor.getStatistic(statName);
    }

    private Number getSystemStatistic(String statName) {
        return this.systemStatsMonitor.getStatistic(statName);
    }

    void stopMonitor() {
        this.monitor.stopListener();
        this.regionMonitor.stopListener();
        this.gcMonitor.stopListener();
        this.systemStatsMonitor.stopListener();
        this.vmStatsMonitor.stopListener();
    }

    private void initializeStats() {
        this.createsRate = new StatsRate("creates", StatType.INT_TYPE, this.monitor);
        this.bytesReceivedRate = new StatsRate("receivedBytes", StatType.LONG_TYPE, this.monitor);
        this.bytesSentRate = new StatsRate("sentBytes", StatType.LONG_TYPE, this.monitor);
        this.destroysRate = new StatsRate("destroys", StatType.INT_TYPE, this.monitor);
        this.functionExecutionRate = new StatsRate("functionExecutionsCompleted", StatType.INT_TYPE, this.monitor);
        this.getsRate = new StatsRate("gets", StatType.INT_TYPE, this.monitor);
        this.putAllRate = new StatsRate("putalls", StatType.INT_TYPE, this.monitor);
        this.putsRate = new StatsRate("puts", StatType.INT_TYPE, this.monitor);
        this.transactionCommitsRate = new StatsRate("txCommits", StatType.INT_TYPE, this.monitor);
        this.diskReadsRate = new StatsRate("readBytes", StatType.LONG_TYPE, (MBeanStatsMonitor)this.diskMonitor);
        this.diskWritesRate = new StatsRate("writtenBytes", StatType.LONG_TYPE, (MBeanStatsMonitor)this.diskMonitor);
        this.listenerCallsAvgLatency = new StatsAverageLatency("cacheListenerCallsCompleted", StatType.INT_TYPE, "cacheListenerCallTime", this.monitor);
        this.writerCallsAvgLatency = new StatsAverageLatency("cacheWriterCallsCompleted", StatType.INT_TYPE, "cacheWriterCallTime", this.monitor);
        this.getsAvgLatency = new StatsAverageLatency("gets", StatType.INT_TYPE, "getTime", this.monitor);
        this.putAllAvgLatency = new StatsAverageLatency("putalls", StatType.INT_TYPE, "putallTime", this.monitor);
        this.putsAvgLatency = new StatsAverageLatency("puts", StatType.INT_TYPE, "putTime", this.monitor);
        this.loadsAverageLatency = new StatsAverageLatency("loadsCompleted", StatType.INT_TYPE, "loadTime", this.monitor);
        this.netLoadsAverageLatency = new StatsAverageLatency("netloadsCompleted", StatType.INT_TYPE, "netloadTime", this.monitor);
        this.netSearchAverageLatency = new StatsAverageLatency("netsearchesCompleted", StatType.INT_TYPE, "netsearchTime", this.monitor);
        this.transactionCommitsAvgLatency = new StatsAverageLatency("txCommits", StatType.INT_TYPE, "txCommitTime", this.monitor);
        this.diskFlushAvgLatency = new StatsAverageLatency("flushes", StatType.INT_TYPE, "flushTime", this.diskMonitor);
        this.deserializationAvgLatency = new StatsAverageLatency("deserializations", StatType.INT_TYPE, "deserializationTime", this.monitor);
        this.deserializationLatency = new StatsLatency("deserializations", StatType.INT_TYPE, "deserializationTime", this.monitor);
        this.deserializationRate = new StatsRate("deserializations", StatType.INT_TYPE, this.monitor);
        this.serializationAvgLatency = new StatsAverageLatency("serializations", StatType.INT_TYPE, "serializationTime", this.monitor);
        this.serializationLatency = new StatsLatency("serializations", StatType.INT_TYPE, "serializationTime", this.monitor);
        this.serializationRate = new StatsRate("serializations", StatType.INT_TYPE, this.monitor);
        this.pdxDeserializationAvgLatency = new StatsAverageLatency("pdxInstanceDeserializations", StatType.INT_TYPE, "pdxInstanceDeserializationTime", this.monitor);
        this.pdxDeserializationRate = new StatsRate("pdxInstanceDeserializations", StatType.INT_TYPE, this.monitor);
        this.lruDestroyRate = new StatsRate("lruDestroys", StatType.LONG_TYPE, (MBeanStatsMonitor)this.regionMonitor);
        this.lruEvictionRate = new StatsRate("lruEvictions", StatType.LONG_TYPE, (MBeanStatsMonitor)this.regionMonitor);
    }

    private void initGemfireProperties() {
        if (this.gemFirePropertyData == null) {
            this.gemFirePropertyData = BeanUtilFuncs.initGemfireProperties(this.config);
        }
    }

    JVMMetrics fetchJVMMetrics() {
        long gcCount = this.getGCStatistic("collections").longValue();
        long gcTimeMillis = this.getGCStatistic("collectionTime").longValue();
        long initMemory = this.memoryMXBean.getHeapMemoryUsage().getInit();
        long committedMemory = this.memoryMXBean.getHeapMemoryUsage().getCommitted();
        long usedMemory = this.getVMStatistic("usedMemory").longValue();
        long maxMemory = this.memoryMXBean.getHeapMemoryUsage().getMax();
        int totalThreads = this.getVMStatistic("threads").intValue();
        return new JVMMetrics(gcCount, gcTimeMillis, initMemory, committedMemory, usedMemory, maxMemory, totalThreads);
    }

    OSMetrics fetchOSMetrics() {
        try {
            long freeSwapSpaceSize;
            long totalSwapSpaceSize;
            long freePhysicalMemorySize;
            long totalPhysicalMemorySize;
            long committedVirtualMemorySize;
            long maxFileDescriptorCount;
            String name = this.osBean.getName();
            String version = this.osBean.getVersion();
            String arch = this.osBean.getArch();
            int availableProcessors = this.osBean.getAvailableProcessors();
            double systemLoadAverage = this.osBean.getSystemLoadAverage();
            long openFileDescriptorCount = this.getVMStatistic("fdsOpen").longValue();
            long processCpuTime = this.getVMStatistic("processCpuTime").longValue();
            try {
                maxFileDescriptorCount = (Long)ManagementFactory.getPlatformMBeanServer().getAttribute(this.osObjectName, "MaxFileDescriptorCount");
            }
            catch (Exception ignore) {
                maxFileDescriptorCount = -1L;
            }
            try {
                committedVirtualMemorySize = (Long)ManagementFactory.getPlatformMBeanServer().getAttribute(this.osObjectName, "CommittedVirtualMemorySize");
            }
            catch (Exception ignore) {
                committedVirtualMemorySize = -1L;
            }
            if (this.osStatisticsProvider.osStatsSupported() && this.systemStat != null) {
                try {
                    totalPhysicalMemorySize = this.systemStat.get("physicalMemory").longValue();
                }
                catch (Exception ignore) {
                    totalPhysicalMemorySize = -1L;
                }
                try {
                    freePhysicalMemorySize = this.systemStat.get("freeMemory").longValue();
                }
                catch (Exception ignore) {
                    freePhysicalMemorySize = -1L;
                }
                try {
                    totalSwapSpaceSize = this.systemStat.get("allocatedSwap").longValue();
                }
                catch (Exception ignore) {
                    totalSwapSpaceSize = -1L;
                }
                try {
                    freeSwapSpaceSize = this.systemStat.get("unallocatedSwap").longValue();
                }
                catch (Exception ignore) {
                    freeSwapSpaceSize = -1L;
                }
            } else {
                totalPhysicalMemorySize = -1L;
                freePhysicalMemorySize = -1L;
                totalSwapSpaceSize = -1L;
                freeSwapSpaceSize = -1L;
            }
            return new OSMetrics(maxFileDescriptorCount, openFileDescriptorCount, processCpuTime, committedVirtualMemorySize, totalPhysicalMemorySize, freePhysicalMemorySize, totalSwapSpaceSize, freeSwapSpaceSize, name, version, arch, availableProcessors, systemLoadAverage);
        }
        catch (Exception ex) {
            if (logger.isTraceEnabled()) {
                logger.trace(ex.getMessage(), (Throwable)ex);
            }
            return null;
        }
    }

    GemFireProperties getGemFireProperty() {
        return this.gemFirePropertyData;
    }

    boolean createManager() {
        if (this.service.isManager()) {
            return false;
        }
        return this.service.createManager();
    }

    String[] compactAllDiskStores() {
        ArrayList<String> compactedStores = new ArrayList<String>();
        if (this.cache != null && !this.cache.isClosed()) {
            for (DiskStore store : this.cache.listDiskStoresIncludingRegionOwned()) {
                if (!store.forceCompaction()) continue;
                compactedStores.add(((DiskStoreImpl)store).getPersistentID().getDirectory());
            }
        }
        String[] compactedStoresAr = new String[compactedStores.size()];
        return compactedStores.toArray(compactedStoresAr);
    }

    String[] listDiskStores(boolean includeRegionOwned) {
        Collection<DiskStore> diskCollection = includeRegionOwned ? this.cache.listDiskStoresIncludingRegionOwned() : this.cache.listDiskStores();
        String[] returnString = null;
        if (diskCollection != null && !diskCollection.isEmpty()) {
            returnString = new String[diskCollection.size()];
            Iterator<DiskStore> it = diskCollection.iterator();
            int i = 0;
            while (it.hasNext()) {
                returnString[i] = it.next().getName();
                ++i;
            }
        }
        return returnString;
    }

    String[] getDiskStores() {
        return this.listDiskStores(true);
    }

    String fetchLog(int numLines) {
        String mainTail;
        String childTail;
        block7: {
            if (numLines > 100) {
                numLines = 100;
            }
            if (numLines == 0 || numLines < 0) {
                numLines = 30;
            }
            childTail = null;
            try {
                InternalDistributedSystem sys = this.system;
                if (sys.getLogFile().isPresent()) {
                    LogFile logFile = sys.getLogFile().get();
                    childTail = BeanUtilFuncs.tailSystemLog(logFile.getChildLogFile(), numLines);
                    mainTail = BeanUtilFuncs.tailSystemLog(sys.getConfig(), numLines);
                    if (mainTail == null) {
                        mainTail = "No log file was specified in the configuration, messages will be directed to stdout.";
                    }
                    break block7;
                }
                throw new IllegalStateException("TailLogRequest/Response processed in application vm with shared logging. This would occur if there is no 'log-file' defined.");
            }
            catch (IOException e) {
                logger.warn("Error occurred while reading system log:", (Throwable)e);
                mainTail = "";
            }
        }
        StringBuilder result = new StringBuilder();
        result.append(mainTail);
        if (childTail != null) {
            result.append(SystemUtils.getLineSeparator()).append("-------------------- tail of child log --------------------").append(SystemUtils.getLineSeparator());
            result.append(childTail);
        }
        return result.toString();
    }

    void shutDownMember() {
        if (this.system.isConnected()) {
            LoggingThread t = new LoggingThread("Shutdown member", false, () -> {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ConnectionTable.threadWantsSharedResources();
                if (this.system.isConnected()) {
                    this.system.disconnect();
                }
            });
            t.start();
        }
    }

    String getName() {
        return this.name;
    }

    String getId() {
        return this.id;
    }

    String getMember() {
        if (this.name != null && !this.name.isEmpty()) {
            return this.name;
        }
        return this.id;
    }

    String[] getGroups() {
        List<String> groups = this.cache.getDistributedSystem().getDistributedMember().getGroups();
        String[] groupsArray = new String[groups.size()];
        groupsArray = groups.toArray(groupsArray);
        return groupsArray;
    }

    String getClassPath() {
        return this.classPath;
    }

    String[] listConnectedGatewayReceivers() {
        if (this.cache != null && !this.cache.getGatewayReceivers().isEmpty()) {
            Set<GatewayReceiver> receivers = this.cache.getGatewayReceivers();
            String[] receiverArray = new String[receivers.size()];
            int j = 0;
            for (GatewayReceiver recv : receivers) {
                receiverArray[j] = recv.getBindAddress();
                ++j;
            }
            return receiverArray;
        }
        return ManagementConstants.NO_DATA_STRING;
    }

    String[] listConnectedGatewaySenders() {
        if (this.cache != null && !this.cache.getGatewaySenders().isEmpty()) {
            Set<GatewaySender> senders = this.cache.getGatewaySenders();
            String[] senderArray = new String[senders.size()];
            int j = 0;
            for (GatewaySender sender : senders) {
                senderArray[j] = sender.getId();
                ++j;
            }
            return senderArray;
        }
        return ManagementConstants.NO_DATA_STRING;
    }

    float getCpuUsage() {
        return this.vmStatsMonitor.getCpuUsage();
    }

    long getCurrentTime() {
        return System.currentTimeMillis();
    }

    String getHost() {
        return this.hostname;
    }

    int getProcessId() {
        return this.processId;
    }

    String status() {
        if (LocatorLauncher.getInstance() != null) {
            return LocatorLauncher.getLocatorState().toJson();
        }
        if (ServerLauncher.getInstance() != null) {
            return ServerLauncher.getServerState().toJson();
        }
        return null;
    }

    String[] fetchJvmThreads() {
        long[] threadIds = this.threadMXBean.getAllThreadIds();
        ThreadInfo[] threadInfos = this.threadMXBean.getThreadInfo(threadIds, 0);
        if (threadInfos == null || threadInfos.length < 1) {
            return ManagementConstants.NO_DATA_STRING;
        }
        ArrayList<String> threadList = new ArrayList<String>(threadInfos.length);
        for (ThreadInfo threadInfo : threadInfos) {
            if (threadInfo == null) continue;
            threadList.add(threadInfo.getThreadName());
        }
        String[] result = new String[threadList.size()];
        return threadList.toArray(result);
    }

    String[] getListOfRegions() {
        Set<InternalRegion> listOfAppRegions = this.cache.getApplicationRegions();
        if (listOfAppRegions != null && !listOfAppRegions.isEmpty()) {
            String[] regions = new String[listOfAppRegions.size()];
            int j = 0;
            for (Region region : listOfAppRegions) {
                regions[j] = region.getFullPath();
                ++j;
            }
            return regions;
        }
        return ManagementConstants.NO_DATA_STRING;
    }

    long getLockLease() {
        return this.cache.getLockLease();
    }

    long getLockTimeout() {
        return this.cache.getLockTimeout();
    }

    long getMemberUpTime() {
        return this.cache.getUpTime();
    }

    String[] getRootRegionNames() {
        Set<Region<?, ?>> listOfRootRegions = this.cache.rootRegions();
        if (listOfRootRegions != null && !listOfRootRegions.isEmpty()) {
            String[] regionNames = new String[listOfRootRegions.size()];
            int j = 0;
            for (Region<?, ?> region : listOfRootRegions) {
                regionNames[j] = region.getFullPath();
                ++j;
            }
            return regionNames;
        }
        return ManagementConstants.NO_DATA_STRING;
    }

    String getVersion() {
        return this.gemFireVersion;
    }

    boolean hasGatewayReceiver() {
        return this.cache != null && !this.cache.getGatewayReceivers().isEmpty();
    }

    boolean hasGatewaySender() {
        return this.cache != null && !this.cache.getAllGatewaySenders().isEmpty();
    }

    boolean isLocator() {
        return Locator.hasLocator();
    }

    boolean isManager() {
        if (this.cache == null || this.cache.isClosed()) {
            return false;
        }
        try {
            return this.service.isManager();
        }
        catch (Exception ignore) {
            return false;
        }
    }

    boolean isManagerCreated() {
        if (this.cache == null || this.cache.isClosed()) {
            return false;
        }
        try {
            return this.service.isManagerCreated();
        }
        catch (Exception ignore) {
            return false;
        }
    }

    boolean isServer() {
        return this.cache.isServer();
    }

    public int getInitialImageKeysReceived() {
        return this.getMemberLevelStatistic("getInitialImageKeysReceived").intValue();
    }

    public long getInitialImageTime() {
        return this.getMemberLevelStatistic("getInitialImageTime").longValue();
    }

    public int getInitialImagesInProgress() {
        return this.getMemberLevelStatistic("getInitialImagesInProgress").intValue();
    }

    long getTotalIndexMaintenanceTime() {
        return this.getMemberLevelStatistic("indexUpdateTime").longValue();
    }

    public float getBytesReceivedRate() {
        return this.bytesReceivedRate.getRate();
    }

    public float getBytesSentRate() {
        return this.bytesSentRate.getRate();
    }

    public long getCacheListenerCallsAvgLatency() {
        return this.listenerCallsAvgLatency.getAverageLatency();
    }

    public long getCacheWriterCallsAvgLatency() {
        return this.writerCallsAvgLatency.getAverageLatency();
    }

    public float getCreatesRate() {
        this.instCreatesRate = this.createsRate.getRate();
        return this.instCreatesRate;
    }

    public float getDestroysRate() {
        return this.destroysRate.getRate();
    }

    public float getDiskReadsRate() {
        return this.diskReadsRate.getRate();
    }

    public float getDiskWritesRate() {
        return this.diskWritesRate.getRate();
    }

    public int getTotalBackupInProgress() {
        return this.diskMonitor.getBackupsInProgress();
    }

    public int getTotalBackupCompleted() {
        return this.diskMonitor.getBackupsCompleted();
    }

    public long getDiskFlushAvgLatency() {
        return this.diskFlushAvgLatency.getAverageLatency();
    }

    public float getFunctionExecutionRate() {
        return this.functionExecutionRate.getRate();
    }

    public long getGetsAvgLatency() {
        return this.getsAvgLatency.getAverageLatency();
    }

    public float getGetsRate() {
        this.instGetsRate = this.getsRate.getRate();
        return this.instGetsRate;
    }

    public int getLockWaitsInProgress() {
        return this.getMemberLevelStatistic("lockWaitsInProgress").intValue();
    }

    public int getNumRunningFunctions() {
        return this.getMemberLevelStatistic("functionExecutionsRunning").intValue();
    }

    public int getNumRunningFunctionsHavingResults() {
        return this.getMemberLevelStatistic("functionExecutionsHasResultRunning").intValue();
    }

    public long getPutAllAvgLatency() {
        return this.putAllAvgLatency.getAverageLatency();
    }

    public float getPutAllRate() {
        this.instPutAllRate = this.putAllRate.getRate();
        return this.instPutAllRate;
    }

    long getPutsAvgLatency() {
        return this.putsAvgLatency.getAverageLatency();
    }

    public float getPutsRate() {
        this.instPutsRate = this.putsRate.getRate();
        return this.instPutsRate;
    }

    public int getLockRequestQueues() {
        return this.getMemberLevelStatistic("requestQueues").intValue();
    }

    int getPartitionRegionCount() {
        return this.getMemberLevelStatistic("partitionedRegions").intValue();
    }

    public int getTotalPrimaryBucketCount() {
        return this.regionMonitor.getTotalPrimaryBucketCount();
    }

    public int getTotalBucketCount() {
        return this.regionMonitor.getTotalBucketCount();
    }

    public int getTotalBucketSize() {
        return this.regionMonitor.getTotalBucketSize();
    }

    public int getTotalHitCount() {
        return this.getMemberLevelStatistic("gets").intValue() - this.getTotalMissCount();
    }

    public float getLruDestroyRate() {
        return this.lruDestroyRate.getRate();
    }

    public float getLruEvictionRate() {
        return this.lruEvictionRate.getRate();
    }

    public int getTotalLoadsCompleted() {
        return this.getMemberLevelStatistic("loadsCompleted").intValue();
    }

    public long getLoadsAverageLatency() {
        return this.loadsAverageLatency.getAverageLatency();
    }

    public int getTotalNetLoadsCompleted() {
        return this.getMemberLevelStatistic("netloadsCompleted").intValue();
    }

    public long getNetLoadsAverageLatency() {
        return this.netLoadsAverageLatency.getAverageLatency();
    }

    public int getTotalNetSearchCompleted() {
        return this.getMemberLevelStatistic("netsearchesCompleted").intValue();
    }

    public long getNetSearchAverageLatency() {
        return this.netSearchAverageLatency.getAverageLatency();
    }

    public long getTotalLockWaitTime() {
        return this.getMemberLevelStatistic("lockWaitTime").intValue();
    }

    public int getTotalMissCount() {
        return this.getMemberLevelStatistic("misses").intValue();
    }

    public int getTotalNumberOfLockService() {
        return this.getMemberLevelStatistic("services").intValue();
    }

    public int getTotalNumberOfGrantors() {
        return this.getMemberLevelStatistic("grantors").intValue();
    }

    public int getTotalDiskTasksWaiting() {
        return this.getMemberLevelStatistic("diskTasksWaiting").intValue();
    }

    public int getTotalRegionCount() {
        return this.getMemberLevelStatistic("regions").intValue();
    }

    public int getTotalRegionEntryCount() {
        return this.getMemberLevelStatistic("entries").intValue();
    }

    public int getTotalTransactionsCount() {
        return this.getMemberLevelStatistic("txCommits").intValue() + this.getMemberLevelStatistic("txRollbacks").intValue();
    }

    public long getTransactionCommitsAvgLatency() {
        return this.transactionCommitsAvgLatency.getAverageLatency();
    }

    public float getTransactionCommitsRate() {
        return this.transactionCommitsRate.getRate();
    }

    public int getTransactionCommittedTotalCount() {
        return this.getMemberLevelStatistic("txCommits").intValue();
    }

    public int getTransactionRolledBackTotalCount() {
        return this.getMemberLevelStatistic("txRollbacks").intValue();
    }

    long getDeserializationAvgLatency() {
        return this.deserializationAvgLatency.getAverageLatency();
    }

    long getDeserializationLatency() {
        return this.deserializationLatency.getLatency();
    }

    float getDeserializationRate() {
        return this.deserializationRate.getRate();
    }

    long getSerializationAvgLatency() {
        return this.serializationAvgLatency.getAverageLatency();
    }

    long getSerializationLatency() {
        return this.serializationLatency.getLatency();
    }

    float getSerializationRate() {
        return this.serializationRate.getRate();
    }

    long getPDXDeserializationAvgLatency() {
        return this.pdxDeserializationAvgLatency.getAverageLatency();
    }

    float getPDXDeserializationRate() {
        return this.pdxDeserializationRate.getRate();
    }

    public String processCommand(String commandString, Map<String, String> environment, List<String> stagedFilePaths) {
        if (this.commandProcessor == null) {
            throw new JMRuntimeException("Command can not be processed as Command Service did not get initialized. Reason: " + this.commandServiceInitError);
        }
        return this.commandProcessor.executeCommandReturningJson(commandString, environment, stagedFilePaths);
    }

    public long getTotalDiskUsage() {
        return this.regionMonitor.getDiskSpace();
    }

    public float getAverageReads() {
        return this.instGetsRate;
    }

    public float getAverageWrites() {
        return this.instCreatesRate + this.instPutsRate + this.instPutAllRate;
    }

    public long getGarbageCollectionTime() {
        return this.getGCStatistic("collectionTime").longValue();
    }

    public long getGarbageCollectionCount() {
        return this.getGCStatistic("collections").longValue();
    }

    public long getJVMPauses() {
        return this.getSystemStatistic("jvmPauses").intValue();
    }

    double getLoadAverage() {
        return this.osBean.getSystemLoadAverage();
    }

    public int getNumThreads() {
        return this.getVMStatistic("threads").intValue();
    }

    long getFileDescriptorLimit() {
        if (!this.osName.startsWith("Linux")) {
            return -1L;
        }
        try {
            return (Long)ManagementFactory.getPlatformMBeanServer().getAttribute(this.osObjectName, "MaxFileDescriptorCount");
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    long getTotalFileDescriptorOpen() {
        if (!this.osName.startsWith("Linux")) {
            return -1L;
        }
        return this.getVMStatistic("fdsOpen").longValue();
    }

    int getOffHeapObjects() {
        int objects = 0;
        OffHeapMemoryStats stats = this.getOffHeapStats();
        if (null != stats) {
            objects = stats.getObjects();
        }
        return objects;
    }

    @Deprecated
    public long getOffHeapFreeSize() {
        return this.getOffHeapFreeMemory();
    }

    @Deprecated
    public long getOffHeapUsedSize() {
        return this.getOffHeapUsedMemory();
    }

    long getOffHeapMaxMemory() {
        OffHeapMemoryStats stats = this.getOffHeapStats();
        if (null != stats) {
            return stats.getMaxMemory();
        }
        return 0L;
    }

    long getOffHeapFreeMemory() {
        OffHeapMemoryStats stats = this.getOffHeapStats();
        if (null != stats) {
            return stats.getFreeMemory();
        }
        return 0L;
    }

    long getOffHeapUsedMemory() {
        OffHeapMemoryStats stats = this.getOffHeapStats();
        if (null != stats) {
            return stats.getUsedMemory();
        }
        return 0L;
    }

    int getOffHeapFragmentation() {
        OffHeapMemoryStats stats = this.getOffHeapStats();
        if (null != stats) {
            return stats.getFragmentation();
        }
        return 0;
    }

    long getOffHeapCompactionTime() {
        OffHeapMemoryStats stats = this.getOffHeapStats();
        if (null != stats) {
            return stats.getDefragmentationTime();
        }
        return 0L;
    }

    private OffHeapMemoryStats getOffHeapStats() {
        MemoryAllocator offHeap = this.cache.getOffHeapStore();
        if (null != offHeap) {
            return offHeap.getStats();
        }
        return null;
    }

    int getHostCpuUsage() {
        if (this.systemStat != null) {
            return this.systemStat.get("cpuActive").intValue();
        }
        return -1;
    }

    public boolean isCacheServer() {
        return this.cacheServer;
    }

    public void setCacheServer(boolean cacheServer) {
        this.cacheServer = cacheServer;
    }

    public String getRedundancyZone() {
        return this.redundancyZone;
    }

    int getRebalancesInProgress() {
        return this.resourceManagerStats.getRebalancesInProgress();
    }

    public int getReplyWaitsInProgress() {
        return this.getMemberLevelStatistic("replyWaitsInProgress").intValue();
    }

    public int getReplyWaitsCompleted() {
        return this.getMemberLevelStatistic("replyWaitsCompleted").intValue();
    }

    public int getVisibleNodes() {
        return this.getMemberLevelStatistic("nodes").intValue();
    }

    public long getMaxMemory() {
        return Runtime.getRuntime().maxMemory() / 0x100000L;
    }

    public long getFreeMemory() {
        return Runtime.getRuntime().freeMemory() / 0x100000L;
    }

    public long getUsedMemory() {
        return this.getVMStatistic("usedMemory").longValue() / 0x100000L;
    }

    String getReleaseVersion() {
        return GemFireVersion.getGemFireVersion();
    }

    String getGeodeReleaseVersion() {
        return Version.CURRENT.getName();
    }
}

