/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal;

import com.healthmarketscience.rmiio.exporter.RemoteStreamExporter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.rmi.AlreadyBoundException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.MBeanServerForwarder;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.management.remote.rmi.RMIJRMPServerImpl;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.GemFireConfigException;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.cache.internal.HttpService;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.internal.GemFireVersion;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.inet.LocalHostUtil;
import org.apache.geode.internal.net.SSLConfig;
import org.apache.geode.internal.net.SSLConfigurationFactory;
import org.apache.geode.internal.net.SocketCreator;
import org.apache.geode.internal.net.SocketCreatorFactory;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.internal.security.SecurityService;
import org.apache.geode.internal.security.shiro.JMXShiroAuthenticator;
import org.apache.geode.internal.tcp.TCPConduit;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.geode.management.ManagementException;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.ManagerMXBean;
import org.apache.geode.management.internal.AgentUtil;
import org.apache.geode.management.internal.BlockMBeanCreationController;
import org.apache.geode.management.internal.ContextAwareSSLRMIClientSocketFactory;
import org.apache.geode.management.internal.GeodeRemoteStreamExporter;
import org.apache.geode.management.internal.JmxRmiSerialFilter;
import org.apache.geode.management.internal.SystemManagementService;
import org.apache.geode.management.internal.beans.FileUploader;
import org.apache.geode.management.internal.security.AccessControlMBean;
import org.apache.geode.management.internal.security.MBeanServerWrapper;
import org.apache.geode.management.internal.unsafe.ReadOpFileAccessController;
import org.apache.geode.security.AuthTokenEnabledComponents;
import org.apache.logging.log4j.Logger;

public class ManagementAgent {
    private static final Logger logger = LogService.getLogger();
    public static final String SPRING_PROFILES_ACTIVE = "spring.profiles.active";
    private boolean running = false;
    private Registry registry;
    private JMXConnectorServer jmxConnectorServer;
    private JMXShiroAuthenticator shiroAuthenticator;
    private final DistributionConfig config;
    private final SecurityService securityService;
    private final InternalCache cache;
    private RMIClientSocketFactory rmiClientSocketFactory;
    private RMIServerSocketFactory rmiServerSocketFactory;
    private int port;
    private RemoteStreamExporter remoteStreamExporter = null;
    private final JmxRmiSerialFilter serialFilter;
    private static final String PULSE_EMBEDDED_PROP = "pulse.embedded";
    private static final String PULSE_HOST_PROP = "pulse.host";
    private static final String PULSE_PORT_PROP = "pulse.port";
    private static final String PULSE_USESSL_MANAGER = "pulse.useSSL.manager";
    private static final String PULSE_USESSL_LOCATOR = "pulse.useSSL.locator";
    private final String GEMFIRE_VERSION = GemFireVersion.getGemFireVersion();
    private final AgentUtil agentUtil = new AgentUtil(this.GEMFIRE_VERSION);

    public ManagementAgent(DistributionConfig config, InternalCache cache, JmxRmiSerialFilter serialFilter) {
        this.config = config;
        this.cache = cache;
        this.securityService = cache.getSecurityService();
        this.serialFilter = serialFilter;
    }

    public synchronized boolean isRunning() {
        return this.running;
    }

    public synchronized void startAgent() {
        this.serialFilter.configureSerialFilter();
        this.loadWebApplications();
        if (!this.running && this.config.getJmxManagerPort() != 0) {
            try {
                this.configureAndStart();
            }
            catch (IOException e) {
                throw new ManagementException(e);
            }
            this.running = true;
        }
    }

    public synchronized void stopAgent() {
        if (!this.running) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Stopping jmx manager agent");
        }
        try {
            this.jmxConnectorServer.stop();
            UnicastRemoteObject.unexportObject(this.registry, true);
        }
        catch (Exception e) {
            throw new ManagementException(e);
        }
        this.running = false;
    }

    private void loadWebApplications() {
        URI pulseWar;
        SystemManagementService managementService = (SystemManagementService)ManagementService.getManagementService(this.cache);
        ManagerMXBean managerBean = managementService.getManagerMXBean();
        if (this.config.getHttpServicePort() == 0) {
            this.setStatusMessage(managerBean, "Embedded HTTP server configured not to start (http-service-port=0) or (jmx-manager-http-port=0)");
            return;
        }
        URI adminRestWar = this.agentUtil.findWarLocation("geode-web");
        if (adminRestWar == null && logger.isDebugEnabled()) {
            logger.debug("Unable to find Geode V1 Management REST API WAR file; the Management REST Interface for Geode will not be accessible.");
        }
        if ((pulseWar = this.agentUtil.findWarLocation("geode-pulse")) == null) {
            String message = "Unable to find Pulse web application WAR file; Pulse for Geode will not be accessible";
            this.setStatusMessage(managerBean, "Unable to find Pulse web application WAR file; Pulse for Geode will not be accessible");
            if (logger.isDebugEnabled()) {
                logger.debug("Unable to find Pulse web application WAR file; Pulse for Geode will not be accessible");
            }
        } else {
            String pwFile = this.config.getJmxManagerPasswordFile();
            if (this.securityService.isIntegratedSecurity()) {
                String[] authTokenEnabledComponents = this.config.getSecurityAuthTokenEnabledComponents();
                boolean pulseOauth = Arrays.stream(authTokenEnabledComponents).anyMatch(AuthTokenEnabledComponents::hasPulse);
                if (pulseOauth) {
                    System.setProperty(SPRING_PROFILES_ACTIVE, "pulse.authentication.oauth");
                } else {
                    System.setProperty(SPRING_PROFILES_ACTIVE, "pulse.authentication.gemfire");
                }
            } else if (StringUtils.isNotBlank((CharSequence)pwFile)) {
                System.setProperty(SPRING_PROFILES_ACTIVE, "pulse.authentication.gemfire");
            }
        }
        try {
            HttpService httpService = this.cache.getService(HttpService.class);
            if (httpService != null && this.agentUtil.isAnyWarFileAvailable(adminRestWar, pulseWar)) {
                String bindAddress = this.config.getHttpServiceBindAddress();
                int port = this.config.getHttpServicePort();
                HashMap<String, Object> serviceAttributes = new HashMap<String, Object>();
                serviceAttributes.put("org.apache.geode.securityService", this.securityService);
                if (this.agentUtil.isAnyWarFileAvailable(adminRestWar)) {
                    Path adminRestWarPath = Paths.get(adminRestWar);
                    httpService.addWebApplication("/gemfire", adminRestWarPath, serviceAttributes);
                    httpService.addWebApplication("/geode-mgmt", adminRestWarPath, serviceAttributes);
                }
                if (this.agentUtil.isAnyWarFileAvailable(pulseWar)) {
                    System.setProperty(PULSE_EMBEDDED_PROP, "true");
                    System.setProperty(PULSE_HOST_PROP, "" + this.config.getJmxManagerBindAddress());
                    System.setProperty(PULSE_PORT_PROP, "" + this.config.getJmxManagerPort());
                    SocketCreator jmxSocketCreator = SocketCreatorFactory.getSocketCreatorForComponent(SecurableCommunicationChannel.JMX);
                    SocketCreator locatorSocketCreator = SocketCreatorFactory.getSocketCreatorForComponent(SecurableCommunicationChannel.LOCATOR);
                    System.setProperty(PULSE_USESSL_MANAGER, jmxSocketCreator.forClient().useSSL() + "");
                    System.setProperty(PULSE_USESSL_LOCATOR, locatorSocketCreator.forClient().useSSL() + "");
                    serviceAttributes.put("org.apache.geode.sslConfig", this.createSslProps());
                    httpService.addWebApplication("/pulse", Paths.get(pulseWar), serviceAttributes);
                    managerBean.setPulseURL("http://".concat(this.getHost(bindAddress)).concat(":").concat(String.valueOf(port)).concat("/pulse/"));
                }
            }
        }
        catch (Throwable e) {
            this.setStatusMessage(managerBean, "HTTP service failed to start with " + e.getClass().getSimpleName() + " '" + e.getMessage() + "'");
            throw new ManagementException("HTTP service failed to start", e);
        }
    }

    private Properties createSslProps() {
        Properties sslProps = new Properties();
        SSLConfig sslConfig = SSLConfigurationFactory.getSSLConfigForComponent(this.config, SecurableCommunicationChannel.WEB);
        if (StringUtils.isNotEmpty((CharSequence)sslConfig.getKeystore())) {
            sslProps.put("javax.net.ssl.keyStore", sslConfig.getKeystore());
        }
        if (StringUtils.isNotEmpty((CharSequence)sslConfig.getKeystorePassword())) {
            sslProps.put("javax.net.ssl.keyStorePassword", sslConfig.getKeystorePassword());
        }
        if (StringUtils.isNotEmpty((CharSequence)sslConfig.getKeystoreType())) {
            sslProps.put("javax.net.ssl.keyStoreType", sslConfig.getKeystoreType());
        }
        if (StringUtils.isNotEmpty((CharSequence)sslConfig.getTruststore())) {
            sslProps.put("javax.net.ssl.trustStore", sslConfig.getTruststore());
        }
        if (StringUtils.isNotEmpty((CharSequence)sslConfig.getTruststorePassword())) {
            sslProps.put("javax.net.ssl.trustStorePassword", sslConfig.getTruststorePassword());
        }
        if (StringUtils.isNotEmpty((CharSequence)sslConfig.getTruststoreType())) {
            sslProps.put("javax.net.ssl.trustStoreType", sslConfig.getTruststoreType());
        }
        if (StringUtils.isNotEmpty((CharSequence)sslConfig.getCiphers()) && !sslConfig.getCiphers().equalsIgnoreCase("any")) {
            sslProps.put("javax.rmi.ssl.client.enabledCipherSuites", sslConfig.getCiphers());
        }
        if (StringUtils.isNotEmpty((CharSequence)sslConfig.getProtocols()) && !sslConfig.getProtocols().equalsIgnoreCase("any")) {
            sslProps.put("javax.rmi.ssl.client.enabledProtocols", sslConfig.getProtocols());
        }
        return sslProps;
    }

    private String getHost(String bindAddress) throws UnknownHostException {
        if (StringUtils.isNotBlank((CharSequence)this.config.getJmxManagerHostnameForClients())) {
            return this.config.getJmxManagerHostnameForClients();
        }
        if (StringUtils.isNotBlank((CharSequence)bindAddress)) {
            return InetAddress.getByName(bindAddress).getHostAddress();
        }
        return LocalHostUtil.getLocalHost().getHostAddress();
    }

    private void setStatusMessage(ManagerMXBean mBean, String message) {
        mBean.setPulseURL("");
        mBean.setStatusMessage(message);
    }

    private void configureAndStart() throws IOException {
        InetAddress bindAddr;
        String hostname;
        this.port = this.config.getJmxManagerPort();
        if (StringUtils.isBlank((CharSequence)this.config.getJmxManagerBindAddress())) {
            hostname = LocalHostUtil.getLocalHostName();
            bindAddr = null;
        } else {
            hostname = this.config.getJmxManagerBindAddress();
            bindAddr = InetAddress.getByName(hostname);
        }
        String jmxManagerHostnameForClients = this.config.getJmxManagerHostnameForClients();
        if (StringUtils.isNotBlank((CharSequence)jmxManagerHostnameForClients)) {
            System.setProperty("java.rmi.server.hostname", jmxManagerHostnameForClients);
        }
        SocketCreator socketCreator = SocketCreatorFactory.getSocketCreatorForComponent(SecurableCommunicationChannel.JMX);
        boolean ssl = socketCreator.forClient().useSSL();
        if (logger.isDebugEnabled()) {
            logger.debug("Starting jmx manager agent on port {}{}", (Object)this.port, (Object)((bindAddr != null ? " bound to " + bindAddr : "") + (ssl ? " using SSL" : "")));
        }
        this.rmiClientSocketFactory = ssl ? new ContextAwareSSLRMIClientSocketFactory() : null;
        this.rmiServerSocketFactory = new GemFireRMIServerSocketFactory(socketCreator, bindAddr);
        System.setProperty("sun.rmi.dgc.server.gcInterval", Long.toString(0x7FFFFFFFFFFFFFFEL));
        this.registry = LocateRegistry.createRegistry(this.port, this.rmiClientSocketFactory, this.rmiServerSocketFactory);
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("jmx.remote.rmi.server.credential.types", new String[]{String[].class.getName(), String.class.getName()});
        final RMIJRMPServerImpl stub = new RMIJRMPServerImpl(this.port, this.rmiClientSocketFactory, this.rmiServerSocketFactory, env);
        final JMXServiceURL url = new JMXServiceURL("service:jmx:rmi://" + hostname + ":" + this.port + "/jndi/rmi://" + hostname + ":" + this.port + "/jmxrmi");
        this.jmxConnectorServer = new RMIConnectorServer(new JMXServiceURL("rmi", hostname, this.port), env, stub, mbs){

            @Override
            public JMXServiceURL getAddress() {
                return url;
            }

            @Override
            public synchronized void start() throws IOException {
                super.start();
                try {
                    ManagementAgent.this.registry.bind("jmxrmi", stub.toStub());
                }
                catch (AlreadyBoundException x) {
                    throw new IOException(x.getMessage(), x);
                }
            }
        };
        this.setMBeanServerForwarder(mbs, env);
        this.registerAccessControlMBean();
        this.registerFileUploaderMBean();
        this.jmxConnectorServer.start();
        if (logger.isDebugEnabled()) {
            logger.debug("Finished starting jmx manager agent.");
        }
    }

    @VisibleForTesting
    void setMBeanServerForwarder(MBeanServer mbs, HashMap<String, Object> env) throws IOException {
        if (this.securityService.isIntegratedSecurity()) {
            this.shiroAuthenticator = new JMXShiroAuthenticator(this.securityService);
            env.put("jmx.remote.authenticator", this.shiroAuthenticator);
            this.jmxConnectorServer.addNotificationListener(this.shiroAuthenticator, null, this.jmxConnectorServer.getAttributes());
            MBeanServerWrapper mBeanServerWrapper = new MBeanServerWrapper(this.securityService);
            this.jmxConnectorServer.setMBeanServerForwarder(mBeanServerWrapper);
        } else {
            String accessFile;
            String pwFile = this.config.getJmxManagerPasswordFile();
            if (pwFile != null && pwFile.length() > 0) {
                env.put("jmx.remote.x.password.file", pwFile);
            }
            if ((accessFile = this.config.getJmxManagerAccessFile()) != null && accessFile.length() > 0) {
                ReadOpFileAccessController controller = new ReadOpFileAccessController(accessFile);
                this.jmxConnectorServer.setMBeanServerForwarder((MBeanServerForwarder)((Object)controller));
            } else {
                this.jmxConnectorServer.setMBeanServerForwarder((MBeanServerForwarder)((Object)new BlockMBeanCreationController()));
            }
        }
    }

    private void registerAccessControlMBean() {
        block4: {
            try {
                AccessControlMBean acc = new AccessControlMBean(this.securityService);
                ObjectName accessControlMBeanON = new ObjectName("GemFire:service=AccessControl,type=Distributed");
                MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
                Set<ObjectName> names = platformMBeanServer.queryNames(accessControlMBeanON, null);
                if (!names.isEmpty()) break block4;
                try {
                    platformMBeanServer.registerMBean(acc, accessControlMBeanON);
                    logger.info("Registered AccessControlMBean on " + accessControlMBeanON);
                }
                catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException e) {
                    throw new GemFireConfigException("Error while configuring access control for jmx resource", e);
                }
            }
            catch (MalformedObjectNameException e) {
                throw new GemFireConfigException("Error while configuring access control for jmx resource", e);
            }
        }
    }

    private void registerFileUploaderMBean() {
        try {
            ObjectName mbeanON = new ObjectName("GemFire:service=FileUploader,type=Distributed");
            MBeanServer platformMBeanServer = ManagementFactory.getPlatformMBeanServer();
            Set<ObjectName> names = platformMBeanServer.queryNames(mbeanON, null);
            if (names.isEmpty()) {
                platformMBeanServer.registerMBean(new FileUploader(this.getRemoteStreamExporter()), mbeanON);
                logger.info("Registered FileUploaderMBean on " + mbeanON);
            }
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            throw new GemFireConfigException("Error while configuring FileUploader MBean", e);
        }
    }

    public JMXConnectorServer getJmxConnectorServer() {
        return this.jmxConnectorServer;
    }

    @VisibleForTesting
    void setJmxConnectorServer(JMXConnectorServer jmxConnectorServer) {
        this.jmxConnectorServer = jmxConnectorServer;
    }

    public synchronized RemoteStreamExporter getRemoteStreamExporter() {
        if (this.remoteStreamExporter == null) {
            this.remoteStreamExporter = new GeodeRemoteStreamExporter(this.port, this.rmiClientSocketFactory, this.rmiServerSocketFactory);
        }
        return this.remoteStreamExporter;
    }

    private static class GemFireRMIServerSocketFactory
    implements RMIServerSocketFactory,
    Serializable {
        private static final long serialVersionUID = -811909050641332716L;
        private transient SocketCreator sc;
        private final InetAddress bindAddr;

        public GemFireRMIServerSocketFactory(SocketCreator sc, InetAddress bindAddr) {
            this.sc = sc;
            this.bindAddr = bindAddr;
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            return this.sc.forCluster().createServerSocket(port, TCPConduit.getBackLog(), this.bindAddr);
        }
    }
}

