/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.net;

import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.IdentityHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.annotations.VisibleForTesting;
import org.apache.geode.distributed.internal.DMStats;
import org.apache.geode.internal.Assert;
import org.apache.geode.internal.tcp.Connection;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public class BufferPool {
    private final DMStats stats;
    private static final Logger logger = LogService.getLogger();
    private Method parentOfSliceMethod;
    private final ConcurrentLinkedQueue<BBSoftReference> bufferSmallQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<BBSoftReference> bufferMiddleQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<BBSoftReference> bufferLargeQueue = new ConcurrentLinkedQueue();
    static final int SMALL_BUFFER_SIZE = Connection.SMALL_BUFFER_SIZE;
    static final int MEDIUM_BUFFER_SIZE = 32768;
    public static final boolean useDirectBuffers = !Boolean.getBoolean("p2p.nodirectBuffers") || Boolean.getBoolean("gemfire.BufferPool.useHeapBuffers");

    public BufferPool(DMStats stats) {
        this.stats = stats;
    }

    public ByteBuffer acquireDirectSenderBuffer(int size) {
        return this.acquireDirectBuffer(size, true);
    }

    public ByteBuffer acquireDirectReceiveBuffer(int size) {
        return this.acquireDirectBuffer(size, false);
    }

    private ByteBuffer acquireDirectBuffer(int size, boolean send) {
        if (useDirectBuffers) {
            ByteBuffer result = size <= 32768 ? this.acquirePredefinedFixedBuffer(send, size) : this.acquireLargeBuffer(send, size);
            if (result.capacity() > size) {
                result.position(0).limit(size);
                result = result.slice();
            }
            return result;
        }
        ByteBuffer result = ByteBuffer.allocate(size);
        this.updateBufferStats(size, send, false);
        return result;
    }

    public ByteBuffer acquireNonDirectSenderBuffer(int size) {
        ByteBuffer result = ByteBuffer.allocate(size);
        this.stats.incSenderBufferSize(size, false);
        return result;
    }

    public ByteBuffer acquireNonDirectReceiveBuffer(int size) {
        ByteBuffer result = ByteBuffer.allocate(size);
        this.stats.incReceiverBufferSize(size, false);
        return result;
    }

    private ByteBuffer acquirePredefinedFixedBuffer(boolean send, int size) {
        ConcurrentLinkedQueue<BBSoftReference> bufferTempQueue;
        int defaultSize;
        if (size <= SMALL_BUFFER_SIZE) {
            defaultSize = SMALL_BUFFER_SIZE;
            bufferTempQueue = this.bufferSmallQueue;
        } else {
            defaultSize = 32768;
            bufferTempQueue = this.bufferMiddleQueue;
        }
        BBSoftReference ref = bufferTempQueue.poll();
        while (ref != null) {
            ByteBuffer bb = ref.getBB();
            if (bb != null) {
                bb.clear();
                if (defaultSize > size) {
                    bb.limit(size);
                }
                return bb;
            }
            this.updateBufferStats(-defaultSize, ref.getSend(), true);
            ref = bufferTempQueue.poll();
        }
        ByteBuffer result = ByteBuffer.allocateDirect(defaultSize);
        this.updateBufferStats(defaultSize, send, true);
        if (defaultSize > size) {
            result.limit(size);
        }
        return result;
    }

    private ByteBuffer acquireLargeBuffer(boolean send, int size) {
        IdentityHashMap<BBSoftReference, BBSoftReference> alreadySeen = null;
        BBSoftReference ref = this.bufferLargeQueue.poll();
        while (ref != null) {
            ByteBuffer bb = ref.getBB();
            if (bb == null) {
                int refSize = ref.consumeSize();
                if (refSize > 0) {
                    this.updateBufferStats(-refSize, ref.getSend(), true);
                }
            } else {
                if (bb.capacity() >= size) {
                    bb.clear();
                    if (bb.capacity() > size) {
                        bb.limit(size);
                    }
                    return bb;
                }
                Assert.assertTrue(this.bufferLargeQueue.offer(ref));
                if (alreadySeen == null) {
                    alreadySeen = new IdentityHashMap<BBSoftReference, BBSoftReference>();
                }
                if (alreadySeen.put(ref, ref) != null) break;
            }
            ref = this.bufferLargeQueue.poll();
        }
        ByteBuffer result = ByteBuffer.allocateDirect(size);
        this.updateBufferStats(size, send, true);
        return result;
    }

    public void releaseSenderBuffer(ByteBuffer bb) {
        this.releaseBuffer(bb, true);
    }

    public void releaseReceiveBuffer(ByteBuffer bb) {
        this.releaseBuffer(bb, false);
    }

    ByteBuffer expandReadBufferIfNeeded(BufferType type, ByteBuffer existing, int desiredCapacity) {
        if (existing.capacity() >= desiredCapacity) {
            if (existing.position() > 0) {
                existing.compact();
                existing.flip();
            }
            return existing;
        }
        ByteBuffer newBuffer = existing.isDirect() ? this.acquireDirectBuffer(type, desiredCapacity) : this.acquireNonDirectBuffer(type, desiredCapacity);
        newBuffer.clear();
        newBuffer.put(existing);
        newBuffer.flip();
        this.releaseBuffer(type, existing);
        return newBuffer;
    }

    ByteBuffer expandWriteBufferIfNeeded(BufferType type, ByteBuffer existing, int desiredCapacity) {
        if (existing.capacity() >= desiredCapacity) {
            return existing;
        }
        ByteBuffer newBuffer = existing.isDirect() ? this.acquireDirectBuffer(type, desiredCapacity) : this.acquireNonDirectBuffer(type, desiredCapacity);
        newBuffer.clear();
        existing.flip();
        newBuffer.put(existing);
        this.releaseBuffer(type, existing);
        return newBuffer;
    }

    ByteBuffer acquireDirectBuffer(BufferType type, int capacity) {
        switch (type) {
            case UNTRACKED: {
                return ByteBuffer.allocate(capacity);
            }
            case TRACKED_SENDER: {
                return this.acquireDirectSenderBuffer(capacity);
            }
            case TRACKED_RECEIVER: {
                return this.acquireDirectReceiveBuffer(capacity);
            }
        }
        throw new IllegalArgumentException("Unexpected buffer type " + type.toString());
    }

    ByteBuffer acquireNonDirectBuffer(BufferType type, int capacity) {
        switch (type) {
            case UNTRACKED: {
                return ByteBuffer.allocate(capacity);
            }
            case TRACKED_SENDER: {
                return this.acquireNonDirectSenderBuffer(capacity);
            }
            case TRACKED_RECEIVER: {
                return this.acquireNonDirectReceiveBuffer(capacity);
            }
        }
        throw new IllegalArgumentException("Unexpected buffer type " + type.toString());
    }

    void releaseBuffer(BufferType type, ByteBuffer buffer) {
        switch (type) {
            case UNTRACKED: {
                return;
            }
            case TRACKED_SENDER: {
                this.releaseSenderBuffer(buffer);
                return;
            }
            case TRACKED_RECEIVER: {
                this.releaseReceiveBuffer(buffer);
                return;
            }
        }
        throw new IllegalArgumentException("Unexpected buffer type " + type.toString());
    }

    private void releaseBuffer(ByteBuffer buffer, boolean send) {
        if (buffer.isDirect()) {
            buffer = this.getPoolableBuffer(buffer);
            BBSoftReference bbRef = new BBSoftReference(buffer, send);
            if (buffer.capacity() <= SMALL_BUFFER_SIZE) {
                this.bufferSmallQueue.offer(bbRef);
            } else if (buffer.capacity() <= 32768) {
                this.bufferMiddleQueue.offer(bbRef);
            } else {
                this.bufferLargeQueue.offer(bbRef);
            }
        } else {
            this.updateBufferStats(-buffer.capacity(), send, false);
        }
    }

    @VisibleForTesting
    public ByteBuffer getPoolableBuffer(ByteBuffer buffer) {
        if (!buffer.isDirect()) {
            return buffer;
        }
        ByteBuffer result = buffer;
        if (this.parentOfSliceMethod == null) {
            Class<?> clazz = buffer.getClass();
            try {
                Method method = clazz.getMethod("attachment", new Class[0]);
                method.setAccessible(true);
                this.parentOfSliceMethod = method;
            }
            catch (Exception e) {
                throw new InternalGemFireException("unable to retrieve underlying byte buffer", e);
            }
        }
        try {
            Object attachment = this.parentOfSliceMethod.invoke((Object)buffer, new Object[0]);
            if (attachment instanceof ByteBuffer) {
                result = (ByteBuffer)attachment;
            } else if (attachment != null) {
                throw new InternalGemFireException("direct byte buffer attachment was not a byte buffer but a " + attachment.getClass().getName());
            }
        }
        catch (Exception e) {
            throw new InternalGemFireException("unable to retrieve underlying byte buffer", e);
        }
        return result;
    }

    private void updateBufferStats(int size, boolean send, boolean direct) {
        if (send) {
            this.stats.incSenderBufferSize(size, direct);
        } else {
            this.stats.incReceiverBufferSize(size, direct);
        }
    }

    private static class BBSoftReference
    extends SoftReference<ByteBuffer> {
        private int size;
        private final boolean send;

        BBSoftReference(ByteBuffer bb, boolean send) {
            super(bb);
            this.size = bb.capacity();
            this.send = send;
        }

        public int getSize() {
            return this.size;
        }

        synchronized int consumeSize() {
            int result = this.size;
            this.size = 0;
            return result;
        }

        public boolean getSend() {
            return this.send;
        }

        public ByteBuffer getBB() {
            return (ByteBuffer)super.get();
        }
    }

    public static enum BufferType {
        UNTRACKED,
        TRACKED_SENDER,
        TRACKED_RECEIVER;

    }
}

