/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.distributed.internal;

import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.InternalGemFireException;
import org.apache.geode.InvalidValueException;
import org.apache.geode.UnmodifiableException;
import org.apache.geode.annotations.Immutable;
import org.apache.geode.distributed.internal.ConfigAttribute;
import org.apache.geode.distributed.internal.ConfigAttributeChecker;
import org.apache.geode.distributed.internal.DistributionConfig;
import org.apache.geode.distributed.internal.FlowControlParams;
import org.apache.geode.internal.AbstractConfig;
import org.apache.geode.internal.ConfigSource;
import org.apache.geode.internal.admin.remote.DistributionLocatorId;
import org.apache.geode.internal.inet.LocalHostUtil;
import org.apache.geode.internal.logging.LogWriterImpl;
import org.apache.geode.internal.security.SecurableCommunicationChannel;
import org.apache.geode.logging.internal.log4j.LogLevel;
import org.apache.geode.logging.internal.log4j.api.LogService;
import org.apache.logging.log4j.Logger;

public abstract class AbstractDistributionConfig
extends AbstractConfig
implements DistributionConfig {
    private static final Logger logger = LogService.getLogger();
    @Immutable
    static final Map dcAttDescriptions;
    @Immutable
    static final Map<String, Method> checkers;

    Object checkAttribute(String attName, Object value) {
        Method checker;
        if (!this.isAttributeModifiable(attName)) {
            throw new UnmodifiableException(this._getUnmodifiableMsg(attName));
        }
        ConfigAttribute attribute = (ConfigAttribute)attributes.get(attName);
        if (attribute == null) {
            return value;
        }
        if (attribute.type().equals(Integer.class)) {
            Integer intValue = (Integer)value;
            this.minMaxCheck(attName, intValue, attribute.min(), attribute.max());
        }
        if ((checker = checkers.get(attName)) == null) {
            return value;
        }
        try {
            return checker.invoke((Object)this, value);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new InternalGemFireException("error invoking " + checker.getName() + " with value " + value);
        }
    }

    private void minMaxCheck(String propName, int value, int minValue, int maxValue) {
        if (value < minValue) {
            throw new IllegalArgumentException(String.format("Could not set \"%s\" to \"%s\" because its value can not be less than \"%s\".", propName, value, minValue));
        }
        if (value > maxValue) {
            throw new IllegalArgumentException(String.format("Could not set \"%s\" to \"%s\" because its value can not be greater than \"%s\".", propName, value, maxValue));
        }
    }

    @ConfigAttributeChecker(name="start-locator")
    protected String checkStartLocator(String value) {
        if (value != null && value.trim().length() > 0) {
            new DistributionLocatorId(value);
        }
        return value;
    }

    @ConfigAttributeChecker(name="tcp-port")
    protected int checkTcpPort(int value) {
        if (this.getClusterSSLEnabled() && value != 0) {
            throw new IllegalArgumentException(String.format("Could not set %s to %s because its value must be 0 when %s is true.", "tcp-port", value, "cluster-ssl-enabled"));
        }
        return value;
    }

    @ConfigAttributeChecker(name="mcast-port")
    protected int checkMcastPort(int value) {
        if (this.getClusterSSLEnabled() && value != 0) {
            throw new IllegalArgumentException(String.format("Could not set %s to %s because its value must be 0 when %s is true.", "mcast-port", value, "cluster-ssl-enabled"));
        }
        return value;
    }

    @ConfigAttributeChecker(name="mcast-address")
    protected InetAddress checkMcastAddress(InetAddress value) {
        if (!value.isMulticastAddress()) {
            throw new IllegalArgumentException(String.format("Could not set %s to %s because it was not a multicast address.", "mcast-address", value));
        }
        return value;
    }

    @ConfigAttributeChecker(name="bind-address")
    protected String checkBindAddress(String value) {
        if (value != null && value.length() > 0 && !LocalHostUtil.isLocalHost((Object)value)) {
            throw new IllegalArgumentException(String.format("The bind-address %s is not a valid address for this machine.  These are the valid addresses for this machine: %s", value, LocalHostUtil.getMyAddresses()));
        }
        return value;
    }

    @ConfigAttributeChecker(name="server-bind-address")
    protected String checkServerBindAddress(String value) {
        if (value != null && value.length() > 0 && !LocalHostUtil.isLocalHost((Object)value)) {
            throw new IllegalArgumentException(String.format("The bind-address %s is not a valid address for this machine.  These are the valid addresses for this machine: %s", value, LocalHostUtil.getMyAddresses()));
        }
        return value;
    }

    @ConfigAttributeChecker(name="cluster-ssl-enabled")
    protected Boolean checkClusterSSLEnabled(Boolean value) {
        if (value.booleanValue() && this.getMcastPort() != 0) {
            throw new IllegalArgumentException(String.format("Could not set %s to %s because its value must be false when %s is not 0.", "cluster-ssl-enabled", value, "mcast-port"));
        }
        return value;
    }

    @ConfigAttributeChecker(name="http-service-bind-address")
    protected String checkHttpServiceBindAddress(String value) {
        if (value != null && value.length() > 0 && !LocalHostUtil.isLocalHost((Object)value)) {
            throw new IllegalArgumentException(String.format("The bind-address %s is not a valid address for this machine.  These are the valid addresses for this machine: %s", value, LocalHostUtil.getMyAddresses()));
        }
        return value;
    }

    @ConfigAttributeChecker(name="distributed-system-id")
    protected int checkDistributedSystemId(int value) {
        String distributedSystemListener = System.getProperty("gemfire.DistributedSystemListener");
        if (distributedSystemListener == null && value < -1) {
            throw new IllegalArgumentException(String.format("Could not set \"%s\" to \"%s\" because its value can not be less than \"%s\".", "distributed-system-id", value, -1));
        }
        if (value > 255) {
            throw new IllegalArgumentException(String.format("Could not set \"%s\" to \"%s\" because its value can not be greater than \"%s\".", "distributed-system-id", value, 255));
        }
        return value;
    }

    @ConfigAttributeChecker(name="locators")
    protected String checkLocators(String value) {
        StringBuilder sb = new StringBuilder();
        HashSet<InetSocketAddress> locs = new HashSet<InetSocketAddress>();
        StringTokenizer st = new StringTokenizer(value, ",");
        boolean firstUniqueLocator = true;
        while (st.hasMoreTokens()) {
            int portVal;
            int lastIndex;
            String host;
            String locator = st.nextToken();
            StringBuilder locatorsb = new StringBuilder();
            int portIndex = locator.indexOf(91);
            if (portIndex < 1) {
                portIndex = locator.lastIndexOf(58);
            }
            if (portIndex < 1) {
                throw new IllegalArgumentException(String.format("Invalid locator %s. Host name was empty.", value));
            }
            int bindAddrIdx = locator.lastIndexOf(64, portIndex - 1);
            if (bindAddrIdx < 0) {
                bindAddrIdx = locator.lastIndexOf(58, portIndex - 1);
            }
            if ((host = locator.substring(0, bindAddrIdx > -1 ? bindAddrIdx : portIndex)).indexOf(58) >= 0) {
                bindAddrIdx = locator.lastIndexOf(64);
                host = locator.substring(0, bindAddrIdx > -1 ? bindAddrIdx : portIndex);
            }
            InetAddress hostAddress = null;
            try {
                hostAddress = InetAddress.getByName(host);
            }
            catch (UnknownHostException ex) {
                logger.warn("Unknown locator host: " + host);
            }
            locatorsb.append(host);
            if (bindAddrIdx > -1) {
                String bindAddr = locator.substring(bindAddrIdx + 1, portIndex);
                try {
                    hostAddress = InetAddress.getByName(bindAddr);
                }
                catch (UnknownHostException ex) {
                    throw new IllegalArgumentException(String.format("Unknown locator bind address: %s", bindAddr));
                }
                if (bindAddr.indexOf(58) >= 0) {
                    locatorsb.append('@');
                } else {
                    locatorsb.append(':');
                }
                locatorsb.append(bindAddr);
            }
            if ((lastIndex = locator.lastIndexOf(93)) == -1) {
                if (locator.indexOf(91) >= 0) {
                    throw new IllegalArgumentException(String.format("Invalid locator: %s", value));
                }
                lastIndex = locator.length();
            }
            String port = locator.substring(portIndex + 1, lastIndex);
            try {
                portVal = Integer.parseInt(port);
                if (0 == portVal) {
                    return "";
                }
                if (portVal < 1 || portVal > 65535) {
                    throw new IllegalArgumentException(String.format("Invalid locator %s. The port %s was not greater than zero and less than 65,536.", value, portVal));
                }
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException(String.format("Invalid locator: %s", value));
            }
            locatorsb.append('[');
            locatorsb.append(port);
            locatorsb.append(']');
            InetSocketAddress sockAddr = new InetSocketAddress(hostAddress, portVal);
            if (locs.contains(sockAddr)) continue;
            if (!firstUniqueLocator) {
                sb.append(',');
            } else {
                firstUniqueLocator = false;
            }
            locs.add(new InetSocketAddress(hostAddress, portVal));
            sb.append((CharSequence)locatorsb);
        }
        return sb.toString();
    }

    @ConfigAttributeChecker(name="mcast-flow-control")
    protected FlowControlParams checkMcastFlowControl(FlowControlParams params) {
        int value = params.getByteAllowance();
        if (value < 10000) {
            throw new IllegalArgumentException(String.format("Could not set %s.byteAllowance to %s because its value can not be less than %s", "mcast-flow-control", value, 10000));
        }
        float fvalue = params.getRechargeThreshold();
        if (fvalue < 0.1f) {
            throw new IllegalArgumentException(String.format("Could not set %s.rechargeThreshold to %s because its value can not be less than %s", "mcast-flow-control", Float.valueOf(fvalue), Float.valueOf(0.1f)));
        }
        if (fvalue > 0.5f) {
            throw new IllegalArgumentException(String.format("Could not set %s.rechargeThreshold to %s because its value can not be greater than %s", "mcast-flow-control", Float.valueOf(fvalue), Float.valueOf(0.5f)));
        }
        value = params.getRechargeBlockMs();
        if (value < 500) {
            throw new IllegalArgumentException(String.format("Could not set %s.rechargeBlockMs to %s because its value can not be less than %s", "mcast-flow-control", value, 500));
        }
        if (value > 60000) {
            throw new IllegalArgumentException(String.format("Could not set %s.rechargeBlockMs to %s because its value can not be greater than %s", "mcast-flow-control", value, 60000));
        }
        return params;
    }

    @ConfigAttributeChecker(name="membership-port-range")
    protected int[] checkMembershipPortRange(int[] value) {
        this.minMaxCheck("membership-port-range", value[0], 1024, value[1]);
        this.minMaxCheck("membership-port-range", value[1], value[0], 65535);
        if (value[1] - value[0] < 2) {
            throw new IllegalArgumentException(String.format("Could not set \"%s\" to \"%s\" because its value can not be less than \"%s\".", "membership-port-range", value[0] + "-" + value[1], 3));
        }
        return value;
    }

    @ConfigAttributeChecker(name="conflate-events")
    protected String checkClientConflation(String value) {
        if (!(value.equals("server") || value.equals("true") || value.equals("false"))) {
            throw new IllegalArgumentException("Could not set \"conflate-events\" to \"" + value + "\" because its value is not recognized");
        }
        return value;
    }

    @ConfigAttributeChecker(name="security-peer-auth-init")
    protected String checkSecurityPeerAuthInit(String value) {
        if (value != null && value.length() > 0 && this.getMcastPort() != 0) {
            String mcastInfo = "mcast-port[" + this.getMcastPort() + "]";
            throw new IllegalArgumentException(String.format("Could not set %s to %s because %s must be 0 when security is enabled.", "security-peer-auth-init", value, mcastInfo));
        }
        return value;
    }

    @ConfigAttributeChecker(name="security-peer-authenticator")
    protected String checkSecurityPeerAuthenticator(String value) {
        if (value != null && value.length() > 0 && this.getMcastPort() != 0) {
            String mcastInfo = "mcast-port[" + this.getMcastPort() + "]";
            throw new IllegalArgumentException(String.format("Could not set %s to %s because %s must be 0 when security is enabled.", "security-peer-authenticator", value, mcastInfo));
        }
        return value;
    }

    @ConfigAttributeChecker(name="security-log-level")
    protected int checkSecurityLogLevel(int value) {
        if (value < MIN_LOG_LEVEL) {
            throw new IllegalArgumentException(String.format("Could not set \"%s\" to \"%s\" because its value can not be less than \"%s\".", "security-log-level", LogWriterImpl.levelToString(value), LogWriterImpl.levelToString(MIN_LOG_LEVEL)));
        }
        if (value > MAX_LOG_LEVEL) {
            throw new IllegalArgumentException(String.format("Could not set \"%s\" to \"%s\" because its value can not be greater than \"%s\".", "security-log-level", LogWriterImpl.levelToString(value), LogWriterImpl.levelToString(MAX_LOG_LEVEL)));
        }
        return value;
    }

    @ConfigAttributeChecker(name="memcached-protocol")
    protected String checkMemcachedProtocol(String protocol) {
        if (protocol == null || !protocol.equalsIgnoreCase("ASCII") && !protocol.equalsIgnoreCase("BINARY")) {
            throw new IllegalArgumentException("memcached-protocol must be ASCII or BINARY ");
        }
        return protocol;
    }

    public boolean isMemcachedProtocolModifiable() {
        return false;
    }

    @ConfigAttributeChecker(name="memcached-bind-address")
    protected String checkMemcachedBindAddress(String value) {
        if (value != null && value.length() > 0 && !LocalHostUtil.isLocalHost((Object)value)) {
            throw new IllegalArgumentException(String.format("The memcached-bind-address %s is not a valid address for this machine.  These are the valid addresses for this machine: %s", value, LocalHostUtil.getMyAddresses()));
        }
        return value;
    }

    @ConfigAttributeChecker(name="redis-bind-address")
    protected String checkRedisBindAddress(String value) {
        if (value != null && value.length() > 0 && !LocalHostUtil.isLocalHost((Object)value)) {
            throw new IllegalArgumentException(String.format("The redis-bind-address %s is not a valid address for this machine.  These are the valid addresses for this machine: %s", value, LocalHostUtil.getMyAddresses()));
        }
        return value;
    }

    @ConfigAttributeChecker(name="ssl-enabled-components")
    protected SecurableCommunicationChannel[] checkLegacySSLWhenSSLEnabledComponentsSet(SecurableCommunicationChannel[] value) {
        block3: for (SecurableCommunicationChannel component : value) {
            switch (component) {
                case ALL: 
                case CLUSTER: 
                case SERVER: 
                case GATEWAY: 
                case JMX: 
                case WEB: 
                case LOCATOR: {
                    continue block3;
                }
                default: {
                    throw new IllegalArgumentException(String.format("%s is not in the valid set of options %s", Arrays.toString((Object[])value), StringUtils.join((Object[])new String[]{SecurableCommunicationChannel.ALL.getConstant(), SecurableCommunicationChannel.CLUSTER.getConstant(), SecurableCommunicationChannel.SERVER.getConstant(), SecurableCommunicationChannel.GATEWAY.getConstant(), SecurableCommunicationChannel.JMX.getConstant(), SecurableCommunicationChannel.WEB.getConstant(), SecurableCommunicationChannel.LOCATOR.getConstant()}, (String)",")));
                }
            }
        }
        if (value.length > 0 && (this.getClusterSSLEnabled() || this.getJmxManagerSSLEnabled() || this.getHttpServiceSSLEnabled() || this.getServerSSLEnabled() || this.getGatewaySSLEnabled())) {
            throw new IllegalArgumentException("When using ssl-enabled-components one cannot use any other SSL properties other than cluster-ssl-* or the corresponding aliases");
        }
        return value;
    }

    @Override
    protected void checkAttributeName(String attName) {
        if (!(attName.startsWith("security-") || attName.startsWith("custom-") || attName.startsWith("javax.net.ssl") || attName.startsWith("sysprop-"))) {
            super.checkAttributeName(attName);
        }
    }

    public static boolean isWellKnownAttribute(String attName) {
        return Arrays.binarySearch(dcValidAttributeNames, attName) >= 0;
    }

    @Override
    public void setAttributeObject(String attName, Object attValue, ConfigSource source) {
        Method setter;
        Class validValueClass = this.getAttributeType(attName);
        if (attValue != null && !validValueClass.isInstance(attValue)) {
            throw new InvalidValueException(String.format("%s value %s must be of type %s", attName, attValue, validValueClass.getName()));
        }
        if (attName.startsWith("custom-")) {
            return;
        }
        if ((attName.equalsIgnoreCase("log-level") || attName.equalsIgnoreCase("security-log-level")) && attValue instanceof String) {
            attValue = LogLevel.getLogWriterLevel((String)attValue);
        }
        if (attName.startsWith("security-")) {
            if (attValue instanceof Object[]) {
                this.setSecurity(attName, StringUtils.join((Object[])((Object[])attValue), (char)','));
            } else {
                this.setSecurity(attName, attValue.toString());
            }
        }
        if (attName.startsWith("javax.net.ssl") || attName.startsWith("sysprop-")) {
            this.setSSLProperty(attName, attValue.toString());
        }
        if ((setter = (Method)setters.get(attName)) == null) {
            if (attName.startsWith("security-") || attName.startsWith("javax.net.ssl") || attName.startsWith("sysprop-")) {
                this.getAttSourceMap().put(attName, source);
                return;
            }
            throw new InternalGemFireException(String.format("unhandled attribute name %s.", attName));
        }
        Class<?>[] pTypes = setter.getParameterTypes();
        if (pTypes.length != 1) {
            throw new InternalGemFireException("the attribute setter must have one and only one parametter");
        }
        this.checkAttribute(attName, attValue);
        try {
            setter.invoke((Object)this, attValue);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new InternalGemFireException("error invoking " + setter.getName() + " with " + attValue, e);
        }
        this.getAttSourceMap().put(attName, source);
    }

    @Override
    public Object getAttributeObject(String attName) {
        this.checkAttributeName(attName);
        if (attName.equalsIgnoreCase("log-level")) {
            return LogWriterImpl.levelToString(this.getLogLevel());
        }
        if (attName.equalsIgnoreCase("security-log-level")) {
            return LogWriterImpl.levelToString(this.getSecurityLogLevel());
        }
        Method getter = (Method)getters.get(attName);
        if (getter == null) {
            if (attName.startsWith("security-")) {
                return this.getSecurity(attName);
            }
            throw new InternalGemFireException(String.format("unhandled attribute name %s.", attName));
        }
        try {
            return getter.invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new InternalGemFireException("error invoking " + getter.getName(), e);
        }
    }

    @Override
    public boolean isAttributeModifiable(String name) {
        this.checkAttributeName(name);
        if (this.getModifiableAttributes().contains(name)) {
            return true;
        }
        if (this.getUnModifiableAttributes().contains(name)) {
            return false;
        }
        return this._modifiableDefault();
    }

    public List<String> getModifiableAttributes() {
        String[] modifiables = new String[]{"http-service-port", "jmx-manager-http-port"};
        return Arrays.asList(modifiables);
    }

    private List<String> getUnModifiableAttributes() {
        return new ArrayList<String>();
    }

    @Override
    public Class getAttributeType(String attName) {
        this.checkAttributeName(attName);
        return AbstractDistributionConfig._getAttributeType(attName);
    }

    static Class _getAttributeType(String attName) {
        ConfigAttribute ca = (ConfigAttribute)attributes.get(attName);
        if (ca == null) {
            if (attName.startsWith("security-") || attName.startsWith("javax.net.ssl") || attName.startsWith("sysprop-")) {
                return String.class;
            }
            throw new InternalGemFireException(String.format("unhandled attribute name %s.", attName));
        }
        return ca.type();
    }

    public static String[] _getAttNames() {
        return dcValidAttributeNames;
    }

    @Override
    public String[] getAttributeNames() {
        return dcValidAttributeNames;
    }

    @Override
    protected Map getAttDescMap() {
        return dcAttDescriptions;
    }

    @Override
    public boolean isLoner() {
        return this.getLocators().equals("") && this.getMcastPort() == 0;
    }

    static {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("ack-wait-threshold", String.format("The number of seconds a distributed message can wait for acknowledgment before it sends an alert to signal that something might be wrong with the system node that is unresponsive. After sending this alert the waiter continues to wait. The alerts are logged in the system log as warnings and if a gfc is running will cause a console alert to be signalled.  Defaults to %s.  Legal values are in the range [%s..%s].", 15, 1, 1));
        m.put("archive-file-size-limit", "The maximum size in megabytes of a statistic archive file. Once this limit is exceeded, a new statistic archive file is created, and the current archive file becomes inactive. If set to zero, file size is unlimited.");
        m.put("ack-severe-alert-threshold", String.format("The number of seconds a distributed message can wait for acknowledgment past %s before it ejects unresponsive members from the distributed system.  Defaults to %s.  Legal values are in the range [%s..%s].", "ack-wait-threshold", 0, 0, Integer.MAX_VALUE));
        m.put("archive-disk-space-limit", "The maximum size in megabytes of all inactive statistic archive files combined. If this limit is exceeded, inactive archive files will be deleted, oldest first, until the total size is within the limit. If set to zero, disk space usage is unlimited.");
        m.put("cache-xml-file", String.format("The file whose contents is used, by default, to initialize a cache if one is created.  Defaults to %s.", DEFAULT_CACHE_XML_FILE));
        m.put("disable-tcp", String.format("Determines whether TCP/IP communications will be disabled, forcing use of datagrams between members of the distributed system. Defaults to %s", Boolean.FALSE));
        m.put("disable-jmx", String.format("Determines whether JMX will be disabled which prevents Geode from creating MBeans. Defaults to %s", Boolean.FALSE));
        m.put("enable-time-statistics", "Turns on timings in distribution and cache statistics.  These are normally turned off to avoid expensive clock probes.");
        m.put("deploy-working-dir", String.format("The working directory that can be used to persist JARs deployed during runtime. Defaults to %s.", DEFAULT_DEPLOY_WORKING_DIR));
        m.put("log-file", String.format("The file a running system will write log messages to.  Defaults to %s.", DEFAULT_LOG_FILE));
        m.put("log-level", String.format("Controls the type of messages that will actually be written to the system log.  Defaults to %s.  Allowed values %s.", LogWriterImpl.levelToString(DEFAULT_LOG_LEVEL), LogWriterImpl.allowedLogLevels()));
        m.put("log-file-size-limit", "The maximum size in megabytes of a child log file. Once this limit is exceeded, a new child log is created, and the current child log becomes inactive. If set to zero, child logging is disabled.");
        m.put("log-disk-space-limit", "The maximum size in megabytes of all inactive log files combined. If this limit is exceeded, inactive log files will be deleted, oldest first, until the total size is within the limit. If set to zero, disk space usage is unlimited.");
        m.put("locators", String.format("A possibly empty list of locators used to find other system nodes. Each element of the list must be a host name followed by bracketed, [], port number. Host names may be followed by a colon and a bind address used by the locator on that host.  Multiple elements must be comma separated. Defaults to %s.", ""));
        m.put("locator-wait-time", String.format("The amount of time, in seconds, to wait for a locator to be available before throwing an exception during startup.  The default is %s.", 0));
        m.put("tcp-port", String.format("The port used for tcp/ip communcations in the distributed system. If zero then a random available port is selected by the operating system.   Defaults to %s.  Legal values are in the range [%s..%s].", 0, 0, 65535));
        m.put("mcast-port", String.format("The port used for multicast communcations in the distributed system. If zero then locators are used, and multicast is disabled.   Defaults to %s.  Legal values are in the range [%s..%s].", 0, 0, 65535));
        m.put("mcast-address", String.format("The address used for multicast communications. Only used if %s is non-zero.  Defaults to %s.", 0, DEFAULT_MCAST_ADDRESS));
        m.put("mcast-ttl", String.format("Determines how far through your network mulicast packets will propogate. Defaults to %s.  Legal values are in the range [%s..%s].", 32, 0, 255));
        m.put("mcast-send-buffer-size", String.format("Sets the size of multicast socket transmission buffers, in bytes.  Defaults to %s but this may be limited by operating system settings", 65535));
        m.put("mcast-recv-buffer-size", String.format("Sets the size of multicast socket receive buffers, in bytes.  Defaults to %s but this may be limited by operating system settings", 0x100000));
        m.put("mcast-flow-control", String.format("Sets the flow-of-control parameters for multicast messaging.  Defaults to %s.", DEFAULT_MCAST_FLOW_CONTROL));
        m.put("member-timeout", String.format("Sets the number of milliseconds to wait for ping responses when determining whether another member is still alive. Defaults to %s.", 5000));
        String srange = "" + DEFAULT_MEMBERSHIP_PORT_RANGE[0] + "-" + DEFAULT_MEMBERSHIP_PORT_RANGE[1];
        String msg = String.format("Sets the range of datagram socket ports that can be used for membership ID purposes and unicast datagram messaging. Defaults to %s.", srange);
        m.put("membership-port-range", msg);
        m.put("udp-send-buffer-size", String.format("Sets the size of datagram socket transmission buffers, in bytes.  Defaults to %s but this may be limited by operating system settings", 65535));
        m.put("udp-recv-buffer-size", String.format("Sets the size of datagram socket receive buffers, in bytes. Defaults to %s but this may be limited by operating system settings", 0x100000));
        m.put("udp-fragment-size", String.format("Sets the maximum size of a datagram for UDP and multicast transmission.  Defaults to %s.", 60000));
        m.put("socket-lease-time", String.format("The number of milliseconds a thread can keep exclusive access to a socket that it is not actively using. Once a thread loses its lease to a socket it will need to re-acquire a socket the next time it sends a message. A value of zero causes socket leases to never expire. Defaults to %s .  Legal values are in the range [%s..%s].", 60000, 0, 600000));
        m.put("socket-buffer-size", String.format("The size of each socket buffer, in bytes. Smaller buffers conserve memory. Larger buffers can improve performance; in particular if large messages are being sent. Defaults to %s.  Legal values are in the range [%s..%s].", 32768, 1024, 0xFFFFFF));
        m.put("conserve-sockets", String.format("If true then a minimal number of sockets will be used when connecting to the distributed system. This conserves resource usage but can cause performance to suffer. If false, the default, then every application thread that sends distribution messages to other members of the distributed system will own its own sockets and have exclusive access to them. Defaults to %s.", true));
        m.put("roles", String.format("The application roles that this member performs in the distributed system. This is a comma delimited list of user-defined strings. Any number of members can be configured to perform the same role, and a member can be configured to perform any number of roles. Defaults to %s.", ""));
        m.put("bind-address", String.format("The address server sockets will listen on. An empty string causes the server socket to listen on all local addresses. Defaults to %s.", ""));
        m.put("server-bind-address", String.format("The address server sockets in a client-server topology will listen on. An empty string causes the server socket to listen on all local addresses. Defaults to %s.", ""));
        m.put("name", "A name that uniquely identifies a member in its distributed system. Multiple members in the same distributed system can not have the same name. Defaults to \"\".");
        m.put("statistic-archive-file", String.format("The file a running system will write statistic samples to.  Defaults to %s.", DEFAULT_STATISTIC_ARCHIVE_FILE));
        m.put("statistic-sample-rate", String.format("The rate, in milliseconds, that a running system will sample statistics.  Defaults to %s.  Legal values are in the range [%s..%s].", 1000, 100, 60000));
        m.put("statistic-sampling-enabled", String.format("If false then archiving is disabled and operating system statistics are no longer updated.  Defaults to %s.", Boolean.TRUE));
        m.put("ssl-cluster-alias", String.format("SSL communication uses the this alias when determining the key to use from the keystore for SSL. Defaults to %s.", Boolean.valueOf("")));
        m.put("cluster-ssl-enabled", String.format("Communication is performed through SSL when this property is set to true. Defaults to %s.", Boolean.FALSE));
        m.put("cluster-ssl-protocols", String.format("List of available SSL protocols that are to be enabled. Defaults to %s meaning your provider's defaults.", "any"));
        m.put("cluster-ssl-ciphers", String.format("List of available SSL cipher suites that are to be enabled. Defaults to %s meaning your provider's defaults.", "any"));
        m.put("cluster-ssl-require-authentication", String.format("if set to false, ciphers and protocols that permit anonymous peers are allowed. Defaults to %s.", Boolean.TRUE));
        m.put("cluster-ssl-keystore", "Location of the Java keystore file containing an distributed member's own certificate and private key.");
        m.put("cluster-ssl-keystore-type", "For Java keystore file format, this property has the value jks (or JKS).");
        m.put("cluster-ssl-keystore-password", "Password to access the private key from the keystore file specified by javax.net.ssl.keyStore.");
        m.put("cluster-ssl-truststore", "Location of the Java keystore file containing the collection of CA certificates trusted by distributed member (trust store).");
        m.put("cluster-ssl-truststore-password", "Password to unlock the keystore file (store password) specified by  javax.net.ssl.trustStore.");
        m.put("max-wait-time-reconnect", "Specifies the maximum time to wait before trying to reconnect to distributed system in the case of required role loss.");
        m.put("max-num-reconnect-tries", "Maximum number of tries before shutting the member down in the case of required role loss.");
        m.put("async-distribution-timeout", String.format("The number of milliseconds before a publishing process should attempt to distribute a cache operation before switching over to asynchronous messaging for this process. Defaults to %s. Legal values are in the range [%s..%s].", 0, 0, 60000));
        m.put("async-queue-timeout", String.format("The number of milliseconds a queuing may enqueue asynchronous messages without any distribution to this process before that publisher requests this process to depart. Defaults to %s Legal values are in the range [%s..%s].", 60000, 0, 86400000));
        m.put("async-max-queue-size", String.format("The maximum size in megabytes that a publishing process should be allowed to asynchronously enqueue for this process before asking this process to depart from the distributed system. Defaults to %s. Legal values are in the range [%s..%s].", 8, 0, 1024));
        m.put("start-locator", "The host|bindAddress[port] of a Locator to start in this VM along with the DistributedSystem. The default is to not start a Locator.");
        m.put("durable-client-id", String.format("An id used by durable clients to identify themselves as durable to servers. Defaults to %s.", ""));
        m.put("conflate-events", "Client override for server queue conflation setting");
        m.put("durable-client-timeout", String.format("The value (in seconds) used by the server to keep disconnected durable clients alive. Defaults to %s.", 300));
        m.put("security-client-auth-init", String.format("User defined fully qualified method name implementing AuthInitialize interface for client. Defaults to %s. Legal values can be any method name of a static method that is present in the classpath.", ""));
        m.put("enable-network-partition-detection", "Whether network partitioning detection is enabled");
        m.put("disable-auto-reconnect", "Whether auto reconnect is attempted after a network partition");
        m.put("security-client-authenticator", String.format("User defined fully qualified method name implementing Authenticator interface for client verification. Defaults to %s. Legal values can be any method name of a static method that is present in the classpath.", ""));
        m.put("security-client-dhalgo", String.format("User defined name for the symmetric encryption algorithm to use in Diffie-Hellman key exchange for encryption of credentials.  Defaults to %s. Legal values can be any of the available symmetric algorithm names in JDK like DES, DESede, AES, Blowfish. It may be required to install Unlimited Strength Jurisdiction Policy Files from Sun for some symmetric algorithms to work (like AES)", ""));
        m.put("security-udp-dhalgo", String.format("User defined name for the symmetric encryption algorithm to use in Diffie-Hellman key exchange for encryption of udp messages.  Defaults to %s. Legal values can be any of the available symmetric algorithm names in JDK like DES, DESede, AES, Blowfish. It may be required to install Unlimited Strength Jurisdiction Policy Files from Sun for some symmetric algorithms to work (like AES)", ""));
        m.put("security-peer-auth-init", String.format("User defined fully qualified method name implementing AuthInitialize interface for peer. Defaults to %s. Legal values can be any method name of a static method that is present in the classpath.", ""));
        m.put("security-peer-authenticator", String.format("User defined fully qualified method name implementing Authenticator interface for peer verificaiton. Defaults to %s. Legal values can be any method name of a static method that is present in the classpath.", ""));
        m.put("security-client-accessor", String.format("User defined fully qualified method name implementing AccessControl interface for client authorization. Defaults to %s. Legal values can be any method name of a static method that is present in the classpath.", ""));
        m.put("security-client-accessor-pp", String.format("User defined fully qualified method name implementing AccessControl interface for client authorization in post-processing phase. Defaults to %s. Legal values can be any method name of a static method that is present in the classpath.", ""));
        m.put("security-log-level", String.format("Controls the type of messages that will actually be written to the system security log. Defaults to %s.  Allowed values %s.", LogWriterImpl.levelToString(DEFAULT_LOG_LEVEL), LogWriterImpl.allowedLogLevels()));
        m.put("security-log-file", String.format("The file a running system will write security log messages to. Defaults to %s.", DEFAULT_SECURITY_LOG_FILE));
        m.put("security-peer-verifymember-timeout", String.format("The timeout value (in milliseconds) used by a peer to verify membership of an unknown authenticated peer requesting a secure connection. Defaults to %s milliseconds. The timeout value should not exceed peer handshake timeout.", 1000));
        m.put("security-", "Prefix for security related properties which are packed together and invoked as authentication parameter. Neither key nor value can be NULL. Legal tags can be [security-username, security-digitalid] and Legal values can be any string data.");
        m.put("security-auth-token-enabled-components", "list of rest service to authenticate request with a Bearer token passed in the 'Authentication' header of the REST request. Otherwise BASIC authentication scheme is used. Possible value is a comma separated list of: 'all', 'management'. This property is ignored if 'security-manager' is not set. Default value is empty.");
        m.put("custom-", "Prefix for user defined properties which are used for replacements in Cache.xml. Neither key nor value can be NULL. Legal tags can be [custom-any-string] and Legal values can be any string data.");
        m.put("remove-unresponsive-client", String.format("Whether to remove unresponsive client or not. Defaults to %s.", false));
        m.put("delta-propagation", "Whether delta propagation is enabled");
        m.put("remote-locators", String.format("A possibly empty list of locators used to find other distributed systems. Each element of the list must be a host name followed by bracketed, [], port number. Host names may be followed by a colon and a bind address used by the locator on that host.  Multiple elements must be comma separated. Defaults to %s.", ""));
        m.put("distributed-system-id", "An id that uniquely idenitifies this distributed system. Required when using portable data exchange objects and the WAN.Must be the same on each member in this distributed system if set.");
        m.put("enforce-unique-host", "Whether to require partitioned regions to put redundant copies of data on different physical machines");
        m.put("redundancy-zone", "The zone that this member is in. When this is set, partitioned regions will not put two copies of the same data in the same zone.");
        m.put("groups", "A comma separated list of all the groups this member belongs to. Defaults to \"\".");
        m.put("user-command-packages", "A comma separated list of the names of the packages containing classes that implement user commands.");
        m.put("jmx-manager", "If true then this member is willing to be a jmx manager. Defaults to false except on a locator.");
        m.put("jmx-manager-start", "If true then the jmx manager will be started when the cache is created. Defaults to false.");
        m.put("jmx-manager-ssl-enabled", "If true then the jmx manager will only allow SSL clients to connect. Defaults to false. This property is ignored if jmx-manager-port is \"0\".");
        m.put("ssl-jmx-alias", String.format("SSL jmx communication uses the this alias when determining the key to use from the keystore for SSL. Defaults to %s.", Boolean.valueOf("")));
        m.put("jmx-manager-ssl-ciphers", "List of available SSL cipher suites that are to be enabled for JMX Manager. Defaults to \"any\" meaning your provider's defaults.");
        m.put("jmx-manager-ssl-protocols", "List of available SSL protocols that are to be enabled for JMX Manager. Defaults to \"any\" meaning defaults of your provider.");
        m.put("jmx-manager-ssl-require-authentication", "If set to false, ciphers and protocols that permit anonymous JMX Clients are allowed. Defaults to \"true\".");
        m.put("jmx-manager-ssl-keystore", "Location of the Java keystore file containing jmx manager's own certificate and private key.");
        m.put("jmx-manager-ssl-keystore-type", "For Java keystore file format, this property has the value jks (or JKS).");
        m.put("jmx-manager-ssl-keystore-password", "Password to access the private key from the keystore file specified by javax.net.ssl.keyStore. ");
        m.put("jmx-manager-ssl-truststore", "Location of the Java keystore file containing the collection of CA certificates trusted by jmx manager.");
        m.put("jmx-manager-ssl-truststore-password", "Password to unlock the keystore file (store password) specified by  javax.net.ssl.trustStore.");
        m.put("jmx-manager-port", "The port the jmx manager will listen on. Default is \"1099\". Set to zero to disable GemFire's creation of a jmx listening port.");
        m.put("jmx-manager-bind-address", "The address the jmx manager will listen on for remote connections. Default is \"\" which causes the jmx manager to listen on the host's default address. This property is ignored if jmx-manager-port is \"0\".");
        m.put("jmx-manager-hostname-for-clients", "The hostname that will be given to clients when they ask a locator for the location of this jmx manager. Default is \"\" which causes the locator to report the jmx manager's actual ip address as its location. This property is ignored if jmx-manager-port is \"0\".");
        m.put("jmx-manager-password-file", "The name of the file the jmx manager will use to only allow authenticated clients to connect. Default is \"\" which causes the jmx manager to allow all clients to connect. This property is ignored if jmx-manager-port is \"0\".");
        m.put("jmx-manager-access-file", "The name of the file the jmx manager will use to define the access level of authenticated clients. Default is \"\" which causes the jmx manager to allow all clients all access. This property is ignored if jmx-manager-port is \"0\".");
        m.put("jmx-manager-http-port", "By default when a jmx-manager is started it will also start an http server on this port. This server is used by the GemFire Pulse application. Setting this property to zero disables the http server. It defaults to 8080. Ignored if jmx-manager is false.");
        m.put("jmx-manager-update-rate", "The rate in milliseconds at which this member will send updates to each jmx manager. Default is 2000. Values must be in the range 1000..300000.");
        m.put("ssl-locator-alias", String.format("SSL locator communications uses this alias when determining the key to use from the keystore for SSL. Defaults to %s.", Boolean.valueOf("")));
        m.put("memcached-port", "The port GemFireMemcachedServer will listen on. Default is 0. Set to zero to disable GemFireMemcachedServer.");
        m.put("memcached-protocol", "The protocol that GemFireMemcachedServer understands. Default is ASCII. Values may be ASCII or BINARY");
        m.put("memcached-bind-address", "The address the GemFireMemcachedServer will listen on for remote connections. Default is \"\" which causes the GemFireMemcachedServer to listen on the host's default address. This property is ignored if memcached-port is \"0\".");
        m.put("redis-port", "The port GeodeRedisServer will listen on. Default is 0. Set to zero to disable GeodeRedisServer.");
        m.put("redis-bind-address", "The address the GeodeRedisServer will listen on for remote connections. Default is \"\" which causes the GeodeRedisServer to listen on the host's default address. This property is ignored if redis-port is \"0\".");
        m.put("redis-password", "The password which client of GeodeRedisServer must use to authenticate themselves. The default is none and no authentication will be required.");
        m.put("enable-cluster-configuration", "Enables cluster configuration support in dedicated locators.  This allows the locator to share configuration information amongst members and save configuration changes made using GFSH.");
        m.put("enable-management-rest-service", "Enables management rest service in dedicated locators.  This allows users to manage the cluster through rest api.");
        m.put("use-cluster-configuration", "Boolean flag that allows the cache to use the cluster configuration provided by the cluster config service");
        m.put("load-cluster-configuration-from-dir", String.format("Loads cluster configuration from the %s directory of a locator. This is property is only applicable to the locator(s)", "cluster_config"));
        m.put("cluster-configuration-dir", "The directory to store the cluster configuration artifacts and disk-store. This property is only applicable to the locator(s)");
        m.put("ssl-server-alias", String.format("SSL inter-server communication (peer-to-peer) uses the this alias when determining the key to use from the keystore for SSL. Defaults to %s.", Boolean.valueOf("")));
        m.put("server-ssl-enabled", "If true then the cache server will only allow SSL clients to connect. Defaults to false.");
        m.put("server-ssl-ciphers", "List of available SSL cipher suites that are to be enabled for CacheServer. Defaults to \"any\" meaning your provider's defaults.");
        m.put("server-ssl-protocols", "List of available SSL protocols that are to be enabled for CacheServer. Defaults to \"any\" meaning defaults of your provider.");
        m.put("server-ssl-require-authentication", "If set to false, ciphers and protocols that permit anonymous Clients are allowed. Defaults to \"true\".");
        m.put("server-ssl-keystore", "Location of the Java keystore file containing server's or client's own certificate and private key.");
        m.put("server-ssl-keystore-type", "For Java keystore file format, this property has the value jks (or JKS).");
        m.put("server-ssl-keystore-password", "Password to access the private key from the keystore file specified by javax.net.ssl.keyStore. ");
        m.put("server-ssl-truststore", "Location of the Java keystore file containing the collection of CA certificates trusted by server or client(trust store).");
        m.put("server-ssl-truststore-password", "Password to unlock the keystore file (store password) specified by  javax.net.ssl.trustStore.");
        m.put("ssl-gateway-alias", String.format("SSL gateway communication uses the this alias when determining the key to use from the keystore for SSL. Defaults to %s.", Boolean.valueOf("")));
        m.put("gateway-ssl-enabled", "If true then the gateway receiver will only allow SSL gateway sender to connect. Defaults to false.");
        m.put("gateway-ssl-ciphers", "List of available SSL cipher suites that are to be enabled for Gateway Receiver. Defaults to \"any\" meaning your provider's defaults.");
        m.put("gateway-ssl-protocols", "List of available SSL protocols that are to be enabled for Gateway Receiver. Defaults to \"any\" meaning defaults of your provider.");
        m.put("gateway-ssl-require-authentication", "If set to false, ciphers and protocols that permit anonymous gateway senders are allowed. Defaults to \"true\".");
        m.put("gateway-ssl-keystore", "Location of the Java keystore file containing gateway's own certificate and private key.");
        m.put("gateway-ssl-keystore-type", "For Java keystore file format, this property has the value jks (or JKS).");
        m.put("gateway-ssl-keystore-password", "Password to access the private key from the keystore file specified by javax.net.ssl.keyStore.");
        m.put("gateway-ssl-truststore", "Location of the Java keystore file containing the collection of CA certificates trusted by gateway.");
        m.put("gateway-ssl-truststore-password", "Password to unlock the keystore file (store password) specified by  javax.net.ssl.trustStore.");
        m.put("ssl-web-alias", String.format("SSL http service communication uses the this alias when determining the key to use from the keystore for SSL. Defaults to %s.", Boolean.valueOf("")));
        m.put("http-service-port", "If non zero, then the gemfire developer REST service will be deployed and started when the cache is created. Default value is 0.");
        m.put("http-service-bind-address", "The address where gemfire developer REST service will listen for remote REST connections. Default is \"\" which causes the Rest service to listen on the host's default address.");
        m.put("http-service-ssl-enabled", "If true then the http service like REST dev api and Pulse will only allow SSL enabled clients to connect. Defaults to false.");
        m.put("http-service-ssl-ciphers", "List of available SSL cipher suites that are to be enabled for Http Service. Defaults to \"any\" meaning your provider's defaults.");
        m.put("http-service-ssl-protocols", "List of available SSL protocols that are to be enabled for Http Service. Defaults to \"any\" meaning defaults of your provider.");
        m.put("http-service-ssl-require-authentication", "If set to false, ciphers and protocols that permit anonymous http clients are allowed. Defaults to \"false\".");
        m.put("http-service-ssl-keystore", "Location of the Java keystore file containing Http Service's own certificate and private key.");
        m.put("http-service-ssl-keystore-type", "For Java keystore file format, this property has the value jks (or JKS).");
        m.put("http-service-ssl-keystore-password", "Password to access the private key from the keystore file specified by javax.net.ssl.keyStore.");
        m.put("http-service-ssl-truststore", "Location of the Java keystore file containing the collection of CA certificates trusted by Http Service.");
        m.put("http-service-ssl-truststore-password", "Password to unlock the keystore file (store password) specified by  javax.net.ssl.trustStore.");
        m.put("start-dev-rest-api", "If true then the developer(API) REST service will be started when the cache is created. Defaults to false.");
        m.put("off-heap-memory-size", String.format("The amount of off-heap memory to be allocated for GemFire. Value is <n>[g|m], where <n> is the size and [g|m] specifies the units in gigabytes or megabytes. Defaults to %s.", ""));
        m.put("lock-memory", String.format("Locks heap and off-heap memory pages into RAM, thereby preventing the operating system from swapping them out to disk. Defaults to %s", false));
        m.put("distributed-transactions", "Flag to indicate whether all transactions including JTA should be distributed transactions.  Default is false, meaning colocated transactions.");
        m.put("security-shiro-init", "The name of the shiro configuration file in the classpath, e.g. shiro.ini");
        m.put("security-manager", "User defined fully qualified class name implementing SecurityManager interface for integrated security. Defaults to \"{0}\". Legal values can be any \"class name\" implementing SecurityManager that is present in the classpath.");
        m.put("security-post-processor", "User defined fully qualified class name implementing PostProcessor interface for integrated security. Defaults to \"{0}\". Legal values can be any \"class name\" implementing PostProcessor that is present in the classpath.");
        m.put("ssl-endpoint-identification-enabled", "If true, clients validate server hostname using server certificate during SSL handshake. It defaults to true when ssl-use-default-context is true or else false.");
        m.put("ssl-use-default-context", "When true, either uses the default context as returned by SSLContext.getInstance('Default') or uses the context as set by using SSLContext.setDefault(). If false, then specify the keystore and the truststore by setting ssl-keystore-* and ssl-truststore-* properties. If true, then ssl-endpoint-identification-enabled is set to true. This property does not enable SSL.");
        m.put("ssl-enabled-components", "A comma delimited list of components that require SSL communications");
        m.put("ssl-ciphers", "List of available SSL cipher suites that are to be enabled. Defaults to \"any\" meaning your provider's defaults.");
        m.put("ssl-protocols", "List of available SSL protocols that are to be enabled. Defaults to \"any\" meaning defaults of your provider.");
        m.put("ssl-require-authentication", "If set to false, ciphers and protocols that permit anonymous clients are allowed. Defaults to \"true\".");
        m.put("ssl-keystore", "Location of the Java keystore file containing the certificate and private key.");
        m.put("ssl-keystore-type", "For Java keystore file format, this property has the value jks (or JKS).");
        m.put("ssl-keystore-password", "Password to access the private key from the keystore.");
        m.put("ssl-truststore", "Location of the Java keystore file containing the collection of trusted certificates.");
        m.put("ssl-truststore-password", "Password to unlock the truststore.");
        m.put("ssl-truststore-type", "For Java truststore file format, this property has the value jks (or JKS).");
        m.put("ssl-default-alias", "The default certificate alias to be used in a multi-key keystore");
        m.put("ssl-web-require-authentication", "This property determines is the HTTP service with use mutual ssl authentication.");
        m.put("ssl-parameter-extension", "User defined fully qualified class name implementing SSLParameterExtension interface for SSL parameter extensions. Defaults to \"{0}\". Legal values can be any \"class name\" implementing SSLParameterExtension that is present in the classpath.");
        m.put("validate-serializable-objects", "If true checks incoming java serializable objects against a filter");
        m.put("serializable-object-filter", "The filter to check incoming java serializables against");
        m.put("thread-monitor-interval-ms", "Defines the time interval (in milliseconds) with which thread monitoring is scheduled to run.");
        m.put("thread-monitor-enabled", "Defines whether thread monitoring is to be enabled.");
        m.put("thread-monitor-time-limit-ms", "Defines the time period (in milliseconds) after which the monitored thread is considered to be stuck.");
        dcAttDescriptions = Collections.unmodifiableMap(m);
        HashMap<String, Method> checkersMap = new HashMap<String, Method>();
        for (Method method : AbstractDistributionConfig.class.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(ConfigAttributeChecker.class)) continue;
            ConfigAttributeChecker checker = method.getAnnotation(ConfigAttributeChecker.class);
            checkersMap.put(checker.name(), method);
        }
        checkers = Collections.unmodifiableMap(checkersMap);
    }
}

