/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.store.spark;

import java.util.ArrayList;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.BigIntType;
import org.apache.flink.table.types.logical.BinaryType;
import org.apache.flink.table.types.logical.BooleanType;
import org.apache.flink.table.types.logical.CharType;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.DecimalType;
import org.apache.flink.table.types.logical.DoubleType;
import org.apache.flink.table.types.logical.FloatType;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LocalZonedTimestampType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.SmallIntType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.table.types.logical.TinyIntType;
import org.apache.flink.table.types.logical.VarBinaryType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.table.types.logical.utils.LogicalTypeDefaultVisitor;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DataTypes;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;

public class SparkTypeUtils {
    private SparkTypeUtils() {
    }

    public static StructType fromFlinkRowType(RowType type) {
        return (StructType)SparkTypeUtils.fromFlinkType(type);
    }

    public static DataType fromFlinkType(LogicalType type) {
        return type.accept(FlinkToSparkTypeVisitor.INSTANCE);
    }

    private static class FlinkToSparkTypeVisitor
    extends LogicalTypeDefaultVisitor<DataType> {
        private static final FlinkToSparkTypeVisitor INSTANCE = new FlinkToSparkTypeVisitor();

        private FlinkToSparkTypeVisitor() {
        }

        @Override
        public DataType visit(CharType charType) {
            return DataTypes.StringType;
        }

        @Override
        public DataType visit(VarCharType varCharType) {
            return DataTypes.StringType;
        }

        @Override
        public DataType visit(BooleanType booleanType) {
            return DataTypes.BooleanType;
        }

        @Override
        public DataType visit(BinaryType binaryType) {
            return DataTypes.BinaryType;
        }

        @Override
        public DataType visit(VarBinaryType varBinaryType) {
            return DataTypes.BinaryType;
        }

        @Override
        public DataType visit(DecimalType decimalType) {
            return DataTypes.createDecimalType((int)decimalType.getPrecision(), (int)decimalType.getScale());
        }

        @Override
        public DataType visit(TinyIntType tinyIntType) {
            return DataTypes.ByteType;
        }

        @Override
        public DataType visit(SmallIntType smallIntType) {
            return DataTypes.ShortType;
        }

        @Override
        public DataType visit(IntType intType) {
            return DataTypes.IntegerType;
        }

        @Override
        public DataType visit(BigIntType bigIntType) {
            return DataTypes.LongType;
        }

        @Override
        public DataType visit(FloatType floatType) {
            return DataTypes.FloatType;
        }

        @Override
        public DataType visit(DoubleType doubleType) {
            return DataTypes.DoubleType;
        }

        @Override
        public DataType visit(DateType dateType) {
            return DataTypes.DateType;
        }

        @Override
        public DataType visit(TimestampType timestampType) {
            return DataTypes.TimestampType;
        }

        @Override
        public DataType visit(LocalZonedTimestampType localZonedTimestampType) {
            return DataTypes.TimestampType;
        }

        @Override
        public DataType visit(ArrayType arrayType) {
            LogicalType elementType = arrayType.getElementType();
            return DataTypes.createArrayType((DataType)elementType.accept(this), (boolean)elementType.isNullable());
        }

        @Override
        public DataType visit(MultisetType multisetType) {
            return DataTypes.createMapType((DataType)multisetType.getElementType().accept(this), (DataType)DataTypes.IntegerType, (boolean)false);
        }

        @Override
        public DataType visit(MapType mapType) {
            return DataTypes.createMapType((DataType)mapType.getKeyType().accept(this), (DataType)mapType.getValueType().accept(this), (boolean)mapType.getValueType().isNullable());
        }

        @Override
        public DataType visit(RowType rowType) {
            ArrayList<StructField> fields = new ArrayList<StructField>(rowType.getFieldCount());
            for (RowType.RowField field : rowType.getFields()) {
                StructField structField = DataTypes.createStructField((String)field.getName(), (DataType)field.getType().accept(this), (boolean)field.getType().isNullable());
                structField = field.getDescription().map(arg_0 -> ((StructField)structField).withComment(arg_0)).orElse(structField);
                fields.add(structField);
            }
            return DataTypes.createStructType(fields);
        }

        @Override
        protected DataType defaultMethod(LogicalType logicalType) {
            throw new UnsupportedOperationException("Unsupported type: " + logicalType);
        }
    }
}

