/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.highavailability.nonha.standalone;

import javax.annotation.concurrent.GuardedBy;
import org.apache.flink.runtime.highavailability.ClientHighAvailabilityServices;
import org.apache.flink.runtime.highavailability.HighAvailabilityServices;
import org.apache.flink.runtime.leaderretrieval.LeaderRetrievalService;
import org.apache.flink.runtime.leaderretrieval.StandaloneLeaderRetrievalService;
import org.apache.flink.util.Preconditions;

public class StandaloneClientHAServices
implements ClientHighAvailabilityServices {
    private final Object lock = new Object();
    private final String webMonitorAddress;
    @GuardedBy(value="lock")
    private boolean running;

    public StandaloneClientHAServices(String webMonitorAddress) {
        this.webMonitorAddress = webMonitorAddress;
        this.running = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaderRetrievalService getClusterRestEndpointLeaderRetriever() {
        Object object = this.lock;
        synchronized (object) {
            Preconditions.checkState(this.running, "ClientHaService has already been closed.");
            return new StandaloneLeaderRetrievalService(this.webMonitorAddress, HighAvailabilityServices.DEFAULT_LEADER_ID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        Object object = this.lock;
        synchronized (object) {
            this.running = false;
        }
    }
}

