/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.jobmaster.slotpool;

import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import org.apache.flink.api.common.time.Time;
import org.apache.flink.runtime.clusterframework.types.AllocationID;
import org.apache.flink.runtime.clusterframework.types.ResourceID;
import org.apache.flink.runtime.clusterframework.types.ResourceProfile;
import org.apache.flink.runtime.concurrent.ComponentMainThreadExecutor;
import org.apache.flink.runtime.jobmanager.slots.TaskManagerGateway;
import org.apache.flink.runtime.jobmaster.AllocatedSlotReport;
import org.apache.flink.runtime.jobmaster.JobMasterId;
import org.apache.flink.runtime.jobmaster.SlotInfo;
import org.apache.flink.runtime.jobmaster.SlotRequestId;
import org.apache.flink.runtime.jobmaster.slotpool.AllocatedSlotActions;
import org.apache.flink.runtime.jobmaster.slotpool.PhysicalSlot;
import org.apache.flink.runtime.jobmaster.slotpool.SlotInfoWithUtilization;
import org.apache.flink.runtime.resourcemanager.ResourceManagerGateway;
import org.apache.flink.runtime.taskexecutor.slot.SlotOffer;
import org.apache.flink.runtime.taskmanager.TaskManagerLocation;

public interface SlotPool
extends AllocatedSlotActions,
AutoCloseable {
    public void start(JobMasterId var1, String var2, ComponentMainThreadExecutor var3) throws Exception;

    @Override
    public void close();

    public void connectToResourceManager(ResourceManagerGateway var1);

    public void disconnectResourceManager();

    public boolean registerTaskManager(ResourceID var1);

    public boolean releaseTaskManager(ResourceID var1, Exception var2);

    public Collection<SlotOffer> offerSlots(TaskManagerLocation var1, TaskManagerGateway var2, Collection<SlotOffer> var3);

    public Collection<SlotInfoWithUtilization> getAvailableSlotsInformation();

    public Collection<SlotInfo> getAllocatedSlotsInformation();

    public Optional<PhysicalSlot> allocateAvailableSlot(SlotRequestId var1, AllocationID var2, ResourceProfile var3);

    default public CompletableFuture<PhysicalSlot> requestNewAllocatedSlot(SlotRequestId slotRequestId, ResourceProfile resourceProfile, @Nullable Time timeout) {
        return this.requestNewAllocatedSlot(slotRequestId, resourceProfile, Collections.emptyList(), timeout);
    }

    public CompletableFuture<PhysicalSlot> requestNewAllocatedSlot(SlotRequestId var1, ResourceProfile var2, Collection<AllocationID> var3, @Nullable Time var4);

    default public CompletableFuture<PhysicalSlot> requestNewAllocatedBatchSlot(SlotRequestId slotRequestId, ResourceProfile resourceProfile) {
        return this.requestNewAllocatedBatchSlot(slotRequestId, resourceProfile, Collections.emptyList());
    }

    public CompletableFuture<PhysicalSlot> requestNewAllocatedBatchSlot(SlotRequestId var1, ResourceProfile var2, Collection<AllocationID> var3);

    public void disableBatchSlotRequestTimeoutCheck();

    public AllocatedSlotReport createAllocatedSlotReport(ResourceID var1);

    public void setIsJobRestarting(boolean var1);
}

