/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.io.compression;

import org.apache.flink.configuration.IllegalConfigurationException;
import org.apache.flink.runtime.io.compression.BlockCompressor;
import org.apache.flink.runtime.io.compression.BlockDecompressor;
import org.apache.flink.runtime.io.compression.Lz4BlockCompressionFactory;
import org.apache.flink.util.Preconditions;

public interface BlockCompressionFactory {
    public BlockCompressor getCompressor();

    public BlockDecompressor getDecompressor();

    public static BlockCompressionFactory createBlockCompressionFactory(String compressionFactoryName) {
        BlockCompressionFactory blockCompressionFactory;
        block11: {
            Object factoryObj;
            block10: {
                CompressionFactoryName compressionName;
                Preconditions.checkNotNull(compressionFactoryName);
                try {
                    compressionName = CompressionFactoryName.valueOf(compressionFactoryName.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    compressionName = null;
                }
                blockCompressionFactory = null;
                if (compressionName == null) break block10;
                switch (compressionName) {
                    case LZ4: {
                        blockCompressionFactory = new Lz4BlockCompressionFactory();
                        break block11;
                    }
                    default: {
                        throw new IllegalStateException("Unknown CompressionMethod " + (Object)((Object)compressionName));
                    }
                }
            }
            try {
                factoryObj = Class.forName(compressionFactoryName).newInstance();
            }
            catch (ClassNotFoundException e) {
                throw new IllegalConfigurationException("Cannot load class " + compressionFactoryName, e);
            }
            catch (Exception e) {
                throw new IllegalConfigurationException("Cannot create object for class " + compressionFactoryName, e);
            }
            if (factoryObj instanceof BlockCompressionFactory) {
                blockCompressionFactory = (BlockCompressionFactory)factoryObj;
            } else {
                throw new IllegalArgumentException("CompressionFactoryName should inherit from interface BlockCompressionFactory, or use the default compression codec.");
            }
        }
        Preconditions.checkNotNull(blockCompressionFactory);
        return blockCompressionFactory;
    }

    public static enum CompressionFactoryName {
        LZ4;

    }
}

