/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.httpfn;

import java.net.URI;
import javax.annotation.Nullable;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.statefun.flink.common.SetContextClassLoader;
import org.apache.flink.statefun.flink.common.json.StateFunObjectMapper;
import org.apache.flink.statefun.flink.core.httpfn.DefaultHttpRequestReplyClient;
import org.apache.flink.statefun.flink.core.httpfn.DefaultHttpRequestReplyClientSpec;
import org.apache.flink.statefun.flink.core.httpfn.OkHttpUnixSocketBridge;
import org.apache.flink.statefun.flink.core.httpfn.OkHttpUtils;
import org.apache.flink.statefun.flink.core.httpfn.UnixDomainHttpEndpoint;
import org.apache.flink.statefun.flink.core.reqreply.ClassLoaderSafeRequestReplyClient;
import org.apache.flink.statefun.flink.core.reqreply.RequestReplyClient;
import org.apache.flink.statefun.flink.core.reqreply.RequestReplyClientFactory;

public final class DefaultHttpRequestReplyClientFactory
implements RequestReplyClientFactory {
    public static final DefaultHttpRequestReplyClientFactory INSTANCE = new DefaultHttpRequestReplyClientFactory();
    private static final ObjectMapper OBJ_MAPPER = StateFunObjectMapper.create();
    @Nullable
    private volatile OkHttpClient sharedClient;

    private DefaultHttpRequestReplyClientFactory() {
    }

    @Override
    public RequestReplyClient createTransportClient(ObjectNode transportProperties, URI endpointUrl) {
        DefaultHttpRequestReplyClient client = this.createClient(transportProperties, endpointUrl);
        if (Thread.currentThread().getContextClassLoader() == this.getClass().getClassLoader()) {
            return client;
        }
        return new ClassLoaderSafeRequestReplyClient(client);
    }

    @Override
    public void cleanup() {
        OkHttpClient sharedClient = this.sharedClient;
        this.sharedClient = null;
        OkHttpUtils.closeSilently(sharedClient);
    }

    private DefaultHttpRequestReplyClient createClient(ObjectNode transportProperties, URI endpointUrl) {
        try (SetContextClassLoader ignored = new SetContextClassLoader((Object)this);){
            HttpUrl url;
            OkHttpClient sharedClient = this.sharedClient;
            if (sharedClient == null) {
                this.sharedClient = sharedClient = OkHttpUtils.newClient();
            }
            OkHttpClient.Builder clientBuilder = sharedClient.newBuilder();
            DefaultHttpRequestReplyClientSpec transportClientSpec = DefaultHttpRequestReplyClientFactory.parseTransportProperties(transportProperties);
            clientBuilder.callTimeout(transportClientSpec.getTimeouts().getCallTimeout());
            clientBuilder.connectTimeout(transportClientSpec.getTimeouts().getConnectTimeout());
            clientBuilder.readTimeout(transportClientSpec.getTimeouts().getReadTimeout());
            clientBuilder.writeTimeout(transportClientSpec.getTimeouts().getWriteTimeout());
            if (UnixDomainHttpEndpoint.validate(endpointUrl)) {
                UnixDomainHttpEndpoint endpoint = UnixDomainHttpEndpoint.parseFrom(endpointUrl);
                url = new HttpUrl.Builder().scheme("http").host("unused").addPathSegment(endpoint.pathSegment).build();
                OkHttpUnixSocketBridge.configureUnixDomainSocket(clientBuilder, endpoint.unixDomainFile);
            } else {
                url = HttpUrl.get((URI)endpointUrl);
            }
            DefaultHttpRequestReplyClient defaultHttpRequestReplyClient = new DefaultHttpRequestReplyClient(url, clientBuilder.build(), () -> this.isShutdown(this.sharedClient));
            return defaultHttpRequestReplyClient;
        }
    }

    private boolean isShutdown(OkHttpClient previousClient) {
        return this.sharedClient != previousClient;
    }

    private static DefaultHttpRequestReplyClientSpec parseTransportProperties(ObjectNode transportClientProperties) {
        try {
            return DefaultHttpRequestReplyClientSpec.fromJson(OBJ_MAPPER, (JsonNode)transportClientProperties);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to parse transport client properties when creating client: ", e);
        }
    }
}

