/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core.functions;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.apache.flink.statefun.flink.core.backpressure.InternalContext;
import org.apache.flink.statefun.flink.core.di.Inject;
import org.apache.flink.statefun.flink.core.di.Label;
import org.apache.flink.statefun.flink.core.functions.ApplyingContext;
import org.apache.flink.statefun.flink.core.functions.AsyncSink;
import org.apache.flink.statefun.flink.core.functions.DelaySink;
import org.apache.flink.statefun.flink.core.functions.LiveFunction;
import org.apache.flink.statefun.flink.core.functions.LocalSink;
import org.apache.flink.statefun.flink.core.functions.Partition;
import org.apache.flink.statefun.flink.core.functions.RemoteSink;
import org.apache.flink.statefun.flink.core.functions.SideOutputSink;
import org.apache.flink.statefun.flink.core.message.Message;
import org.apache.flink.statefun.flink.core.message.MessageFactory;
import org.apache.flink.statefun.flink.core.metrics.FunctionTypeMetrics;
import org.apache.flink.statefun.flink.core.state.State;
import org.apache.flink.statefun.sdk.Address;
import org.apache.flink.statefun.sdk.io.EgressIdentifier;
import org.apache.flink.statefun.sdk.metrics.Metrics;

final class ReusableContext
implements ApplyingContext,
InternalContext {
    private final Partition thisPartition;
    private final LocalSink localSink;
    private final RemoteSink remoteSink;
    private final DelaySink delaySink;
    private final AsyncSink asyncSink;
    private final SideOutputSink sideOutputSink;
    private final State state;
    private final MessageFactory messageFactory;
    private Message in;
    private LiveFunction function;

    @Inject
    ReusableContext(Partition partition, LocalSink localSink, RemoteSink remoteSink, DelaySink delaySink, AsyncSink asyncSink, SideOutputSink sideoutputSink, @Label(value="state") State state, MessageFactory messageFactory) {
        this.thisPartition = Objects.requireNonNull(partition);
        this.localSink = Objects.requireNonNull(localSink);
        this.remoteSink = Objects.requireNonNull(remoteSink);
        this.delaySink = Objects.requireNonNull(delaySink);
        this.sideOutputSink = Objects.requireNonNull(sideoutputSink);
        this.state = Objects.requireNonNull(state);
        this.messageFactory = Objects.requireNonNull(messageFactory);
        this.asyncSink = Objects.requireNonNull(asyncSink);
    }

    @Override
    public void apply(LiveFunction function, Message inMessage) {
        this.in = inMessage;
        this.function = function;
        this.state.setCurrentKey(inMessage.target());
        function.metrics().incomingMessage();
        function.receive(this, this.in);
        this.in.postApply();
        this.in = null;
    }

    public void send(Address to, Object what) {
        Objects.requireNonNull(to);
        Objects.requireNonNull(what);
        Message envelope = this.messageFactory.from(this.self(), to, what);
        if (this.thisPartition.contains(to)) {
            this.localSink.accept(envelope);
            this.function.metrics().outgoingLocalMessage();
        } else {
            this.remoteSink.accept(envelope);
            this.function.metrics().outgoingRemoteMessage();
        }
    }

    public <T> void send(EgressIdentifier<T> egress, T what) {
        Objects.requireNonNull(egress);
        Objects.requireNonNull(what);
        this.function.metrics().outgoingEgressMessage();
        this.sideOutputSink.accept(egress, what);
    }

    public void sendAfter(Duration delay, Address to, Object message) {
        Objects.requireNonNull(delay);
        Objects.requireNonNull(to);
        Objects.requireNonNull(message);
        Message envelope = this.messageFactory.from(this.self(), to, message);
        this.delaySink.accept(envelope, delay.toMillis());
    }

    public void sendAfter(Duration delay, Address to, Object message, String cancellationToken) {
        Objects.requireNonNull(delay);
        Objects.requireNonNull(to);
        Objects.requireNonNull(message);
        Objects.requireNonNull(cancellationToken);
        Message envelope = this.messageFactory.from(this.self(), to, message, cancellationToken);
        this.delaySink.accept(envelope, delay.toMillis());
    }

    public void cancelDelayedMessage(String cancellationToken) {
        Objects.requireNonNull(cancellationToken);
        this.delaySink.removeMessageByCancellationToken(cancellationToken);
    }

    public <M, T> void registerAsyncOperation(M metadata, CompletableFuture<T> future) {
        Objects.requireNonNull(metadata);
        Objects.requireNonNull(future);
        Message message = this.messageFactory.from(this.self(), this.self(), metadata);
        this.asyncSink.accept(this.self(), message, future);
    }

    public Metrics metrics() {
        return this.function.metrics().functionTypeScopedMetrics();
    }

    @Override
    public void awaitAsyncOperationComplete() {
        this.asyncSink.blockAddress(this.self());
    }

    @Override
    public FunctionTypeMetrics functionTypeMetrics() {
        return this.function.metrics();
    }

    public Address caller() {
        return this.in.source();
    }

    public Address self() {
        return this.in.target();
    }
}

