/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.linalg.typeinfo;

import java.io.IOException;
import org.apache.flink.api.common.typeutils.SimpleTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.ml.linalg.VectorWithNorm;
import org.apache.flink.ml.linalg.typeinfo.VectorSerializer;

public class VectorWithNormSerializer
extends TypeSerializer<VectorWithNorm> {
    private final VectorSerializer vectorSerializer = new VectorSerializer();
    private static final long serialVersionUID = 1L;
    private static final double[] EMPTY = new double[0];

    public boolean isImmutableType() {
        return false;
    }

    public TypeSerializer<VectorWithNorm> duplicate() {
        return new VectorWithNormSerializer();
    }

    public VectorWithNorm createInstance() {
        return new VectorWithNorm(new DenseVector(EMPTY));
    }

    public VectorWithNorm copy(VectorWithNorm from) {
        Vector vector = this.vectorSerializer.copy(from.vector);
        return new VectorWithNorm(vector, from.l2Norm);
    }

    public VectorWithNorm copy(VectorWithNorm from, VectorWithNorm reuse) {
        Vector vector = this.vectorSerializer.copy(from.vector, reuse.vector);
        return new VectorWithNorm(vector, from.l2Norm);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(VectorWithNorm from, DataOutputView dataOutputView) throws IOException {
        this.vectorSerializer.serialize(from.vector, dataOutputView);
        dataOutputView.writeDouble(from.l2Norm);
    }

    public VectorWithNorm deserialize(DataInputView dataInputView) throws IOException {
        Vector vector = this.vectorSerializer.deserialize(dataInputView);
        double l2NormSquare = dataInputView.readDouble();
        return new VectorWithNorm(vector, l2NormSquare);
    }

    public VectorWithNorm deserialize(VectorWithNorm reuse, DataInputView dataInputView) throws IOException {
        Vector vector = this.vectorSerializer.deserialize(reuse.vector, dataInputView);
        double l2NormSquare = dataInputView.readDouble();
        return new VectorWithNorm(vector, l2NormSquare);
    }

    public void copy(DataInputView dataInputView, DataOutputView dataOutputView) throws IOException {
        this.vectorSerializer.copy(dataInputView, dataOutputView);
        dataOutputView.write(dataInputView, 8);
    }

    public boolean equals(Object o) {
        return o instanceof VectorWithNormSerializer;
    }

    public int hashCode() {
        return VectorWithNormSerializer.class.hashCode();
    }

    public TypeSerializerSnapshot<VectorWithNorm> snapshotConfiguration() {
        return new VectorWithNormSerializerSnapshot();
    }

    private static class VectorWithNormSerializerSnapshot
    extends SimpleTypeSerializerSnapshot<VectorWithNorm> {
        public VectorWithNormSerializerSnapshot() {
            super(VectorWithNormSerializer::new);
        }
    }
}

