/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration.operator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.flink.iteration.operator.HeadOperator;
import org.apache.flink.iteration.operator.event.CoordinatorCheckpointEvent;
import org.apache.flink.iteration.operator.event.GloballyAlignedEvent;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.function.RunnableWithException;

class HeadOperatorCheckpointAligner {
    private final TreeMap<Long, CheckpointAlignment> checkpointAlignmments = new TreeMap();
    private long latestCheckpointFromCoordinator;
    private long latestAbortedCheckpoint;

    HeadOperatorCheckpointAligner() {
    }

    void waitTillCoordinatorNotified(HeadOperator.HeadOperatorStatus status, long checkpointId, RunnableWithException defaultAction) throws Exception {
        CheckpointAlignment checkpointAlignment = this.checkpointAlignmments.computeIfAbsent(checkpointId, ignored -> new CheckpointAlignment(true, status != HeadOperator.HeadOperatorStatus.RUNNING));
        while (!checkpointAlignment.notifiedFromCoordinator) {
            defaultAction.run();
        }
        checkpointAlignment.notifiedFromChannels = true;
    }

    void coordinatorNotify(CoordinatorCheckpointEvent checkpointEvent) {
        Preconditions.checkState((checkpointEvent.getCheckpointId() > this.latestCheckpointFromCoordinator ? 1 : 0) != 0);
        this.latestCheckpointFromCoordinator = checkpointEvent.getCheckpointId();
        if (this.latestCheckpointFromCoordinator <= this.latestAbortedCheckpoint) {
            return;
        }
        CheckpointAlignment checkpointAlignment = this.checkpointAlignmments.computeIfAbsent(checkpointEvent.getCheckpointId(), ignored -> new CheckpointAlignment(false, true));
        checkpointAlignment.notifiedFromCoordinator = true;
    }

    Optional<GloballyAlignedEvent> checkHoldingGloballyAlignedEvent(GloballyAlignedEvent globallyAlignedEvent) {
        CheckpointAlignment checkpointAlignment = this.checkpointAlignmments.get(this.latestCheckpointFromCoordinator);
        if (checkpointAlignment != null && !checkpointAlignment.notifiedFromChannels) {
            checkpointAlignment.pendingGlobalEvents.add(globallyAlignedEvent);
            return Optional.empty();
        }
        return Optional.of(globallyAlignedEvent);
    }

    List<GloballyAlignedEvent> onStateSnapshot(long checkpointId) {
        CheckpointAlignment checkpointAlignment = this.checkpointAlignmments.remove(checkpointId);
        Preconditions.checkState((checkpointAlignment.notifiedFromCoordinator && checkpointAlignment.notifiedFromChannels ? 1 : 0) != 0, (Object)("Checkpoint " + checkpointId + " is not fully aligned"));
        return checkpointAlignment.pendingGlobalEvents;
    }

    List<GloballyAlignedEvent> onCheckpointAborted(long checkpointId) {
        if (checkpointId <= this.latestAbortedCheckpoint) {
            return Collections.emptyList();
        }
        this.latestAbortedCheckpoint = checkpointId;
        NavigableMap<Long, CheckpointAlignment> abortedAlignments = this.checkpointAlignmments.headMap(this.latestAbortedCheckpoint, true);
        ArrayList<GloballyAlignedEvent> events = new ArrayList<GloballyAlignedEvent>();
        abortedAlignments.values().forEach(alignment -> events.addAll(alignment.pendingGlobalEvents));
        abortedAlignments.clear();
        return events;
    }

    private static class CheckpointAlignment {
        final List<GloballyAlignedEvent> pendingGlobalEvents = new ArrayList<GloballyAlignedEvent>();
        boolean notifiedFromChannels;
        boolean notifiedFromCoordinator;

        public CheckpointAlignment(boolean notifiedFromChannels, boolean notifiedFromCoordinator) {
            this.notifiedFromChannels = notifiedFromChannels;
            this.notifiedFromCoordinator = notifiedFromCoordinator;
        }
    }
}

