/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.iteration;

import java.io.Serializable;
import org.apache.flink.annotation.Experimental;
import org.apache.flink.iteration.DataStreamList;
import org.apache.flink.iteration.IterationBodyResult;
import org.apache.flink.iteration.compile.DraftExecutionEnvironment;
import org.apache.flink.iteration.operator.OperatorWrapper;
import org.apache.flink.iteration.operator.perround.PerRoundOperatorWrapper;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.util.Preconditions;

@Experimental
public interface IterationBody
extends Serializable {
    public IterationBodyResult process(DataStreamList var1, DataStreamList var2);

    public static DataStreamList forEachRound(DataStreamList inputs, PerRoundSubBody perRoundSubBody) {
        Preconditions.checkArgument((inputs.size() > 0 ? 1 : 0) != 0, (Object)"At least one input is required");
        DataStream first = inputs.get(0);
        DraftExecutionEnvironment env = (DraftExecutionEnvironment)first.getExecutionEnvironment();
        for (int i = 0; i < inputs.size(); ++i) {
            env.addOperatorIfNotExists(inputs.get(i).getTransformation());
        }
        OperatorWrapper<?, ?> oldWrapper = env.setCurrentWrapper(new PerRoundOperatorWrapper());
        DataStreamList outputs = perRoundSubBody.process(inputs);
        for (int i = 0; i < inputs.size(); ++i) {
            env.addOperatorIfNotExists(inputs.get(i).getTransformation());
        }
        env.setCurrentWrapper(oldWrapper);
        return outputs;
    }

    public static interface PerRoundSubBody {
        public DataStreamList process(DataStreamList var1);
    }
}

