/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.examples.feature;

import java.util.Arrays;
import org.apache.flink.ml.feature.featurehasher.FeatureHasher;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSource;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.CloseableIterator;

public class FeatureHasherExample {
    public static void main(String[] args) {
        StreamExecutionEnvironment env = StreamExecutionEnvironment.getExecutionEnvironment();
        StreamTableEnvironment tEnv = StreamTableEnvironment.create((StreamExecutionEnvironment)env);
        DataStreamSource dataStream = env.fromCollection(Arrays.asList(Row.of((Object[])new Object[]{0, "a", 1.0, true}), Row.of((Object[])new Object[]{1, "c", 1.0, false})));
        Table inputDataTable = tEnv.fromDataStream((DataStream)dataStream).as("id", new String[]{"f0", "f1", "f2"});
        FeatureHasher featureHash = (FeatureHasher)((FeatureHasher)((FeatureHasher)((FeatureHasher)new FeatureHasher().setInputCols(new String[]{"f0", "f1", "f2"})).setCategoricalCols(new String[]{"f0", "f2"})).setOutputCol("vec")).setNumFeatures(1000);
        Table outputTable = featureHash.transform(new Table[]{inputDataTable})[0];
        CloseableIterator it = outputTable.execute().collect();
        while (it.hasNext()) {
            Row row = (Row)it.next();
            Object[] inputValues = new Object[featureHash.getInputCols().length];
            for (int i = 0; i < inputValues.length; ++i) {
                inputValues[i] = row.getField(featureHash.getInputCols()[i]);
            }
            Vector outputValue = (Vector)row.getField(featureHash.getOutputCol());
            System.out.printf("Input Values: %s \tOutput Value: %s\n", Arrays.toString(inputValues), outputValue);
        }
    }
}

