/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.linalg;

import dev.ludovic.netlib.JavaBLAS;
import org.apache.flink.ml.linalg.DenseMatrix;
import org.apache.flink.ml.linalg.DenseVector;
import org.apache.flink.ml.linalg.SparseVector;
import org.apache.flink.ml.linalg.Vector;
import org.apache.flink.util.Preconditions;

public class BLAS {
    private static final dev.ludovic.netlib.BLAS JAVA_BLAS = JavaBLAS.getInstance();

    public static double asum(DenseVector x) {
        return JAVA_BLAS.dasum(x.size(), x.values, 0, 1);
    }

    public static void axpy(double a, Vector x, DenseVector y) {
        Preconditions.checkArgument((x.size() == y.size() ? 1 : 0) != 0, (Object)"Vector size mismatched.");
        BLAS.axpy(a, x, y, x.size());
    }

    public static void axpy(double a, Vector x, DenseVector y, int k) {
        Preconditions.checkArgument((x.size() >= k && y.size() >= k ? 1 : 0) != 0);
        if (x instanceof SparseVector) {
            BLAS.axpy(a, (SparseVector)x, y, k);
        } else {
            BLAS.axpy(a, (DenseVector)x, y, k);
        }
    }

    public static void hDot(Vector x, Vector y) {
        Preconditions.checkArgument((x.size() == y.size() ? 1 : 0) != 0, (Object)"Vector size mismatched.");
        if (x instanceof SparseVector) {
            if (y instanceof SparseVector) {
                BLAS.hDot((SparseVector)x, (SparseVector)y);
            } else {
                BLAS.hDot((SparseVector)x, (DenseVector)y);
            }
        } else if (y instanceof SparseVector) {
            BLAS.hDot((DenseVector)x, (SparseVector)y);
        } else {
            BLAS.hDot((DenseVector)x, (DenseVector)y);
        }
    }

    public static double dot(Vector x, Vector y) {
        Preconditions.checkArgument((x.size() == y.size() ? 1 : 0) != 0, (Object)"Vector size mismatched.");
        if (x instanceof SparseVector) {
            if (y instanceof SparseVector) {
                return BLAS.dot((SparseVector)x, (SparseVector)y);
            }
            return BLAS.dot((DenseVector)y, (SparseVector)x);
        }
        if (y instanceof SparseVector) {
            return BLAS.dot((DenseVector)x, (SparseVector)y);
        }
        return BLAS.dot((DenseVector)x, (DenseVector)y);
    }

    private static double dot(DenseVector x, DenseVector y) {
        return JAVA_BLAS.ddot(x.size(), x.values, 1, y.values, 1);
    }

    private static double dot(DenseVector x, SparseVector y) {
        double dotValue = 0.0;
        for (int i = 0; i < y.indices.length; ++i) {
            dotValue += y.values[i] * x.values[y.indices[i]];
        }
        return dotValue;
    }

    private static double dot(SparseVector x, SparseVector y) {
        double dotValue = 0.0;
        int p0 = 0;
        int p1 = 0;
        while (p0 < x.values.length && p1 < y.values.length) {
            if (x.indices[p0] == y.indices[p1]) {
                dotValue += x.values[p0] * y.values[p1];
                ++p0;
                ++p1;
                continue;
            }
            if (x.indices[p0] < y.indices[p1]) {
                ++p0;
                continue;
            }
            ++p1;
        }
        return dotValue;
    }

    public static double norm2(Vector x) {
        if (x instanceof DenseVector) {
            return BLAS.norm2((DenseVector)x);
        }
        return BLAS.norm2((SparseVector)x);
    }

    private static double norm2(DenseVector x) {
        return JAVA_BLAS.dnrm2(x.size(), x.values, 1);
    }

    private static double norm2(SparseVector x) {
        return JAVA_BLAS.dnrm2(x.values.length, x.values, 1);
    }

    public static double norm(Vector x, double p) {
        double[] data;
        Preconditions.checkArgument((p >= 1.0 ? 1 : 0) != 0, (Object)("p value must >= 1.0, but the current p is : " + p));
        double norm = 0.0;
        double[] dArray = data = x instanceof DenseVector ? ((DenseVector)x).values : ((SparseVector)x).values;
        if (p == 1.0) {
            for (double datum : data) {
                norm += Math.abs(datum);
            }
        } else if (p == 2.0) {
            norm = BLAS.norm2(x);
        } else if (p == Double.POSITIVE_INFINITY) {
            for (double datum : data) {
                norm = Math.max(Math.abs(datum), norm);
            }
        } else {
            for (double datum : data) {
                norm += Math.pow(Math.abs(datum), p);
            }
            norm = Math.pow(norm, 1.0 / p);
        }
        return norm;
    }

    public static void scal(double a, Vector x) {
        if (x instanceof DenseVector) {
            JAVA_BLAS.dscal(x.size(), a, ((DenseVector)x).values, 1);
        } else {
            double[] values = ((SparseVector)x).values;
            JAVA_BLAS.dscal(values.length, a, values, 1);
        }
    }

    public static void gemv(double alpha, DenseMatrix matrix, boolean transMatrix, DenseVector x, double beta, DenseVector y) {
        Preconditions.checkArgument((boolean)(transMatrix ? matrix.numRows() == x.size() && matrix.numCols() == y.size() : matrix.numRows() == y.size() && matrix.numCols() == x.size()), (Object)"Matrix and vector size mismatched.");
        String trans = transMatrix ? "T" : "N";
        JAVA_BLAS.dgemv(trans, matrix.numRows(), matrix.numCols(), alpha, matrix.values, matrix.numRows(), x.values, 1, beta, y.values, 1);
    }

    private static void axpy(double a, DenseVector x, DenseVector y, int k) {
        JAVA_BLAS.daxpy(k, a, x.values, 1, y.values, 1);
    }

    private static void axpy(double a, SparseVector x, DenseVector y, int k) {
        for (int i = 0; i < x.indices.length; ++i) {
            int index = x.indices[i];
            if (index >= k) {
                return;
            }
            int n = index;
            y.values[n] = y.values[n] + a * x.values[i];
        }
    }

    private static void hDot(SparseVector x, SparseVector y) {
        int idy = 0;
        for (int idx = 0; idx < x.indices.length && idy < y.indices.length; ++idx) {
            int indexX = x.indices[idx];
            while (idy < y.indices.length && y.indices[idy] < indexX) {
                y.values[idy] = 0.0;
                ++idy;
            }
            if (idy >= y.indices.length || y.indices[idy] != indexX) continue;
            int n = idy++;
            y.values[n] = y.values[n] * x.values[idx];
        }
        while (idy < y.indices.length) {
            y.values[idy] = 0.0;
            ++idy;
        }
    }

    private static void hDot(SparseVector x, DenseVector y) {
        int idx = 0;
        for (int i = 0; i < y.size(); ++i) {
            if (idx < x.indices.length && x.indices[idx] == i) {
                int n = i;
                y.values[n] = y.values[n] * x.values[idx];
                ++idx;
                continue;
            }
            y.values[i] = 0.0;
        }
    }

    private static void hDot(DenseVector x, SparseVector y) {
        for (int i = 0; i < y.values.length; ++i) {
            int n = i;
            y.values[n] = y.values[n] * x.values[y.indices[i]];
        }
    }

    private static void hDot(DenseVector x, DenseVector y) {
        for (int i = 0; i < x.values.length; ++i) {
            int n = i;
            y.values[n] = y.values[n] * x.values[i];
        }
    }
}

