/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.ml.benchmark.datagenerator;

import org.apache.flink.ml.benchmark.datagenerator.DataGenerator;
import org.apache.flink.ml.param.LongParam;
import org.apache.flink.ml.param.Param;
import org.apache.flink.ml.param.ParamValidators;
import org.apache.flink.ml.param.StringArrayArrayParam;

public interface InputDataGenerator<T extends InputDataGenerator<T>>
extends DataGenerator<T> {
    public static final Param<Long> NUM_VALUES = new LongParam("numValues", "Number of data to be generated.", 10L, ParamValidators.gt(0.0));
    public static final Param<String[][]> COL_NAMES = new StringArrayArrayParam("colNames", "A 2D array of strings. Each string array element represents the column names of a data table.", null);

    default public long getNumValues() {
        return this.get(NUM_VALUES);
    }

    default public T setNumValues(long value) {
        return (T)((InputDataGenerator)this.set(NUM_VALUES, value));
    }

    default public String[][] getColNames() {
        return this.get(COL_NAMES);
    }

    default public T setColNames(String[] ... value) {
        return (T)((InputDataGenerator)this.set(COL_NAMES, value));
    }
}

