/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.statefun.flink.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.CoreOptions;
import org.apache.flink.statefun.flink.core.StatefulFunctionsConfig;
import org.apache.flink.statefun.flink.core.exceptions.StatefulFunctionsInvalidConfigException;
import org.apache.flink.statefun.flink.core.message.MessageFactoryType;
import org.apache.flink.util.StringUtils;

public final class StatefulFunctionsConfigValidator {
    public static final List<String> PARENT_FIRST_CLASSLOADER_PATTERNS = Collections.unmodifiableList(Arrays.asList("org.apache.flink.statefun", "org.apache.kafka", "com.google.protobuf"));
    public static final int MAX_CONCURRENT_CHECKPOINTS = 1;
    private static final ConfigOption<String> TIMER_SERVICE_FACTORY = ConfigOptions.key((String)"state.backend.rocksdb.timer-service.factory").stringType().defaultValue((Object)"rocksdb");
    private static final ConfigOption<Boolean> ENABLE_UNALIGNED_CHECKPOINTS = ConfigOptions.key((String)"execution.checkpointing.unaligned").booleanType().defaultValue((Object)false);

    private StatefulFunctionsConfigValidator() {
    }

    static void validate(Configuration configuration) {
        StatefulFunctionsConfigValidator.validateParentFirstClassloaderPatterns(configuration);
        StatefulFunctionsConfigValidator.validateCustomPayloadSerializerClassName(configuration);
        StatefulFunctionsConfigValidator.validateNoHeapBackedTimers(configuration);
        StatefulFunctionsConfigValidator.validateUnalignedCheckpointsDisabled(configuration);
    }

    private static void validateParentFirstClassloaderPatterns(Configuration configuration) {
        Set<String> parentFirstClassloaderPatterns = StatefulFunctionsConfigValidator.parentFirstClassloaderPatterns(configuration);
        if (!parentFirstClassloaderPatterns.containsAll(PARENT_FIRST_CLASSLOADER_PATTERNS)) {
            throw new StatefulFunctionsInvalidConfigException(CoreOptions.ALWAYS_PARENT_FIRST_LOADER_PATTERNS_ADDITIONAL, "Must contain all of " + String.join((CharSequence)", ", PARENT_FIRST_CLASSLOADER_PATTERNS));
        }
    }

    private static Set<String> parentFirstClassloaderPatterns(Configuration configuration) {
        String[] split = ((String)configuration.get(CoreOptions.ALWAYS_PARENT_FIRST_LOADER_PATTERNS_ADDITIONAL)).split(";");
        HashSet<String> parentFirstClassloaderPatterns = new HashSet<String>(split.length);
        for (String s : split) {
            parentFirstClassloaderPatterns.add(s.trim().toLowerCase(Locale.ENGLISH));
        }
        return parentFirstClassloaderPatterns;
    }

    private static void validateCustomPayloadSerializerClassName(Configuration configuration) {
        MessageFactoryType factoryType = (MessageFactoryType)((Object)configuration.get(StatefulFunctionsConfig.USER_MESSAGE_SERIALIZER));
        String customPayloadSerializerClassName = (String)configuration.get(StatefulFunctionsConfig.USER_MESSAGE_CUSTOM_PAYLOAD_SERIALIZER_CLASS);
        if (factoryType == MessageFactoryType.WITH_CUSTOM_PAYLOADS) {
            if (StringUtils.isNullOrWhitespaceOnly((String)customPayloadSerializerClassName)) {
                throw new StatefulFunctionsInvalidConfigException(StatefulFunctionsConfig.USER_MESSAGE_CUSTOM_PAYLOAD_SERIALIZER_CLASS, "custom payload serializer class must be supplied with WITH_CUSTOM_PAYLOADS serializer");
            }
        } else if (customPayloadSerializerClassName != null) {
            throw new StatefulFunctionsInvalidConfigException(StatefulFunctionsConfig.USER_MESSAGE_CUSTOM_PAYLOAD_SERIALIZER_CLASS, "custom payload serializer class may only be supplied with WITH_CUSTOM_PAYLOADS serializer");
        }
    }

    private static void validateNoHeapBackedTimers(Configuration configuration) {
        String timerFactory = configuration.getString(TIMER_SERVICE_FACTORY);
        if (!timerFactory.equalsIgnoreCase("rocksdb")) {
            throw new StatefulFunctionsInvalidConfigException(TIMER_SERVICE_FACTORY, "StateFun only supports non-heap timers with a rocksdb state backend.");
        }
    }

    private static void validateUnalignedCheckpointsDisabled(Configuration configuration) {
        boolean unalignedCheckpoints = configuration.getBoolean(ENABLE_UNALIGNED_CHECKPOINTS);
        if (unalignedCheckpoints) {
            throw new StatefulFunctionsInvalidConfigException(ENABLE_UNALIGNED_CHECKPOINTS, "StateFun currently does not support unaligned checkpointing.");
        }
    }
}

