/*
 * Decompiled with CFR 0.152.
 */
package flash.localization;

import flash.localization.ILocalizedText;
import flash.localization.ILocalizer;
import flash.localization.LocalizationManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XLRLocalizer
implements ILocalizer {
    private Map<String, XLRFile> filedict = new HashMap<String, XLRFile>();
    private Map<String, XLRNode> nodedict = new HashMap<String, XLRNode>();

    public XLRLocalizer() {
    }

    public XLRLocalizer(String string) {
        this.findFiles(new File(string), null);
    }

    public XLRTargetNode loadNode(Locale locale, String string, Locale locale2, String string2) {
        Object object;
        Object object2;
        String string3 = this.getKey(locale, string);
        XLRFile xLRFile = this.filedict.get(string3);
        if (xLRFile == null) {
            object2 = string3.replaceAll("\\.", "/") + ".xlr";
            object = this.getClass().getClassLoader().getResource((String)object2);
            if (object != null) {
                xLRFile = new XLRFile(string, (URL)object);
                this.filedict.put(string3, xLRFile);
            }
        }
        if (xLRFile != null) {
            xLRFile.load();
            object2 = (XLRMessageNode)this.nodedict.get(string2);
            if (object2 != null) {
                object = ((XLRMessageNode)object2).getTarget(locale2.toString());
                return object;
            }
        }
        return null;
    }

    public XLRTargetNode checkPrefix(Locale locale, String string, Locale locale2, String string2) {
        XLRTargetNode xLRTargetNode = this.loadNode(locale, string, locale2, string2);
        if (xLRTargetNode == null) {
            int n = string.lastIndexOf(36);
            if (n == -1) {
                n = string.lastIndexOf(46);
            }
            if (n != -1) {
                xLRTargetNode = this.checkPrefix(locale, string.substring(0, n), locale2, string2);
            }
        }
        return xLRTargetNode;
    }

    public XLRTargetNode checkLocales(Locale locale, String string) {
        XLRTargetNode xLRTargetNode = this.checkPrefix(locale, string, locale, string);
        if (xLRTargetNode == null && locale.getCountry().length() > 0 && locale.getVariant().length() > 0) {
            xLRTargetNode = this.checkPrefix(new Locale(locale.getLanguage(), locale.getCountry()), string, locale, string);
        }
        if (xLRTargetNode == null && locale.getCountry().length() > 0) {
            xLRTargetNode = this.checkPrefix(new Locale(locale.getLanguage()), string, locale, string);
        }
        if (xLRTargetNode == null) {
            xLRTargetNode = this.checkPrefix(null, string, locale, string);
        }
        return xLRTargetNode;
    }

    @Override
    public ILocalizedText getLocalizedText(Locale locale, String string) {
        XLRMessageNode xLRMessageNode = (XLRMessageNode)this.nodedict.get(string);
        XLRTargetNode xLRTargetNode = null;
        if (xLRMessageNode != null) {
            xLRTargetNode = xLRMessageNode.getTarget(locale.toString());
        }
        if (xLRTargetNode == null) {
            xLRTargetNode = this.checkLocales(locale, string);
        }
        if (xLRTargetNode == null) {
            return null;
        }
        return new XLRLocalizedText(xLRTargetNode);
    }

    private String getKey(Locale locale, String string) {
        String string2 = string;
        if (locale != null && locale.getLanguage().length() > 0) {
            string2 = string2 + "_" + locale.getLanguage();
            if (locale.getCountry().length() > 0) {
                string2 = string2 + "_" + locale.getCountry();
                if (locale.getVariant().length() > 0) {
                    string2 = string2 + "_" + locale.getVariant();
                }
            }
        }
        return string2;
    }

    private void findFiles(File file, String string) {
        try {
            if (!file.exists()) {
                return;
            }
            if (file.isDirectory()) {
                File[] fileArray = file.listFiles();
                for (int i = 0; i < fileArray.length; ++i) {
                    this.findFiles(fileArray[i].getAbsoluteFile(), (string == null ? "" : string + ".") + fileArray[i].getName());
                }
            } else {
                String string2;
                if (!file.getName().endsWith(".xlr")) {
                    return;
                }
                String string3 = string2 = string.substring(0, string.length() - ".xlr".length());
                int n = string2.lastIndexOf(46);
                int n2 = -1;
                n2 = n != -1 ? string2.indexOf(95, n) : string2.indexOf(95);
                if (n2 != -1) {
                    string3 = string2.substring(0, n2);
                }
                this.filedict.put(string2, new XLRFile(string3, file.toURL()));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private class CDATAHandler
    implements LexicalHandler {
        private XLRHandler parentHandler;

        public CDATAHandler(XLRHandler xLRHandler) {
            this.parentHandler = xLRHandler;
        }

        @Override
        public void startCDATA() throws SAXException {
            this.parentHandler.inCDATA = true;
        }

        @Override
        public void endCDATA() throws SAXException {
            this.parentHandler.inCDATA = false;
        }

        @Override
        public void startDTD(String string, String string2, String string3) throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void startEntity(String string) throws SAXException {
        }

        @Override
        public void endEntity(String string) throws SAXException {
        }

        @Override
        public void comment(char[] cArray, int n, int n2) throws SAXException {
        }
    }

    private class XLRHandler
    extends DefaultHandler {
        public Stack<XLRNode> context = new Stack();
        private String fileLocale = null;
        private String base = null;
        private Map<String, XLRNode> nodedict;
        StringBuilder textBuffer = new StringBuilder(128);
        protected boolean inCDATA = false;

        public XLRHandler(Map<String, XLRNode> map, String string) {
            this.nodedict = map;
            this.base = string;
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            String string4;
            XLRNode xLRNode = null;
            if (this.context.size() > 0) {
                xLRNode = this.context.peek();
            }
            if ((string4 = attributes.getValue("locale")) == null) {
                string4 = this.fileLocale;
            }
            String string5 = attributes.getValue("text");
            XLRNode xLRNode2 = null;
            if ("messages".equals(string3)) {
                this.fileLocale = attributes.getValue("locale");
                if (attributes.getValue("idbase") != null) {
                    this.base = attributes.getValue("idbase");
                }
            } else if ("message".equals(string3)) {
                String string6 = attributes.getValue("id");
                if (this.base != null) {
                    string6 = this.base + "." + string6;
                }
                if ((xLRNode2 = this.nodedict.get(string6)) == null) {
                    xLRNode2 = new XLRMessageNode(string6);
                    this.nodedict.put(string6, xLRNode2);
                }
                if (string5 != null && string4 != null) {
                    XLRTargetNode xLRTargetNode = new XLRTargetNode(string4);
                    xLRNode2.children.add(xLRTargetNode);
                    XLRTextNode xLRTextNode = new XLRTextNode(string5);
                    xLRTargetNode.children.add(xLRTextNode);
                }
                this.context.push(xLRNode2);
            } else if ("target".equals(string3)) {
                xLRNode2 = new XLRTargetNode(string4);
                if (string5 != null) {
                    xLRNode2.children.add(new XLRTextNode(string5));
                }
                xLRNode.children.add(xLRNode2);
                this.context.push(xLRNode2);
            } else if ("text".equals(string3)) {
                String string7 = attributes.getValue("value");
                xLRNode2 = new XLRTextNode(string7);
                xLRNode.children.add(xLRNode2);
                this.context.push(xLRNode2);
            } else if ("variable".equals(string3)) {
                String string8 = attributes.getValue("name");
                xLRNode2 = new XLRVariableNode(string8);
                xLRNode.children.add(xLRNode2);
                this.context.push(xLRNode2);
            } else if ("match".equals(string3)) {
                xLRNode2 = new XLRMatchNode(attributes.getValue("variable"), attributes.getValue("pattern"));
                if (string5 != null) {
                    xLRNode2.children.add(new XLRTextNode(string5));
                }
                xLRNode.children.add(xLRNode2);
                this.context.push(xLRNode2);
            } else if ("select".equals(string3)) {
                xLRNode2 = new XLRChoiceNode();
                xLRNode.children.add(xLRNode2);
                this.context.push(xLRNode2);
            } else {
                throw new SAXParseException("blorp", null);
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) throws SAXException {
            XLRNode xLRNode = null;
            if (this.context.size() > 0) {
                xLRNode = this.context.pop();
            }
            if (!"messages".equals(string3)) {
                if ("text".equals(string3)) {
                    if (this.textBuffer.length() > 0) {
                        xLRNode.children.add(new XLRTextNode(this.textBuffer.toString()));
                    }
                } else if ("variable".equals(string3) && this.textBuffer.length() > 0) {
                    ((XLRVariableNode)xLRNode).varname = this.textBuffer.toString();
                }
            }
            this.textBuffer.setLength(0);
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.inCDATA) {
                this.textBuffer.append(cArray, n, n2);
            } else {
                String string = new String(cArray, n, n2).trim();
                if (string.length() > 0) {
                    this.textBuffer.append(string);
                }
            }
        }

        @Override
        public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }
    }

    private class XLRMatchNode
    extends XLRNode {
        public String varname;
        public String text;
        public String pattern;

        public XLRMatchNode(String string, String string2) {
            this.text = null;
            this.pattern = null;
            this.varname = string;
            this.pattern = string2;
        }

        @Override
        public boolean execute(StringBuilder stringBuilder, String string, Map map) {
            String string2 = null;
            if (this.varname != null && map.containsKey(this.varname) && map.get(this.varname) != null) {
                string2 = map.get(this.varname).toString();
            }
            if (string2 == null) {
                string2 = "";
            }
            boolean bl = false;
            bl = this.pattern == null ? (string2 != null && string2.length() > 0 ? !string2.equalsIgnoreCase("false") && !string2.equals("0") : false) : string2.matches(this.pattern);
            if (bl) {
                super.execute(stringBuilder, string, map);
                return true;
            }
            return false;
        }
    }

    private class XLRVariableNode
    extends XLRNode {
        public String varname;

        public XLRVariableNode(String string) {
            this.varname = string;
        }

        @Override
        public boolean execute(StringBuilder stringBuilder, String string, Map map) {
            boolean bl = false;
            if (this.varname != null) {
                boolean bl2 = bl = map.containsKey(this.varname) && map.get(this.varname) != null;
                if (bl) {
                    stringBuilder.append(map.get(this.varname).toString());
                }
            }
            return bl |= super.execute(stringBuilder, string, map);
        }
    }

    private class XLRTextNode
    extends XLRNode {
        public final String text;

        public XLRTextNode(String string) {
            this.text = string;
        }

        @Override
        public boolean execute(StringBuilder stringBuilder, String string, Map map) {
            boolean bl = false;
            if (this.text != null) {
                bl = true;
                stringBuilder.append(this.text);
            }
            boolean bl2 = super.execute(stringBuilder, string, map);
            return bl || bl2;
        }
    }

    private class XLRTargetNode
    extends XLRNode {
        public final String locale;

        public XLRTargetNode(String string) {
            this.locale = string;
        }

        public boolean matchesLocale(String string) {
            return this.locale == null && string == null || string.equalsIgnoreCase(this.locale);
        }

        @Override
        public boolean execute(StringBuilder stringBuilder, String string, Map map) {
            if (this.matchesLocale(string)) {
                return super.execute(stringBuilder, string, map);
            }
            return false;
        }
    }

    private class XLRMessageNode
    extends XLRChoiceNode {
        public final String id;

        public XLRMessageNode(String string) {
            this.id = string;
        }

        public XLRTargetNode getTarget(String string) {
            for (XLRNode xLRNode : this.children) {
                if (!(xLRNode instanceof XLRTargetNode) || !((XLRTargetNode)xLRNode).matchesLocale(string)) continue;
                return (XLRTargetNode)xLRNode;
            }
            return null;
        }
    }

    private class XLRChoiceNode
    extends XLRNode {
        private XLRChoiceNode() {
        }

        @Override
        public boolean execute(StringBuilder stringBuilder, String string, Map map) {
            for (XLRNode xLRNode : this.children) {
                if (!xLRNode.execute(stringBuilder, string, map)) continue;
                return true;
            }
            return false;
        }
    }

    private abstract class XLRNode {
        public LinkedList<XLRNode> children = new LinkedList();

        private XLRNode() {
        }

        public boolean execute(StringBuilder stringBuilder, String string, Map map) {
            boolean bl = false;
            for (XLRNode xLRNode : this.children) {
                if (!xLRNode.execute(stringBuilder, string, map)) continue;
                bl = true;
            }
            return bl;
        }
    }

    private class XLRLocalizedText
    implements ILocalizedText {
        private XLRTargetNode node;

        public XLRLocalizedText(XLRTargetNode xLRTargetNode) {
            this.node = xLRTargetNode;
        }

        @Override
        public String format(Map map) {
            String string;
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = string = this.node.execute(stringBuilder, this.node.locale, map) ? stringBuilder.toString() : null;
            if (string != null) {
                string = LocalizationManager.replaceInlineReferences(string, map);
            }
            return string;
        }
    }

    private class XLRFile {
        private boolean loaded = false;
        private final URL url;
        private final String prefix;

        public XLRFile(String string, URL uRL) {
            this.prefix = string;
            this.url = uRL;
        }

        public void load() {
            if (this.loaded) {
                return;
            }
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(this.url.openStream());
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setNamespaceAware(false);
                XLRHandler xLRHandler = new XLRHandler(XLRLocalizer.this.nodedict, this.prefix);
                CDATAHandler cDATAHandler = new CDATAHandler(xLRHandler);
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                sAXParser.setProperty("http://xml.org/sax/properties/lexical-handler", cDATAHandler);
                sAXParser.parse((InputStream)bufferedInputStream, (DefaultHandler)xLRHandler);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            this.loaded = true;
        }
    }
}

