/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flex.compiler.internal.codegen.js.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.flex.compiler.common.ISourceLocation;
import org.apache.flex.compiler.definitions.IClassDefinition;
import org.apache.flex.compiler.definitions.IDefinition;
import org.apache.flex.compiler.definitions.IFunctionDefinition;
import org.apache.flex.compiler.definitions.ITypeDefinition;
import org.apache.flex.compiler.definitions.IVariableDefinition;
import org.apache.flex.compiler.internal.codegen.js.JSSessionModel;
import org.apache.flex.compiler.internal.definitions.AccessorDefinition;
import org.apache.flex.compiler.internal.definitions.ClassDefinition;
import org.apache.flex.compiler.internal.definitions.FunctionDefinition;
import org.apache.flex.compiler.internal.definitions.InterfaceDefinition;
import org.apache.flex.compiler.internal.definitions.NamespaceDefinition;
import org.apache.flex.compiler.internal.definitions.ParameterDefinition;
import org.apache.flex.compiler.internal.definitions.VariableDefinition;
import org.apache.flex.compiler.internal.projects.CompilerProject;
import org.apache.flex.compiler.internal.scopes.TypeScope;
import org.apache.flex.compiler.internal.tree.as.ContainerNode;
import org.apache.flex.compiler.internal.tree.as.NodeBase;
import org.apache.flex.compiler.internal.tree.as.ParameterNode;
import org.apache.flex.compiler.projects.ICompilerProject;
import org.apache.flex.compiler.tree.ASTNodeID;
import org.apache.flex.compiler.tree.as.IASNode;
import org.apache.flex.compiler.tree.as.IClassNode;
import org.apache.flex.compiler.tree.as.IContainerNode;
import org.apache.flex.compiler.tree.as.IDefinitionNode;
import org.apache.flex.compiler.tree.as.IExpressionNode;
import org.apache.flex.compiler.tree.as.IFunctionNode;
import org.apache.flex.compiler.tree.as.IIdentifierNode;
import org.apache.flex.compiler.tree.as.INamespaceNode;
import org.apache.flex.compiler.tree.as.IPackageNode;
import org.apache.flex.compiler.tree.as.IParameterNode;
import org.apache.flex.compiler.tree.as.IScopedNode;
import org.apache.flex.compiler.tree.as.ITypeNode;
import org.apache.flex.compiler.tree.as.IVariableNode;
import org.apache.flex.compiler.utils.NativeUtils;

public class EmitterUtils {
    public static ITypeNode findTypeNode(IPackageNode node) {
        IScopedNode scope = node.getScopedNode();
        for (int i = 0; i < scope.getChildCount(); ++i) {
            IASNode child = scope.getChild(i);
            if (!(child instanceof ITypeNode)) continue;
            return (ITypeNode)child;
        }
        return null;
    }

    public static ITypeDefinition findType(Collection<IDefinition> definitions) {
        for (IDefinition definition : definitions) {
            if (!(definition instanceof ITypeDefinition)) continue;
            return (ITypeDefinition)definition;
        }
        return null;
    }

    public static NamespaceDefinition.INamepaceDeclarationDirective findNamespace(Collection<IDefinition> definitions) {
        for (IDefinition definition : definitions) {
            if (!(definition instanceof NamespaceDefinition.INamepaceDeclarationDirective)) continue;
            return (NamespaceDefinition.INamepaceDeclarationDirective)definition;
        }
        return null;
    }

    public static INamespaceNode findNamespaceNode(IPackageNode node) {
        IScopedNode scope = node.getScopedNode();
        for (int i = 0; i < scope.getChildCount(); ++i) {
            IASNode child = scope.getChild(i);
            if (!(child instanceof INamespaceNode)) continue;
            return (INamespaceNode)child;
        }
        return null;
    }

    public static IFunctionDefinition findFunction(Collection<IDefinition> definitions) {
        for (IDefinition definition : definitions) {
            if (!(definition instanceof IFunctionDefinition)) continue;
            return (IFunctionDefinition)definition;
        }
        return null;
    }

    public static IFunctionNode findFunctionNode(IPackageNode node) {
        IScopedNode scope = node.getScopedNode();
        for (int i = 0; i < scope.getChildCount(); ++i) {
            IASNode child = scope.getChild(i);
            if (!(child instanceof IFunctionNode)) continue;
            return (IFunctionNode)child;
        }
        return null;
    }

    public static IVariableNode findVariableNode(IPackageNode node) {
        IScopedNode scope = node.getScopedNode();
        for (int i = 0; i < scope.getChildCount(); ++i) {
            IASNode child = scope.getChild(i);
            if (!(child instanceof IVariableNode)) continue;
            return (IVariableNode)child;
        }
        return null;
    }

    public static IVariableDefinition findVariable(Collection<IDefinition> definitions) {
        for (IDefinition definition : definitions) {
            if (!(definition instanceof IVariableDefinition)) continue;
            return (IVariableDefinition)definition;
        }
        return null;
    }

    public static ITypeDefinition getTypeDefinition(IDefinitionNode node) {
        ITypeNode tnode = (ITypeNode)node.getAncestorOfType(ITypeNode.class);
        if (tnode != null) {
            return (ITypeDefinition)tnode.getDefinition();
        }
        return null;
    }

    public static boolean isSameClass(IDefinition pdef, IDefinition thisClass, ICompilerProject project) {
        if (pdef == thisClass) {
            return true;
        }
        IClassDefinition cdef = ((ClassDefinition)thisClass).resolveBaseClass(project);
        while (cdef != null) {
            if (cdef == pdef) {
                return true;
            }
            cdef = ((ClassDefinition)cdef).resolveBaseClass(project);
        }
        return false;
    }

    public static boolean hasSuperClass(ICompilerProject project, IDefinitionNode node) {
        IClassDefinition superClassDefinition = EmitterUtils.getSuperClassDefinition(node, project);
        if (superClassDefinition == null) {
            return false;
        }
        String qname = superClassDefinition.getQualifiedName();
        return superClassDefinition != null && !qname.equals("Object");
    }

    public static boolean hasSuperCall(IScopedNode node) {
        for (int i = node.getChildCount() - 1; i > -1; --i) {
            IASNode cnode = node.getChild(i);
            if (cnode.getNodeID() != ASTNodeID.FunctionCallID || cnode.getChild(0).getNodeID() != ASTNodeID.SuperID) continue;
            return true;
        }
        return false;
    }

    public static boolean hasBody(IFunctionNode node) {
        IScopedNode scope = node.getScopedNode();
        return scope.getChildCount() > 0;
    }

    public static IClassDefinition getSuperClassDefinition(IDefinitionNode node, ICompilerProject project) {
        IDefinition parent = node.getDefinition().getParent();
        if (parent instanceof IClassDefinition) {
            IClassDefinition parentClassDef = (IClassDefinition)parent;
            IClassDefinition superClass = parentClassDef.resolveBaseClass(project);
            return superClass;
        }
        return null;
    }

    public static List<String> resolveImports(ITypeDefinition type) {
        ArrayList<String> list = new ArrayList<String>();
        IScopedNode scopeNode = type.getContainedScope().getScopeNode();
        if (scopeNode != null) {
            scopeNode.getAllImports(list);
        } else {
            String[] implicitImports;
            ClassDefinition cdefinition = (ClassDefinition)type;
            for (String imp : implicitImports = cdefinition.getImplicitImports()) {
                list.add(imp);
            }
        }
        return list;
    }

    public static IClassDefinition getClassDefinition(IDefinitionNode node) {
        IClassNode tnode = (IClassNode)node.getAncestorOfType(IClassNode.class);
        return tnode != null ? tnode.getDefinition() : null;
    }

    public static IParameterNode getRest(IParameterNode[] nodes) {
        for (IParameterNode node : nodes) {
            if (!node.isRest()) continue;
            return node;
        }
        return null;
    }

    public static Map<Integer, IParameterNode> getDefaults(IParameterNode[] nodes) {
        HashMap<Integer, IParameterNode> result = new HashMap<Integer, IParameterNode>();
        int i = 0;
        boolean hasDefaults = false;
        for (IParameterNode node : nodes) {
            if (node.hasDefaultValue()) {
                hasDefaults = true;
                result.put(i, node);
            } else {
                result.put(i, null);
            }
            ++i;
        }
        if (!hasDefaults) {
            return null;
        }
        return result;
    }

    public static boolean writeThis(ICompilerProject project, JSSessionModel model, IIdentifierNode node) {
        boolean identifierIsMemberAccess;
        IClassNode classNode = (IClassNode)node.getAncestorOfType(IClassNode.class);
        IDefinition nodeDef = node.resolve(project);
        IASNode parentNode = node.getParent();
        ASTNodeID parentNodeId = parentNode.getNodeID();
        IASNode firstChild = parentNode.getChild(0);
        IClassDefinition thisClass = model.getCurrentClass();
        boolean bl = identifierIsMemberAccess = parentNodeId == ASTNodeID.MemberAccessExpressionID;
        if (nodeDef instanceof ParameterDefinition) {
            return false;
        }
        if (nodeDef instanceof InterfaceDefinition) {
            return false;
        }
        if (nodeDef instanceof ClassDefinition) {
            return false;
        }
        if (classNode == null) {
            if (parentNodeId == ASTNodeID.FunctionCallID && model.inE4xFilter) {
                return false;
            }
            if (nodeDef instanceof VariableDefinition) {
                IDefinition pdef = ((VariableDefinition)nodeDef).getParent();
                if (thisClass == null || !EmitterUtils.isSameClass(pdef, (IDefinition)thisClass, project)) {
                    return false;
                }
                if (identifierIsMemberAccess) {
                    return node == firstChild;
                }
                return parentNodeId == ASTNodeID.ContainerID || !(parentNode instanceof ParameterNode);
            }
            if (nodeDef instanceof AccessorDefinition) {
                IDefinition pdef = ((AccessorDefinition)nodeDef).getParent();
                if (thisClass == null || !EmitterUtils.isSameClass(pdef, (IDefinition)thisClass, project)) {
                    return false;
                }
                if (identifierIsMemberAccess) {
                    return node == firstChild;
                }
                return true;
            }
            if (parentNodeId == ASTNodeID.ContainerID && nodeDef instanceof FunctionDefinition) {
                return ((FunctionDefinition)nodeDef).getFunctionClassification() == IFunctionDefinition.FunctionClassification.CLASS_MEMBER;
            }
            boolean isFileOrPackageMember = false;
            if (nodeDef instanceof FunctionDefinition) {
                IFunctionDefinition.FunctionClassification classification = ((FunctionDefinition)nodeDef).getFunctionClassification();
                if (classification == IFunctionDefinition.FunctionClassification.FILE_MEMBER || classification == IFunctionDefinition.FunctionClassification.PACKAGE_MEMBER) {
                    isFileOrPackageMember = true;
                } else if (!identifierIsMemberAccess && classification == IFunctionDefinition.FunctionClassification.CLASS_MEMBER && EmitterUtils.isClassMember(project, nodeDef, thisClass)) {
                    return true;
                }
            }
            return parentNodeId == ASTNodeID.FunctionCallID && !(nodeDef instanceof AccessorDefinition) && !identifierIsMemberAccess && !isFileOrPackageMember;
        }
        if (parentNodeId == ASTNodeID.FunctionCallID && model.inE4xFilter) {
            return false;
        }
        if (nodeDef != null && EmitterUtils.isClassMember(project, nodeDef, classNode)) {
            if (identifierIsMemberAccess) {
                return node == firstChild;
            }
            boolean identifierIsLocalFunction = nodeDef instanceof FunctionDefinition && !(nodeDef instanceof AccessorDefinition) && ((FunctionDefinition)nodeDef).getFunctionClassification() == IFunctionDefinition.FunctionClassification.LOCAL;
            return !identifierIsLocalFunction;
        }
        return false;
    }

    public static boolean isClassMember(ICompilerProject project, IDefinition nodeDef, IClassNode classNode) {
        if (nodeDef.isInternal() && !(nodeDef.getParent() instanceof ClassDefinition)) {
            return false;
        }
        TypeScope cscope = (TypeScope)classNode.getDefinition().getContainedScope();
        Set nsSet = cscope.getNamespaceSet(project);
        HashSet defs = new HashSet();
        cscope.getAllPropertiesForMemberAccess((CompilerProject)project, defs, nsSet);
        Iterator visiblePropertiesIterator = defs.iterator();
        while (visiblePropertiesIterator.hasNext()) {
            if (!nodeDef.getQualifiedName().equals(((IDefinition)visiblePropertiesIterator.next()).getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isClassMember(ICompilerProject project, IDefinition nodeDef, IClassDefinition classDef) {
        if (nodeDef.isInternal() && !(nodeDef.getParent() instanceof ClassDefinition)) {
            return false;
        }
        TypeScope cscope = (TypeScope)classDef.getContainedScope();
        Set nsSet = cscope.getNamespaceSet(project);
        HashSet defs = new HashSet();
        cscope.getAllPropertiesForMemberAccess((CompilerProject)project, defs, nsSet);
        Iterator visiblePropertiesIterator = defs.iterator();
        while (visiblePropertiesIterator.hasNext()) {
            if (!nodeDef.getQualifiedName().equals(((IDefinition)visiblePropertiesIterator.next()).getQualifiedName())) continue;
            return true;
        }
        return false;
    }

    public static boolean isScalar(IExpressionNode node) {
        IIdentifierNode idnode;
        String idname;
        IASNode child;
        IIdentifierNode idnode2;
        String idname2;
        ASTNodeID id = node.getNodeID();
        if (id == ASTNodeID.LiteralBooleanID || id == ASTNodeID.LiteralIntegerID || id == ASTNodeID.LiteralIntegerZeroID || id == ASTNodeID.LiteralDoubleID || id == ASTNodeID.LiteralNullID || id == ASTNodeID.LiteralNumberID || id == ASTNodeID.LiteralRegexID || id == ASTNodeID.LiteralStringID || id == ASTNodeID.LiteralUintID) {
            return true;
        }
        if (id == ASTNodeID.IdentifierID && ((idname2 = (idnode2 = (IIdentifierNode)node).getName()).equals(NativeUtils.NativeASType.Infinity.name()) || idname2.equals(NativeUtils.NativeASType.undefined.name()) || idname2.equals(NativeUtils.NativeASType.NaN.name()))) {
            return true;
        }
        return id == ASTNodeID.Op_SubtractID && node.getChildCount() == 1 && (child = node.getChild(0)).getNodeID() == ASTNodeID.IdentifierID && (idname = (idnode = (IIdentifierNode)child).getName()).equals(NativeUtils.NativeASType.Infinity.name());
    }

    public static boolean needsStaticInitializer(String node, String className) {
        return node.contains(className);
    }

    public static IContainerNode insertArgumentsBefore(IContainerNode argumentsNode, IASNode ... nodes) {
        int i;
        int originalLength = argumentsNode.getChildCount();
        int extraLength = nodes.length;
        ContainerNode result = new ContainerNode(originalLength + extraLength);
        result.setSourcePath(argumentsNode.getSourcePath());
        result.span((ISourceLocation)argumentsNode);
        result.setParent((NodeBase)argumentsNode.getParent());
        for (i = 0; i < extraLength; ++i) {
            NodeBase node = (NodeBase)nodes[i];
            node.setSourcePath(argumentsNode.getSourcePath());
            result.addItem(node);
        }
        for (i = 0; i < originalLength; ++i) {
            result.addItem((NodeBase)argumentsNode.getChild(i));
        }
        return result;
    }

    public static IContainerNode insertArgumentsAfter(IContainerNode argumentsNode, IASNode ... nodes) {
        int i;
        int originalLength = argumentsNode.getChildCount();
        int extraLength = nodes.length;
        ContainerNode result = new ContainerNode(originalLength + extraLength);
        result.setSourcePath(argumentsNode.getSourcePath());
        result.span((ISourceLocation)argumentsNode);
        result.setParent((NodeBase)argumentsNode.getParent());
        for (i = 0; i < originalLength; ++i) {
            result.addItem((NodeBase)argumentsNode.getChild(i));
        }
        for (i = 0; i < extraLength; ++i) {
            NodeBase node = (NodeBase)nodes[i];
            node.setSourcePath(argumentsNode.getSourcePath());
            result.addItem(node);
        }
        return result;
    }

    public static IContainerNode insertArgumentsAt(IContainerNode argumentsNode, int index, IASNode ... nodes) {
        int originalLength = argumentsNode.getChildCount();
        int extraLength = nodes.length;
        ContainerNode result = new ContainerNode(originalLength + extraLength);
        result.setSourcePath(argumentsNode.getSourcePath());
        result.span((ISourceLocation)argumentsNode);
        result.setParent((NodeBase)argumentsNode.getParent());
        for (int i = 0; i < originalLength; ++i) {
            if (i < originalLength) {
                result.addItem((NodeBase)argumentsNode.getChild(i));
                continue;
            }
            int j = i;
            if (i >= index + extraLength) {
                result.addItem((NodeBase)argumentsNode.getChild(j -= extraLength));
                continue;
            }
            NodeBase node = (NodeBase)nodes[j -= originalLength];
            node.setSourcePath(argumentsNode.getSourcePath());
            result.addItem(node);
        }
        return result;
    }

    public static boolean isImplicit(IContainerNode node) {
        return node.getContainerType() == IContainerNode.ContainerType.IMPLICIT || node.getContainerType() == IContainerNode.ContainerType.SYNTHESIZED;
    }
}

