/*
 * Decompiled with CFR 0.152.
 */
package flex2.tools;

import flash.localization.LocalizationManager;
import flex2.compiler.Logger;
import flex2.compiler.config.ConfigurationException;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.ConsoleLogger;
import flex2.compiler.util.ThreadLocalToolkit;
import flex2.tools.MxmlJSC;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.flex.compiler.clients.problems.ProblemQueryProvider;
import org.apache.flex.compiler.problems.CompilerProblemSeverity;
import org.apache.flex.compiler.problems.ICompilerProblem;
import org.apache.flex.compiler.problems.annotations.DefaultSeverity;

public class Tool {
    protected static Class<? extends MxmlJSC> JS_COMPILER;

    protected static int compile(String[] args) throws NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        MxmlJSC mxmlJSC = JS_COMPILER.newInstance();
        int exitCode = mxmlJSC.execute(args);
        if (mxmlJSC.getProblemQuery().hasErrors()) {
            Tool.processProblemReport(mxmlJSC);
        }
        return exitCode;
    }

    public static Map<String, String> getLicenseMapFromFile(String fileName) throws ConfigurationException {
        HashMap<String, String> result = null;
        FileInputStream in = null;
        try {
            in = new FileInputStream(fileName);
            Properties properties = new Properties();
            properties.load(in);
            Enumeration<?> enumeration = properties.propertyNames();
            if (enumeration.hasMoreElements()) {
                result = new HashMap<String, String>();
                while (enumeration.hasMoreElements()) {
                    String propertyName = (String)enumeration.nextElement();
                    result.put(propertyName, properties.getProperty(propertyName));
                }
            }
        }
        catch (IOException ioException) {
            LocalizationManager l10n = ThreadLocalToolkit.getLocalizationManager();
            throw new ConfigurationException(l10n.getLocalizedTextString(new FailedToLoadLicenseFile(fileName)));
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
        return result;
    }

    public static void processProblemReport(ProblemQueryProvider requestableProblems) {
        block5: for (ICompilerProblem problem : requestableProblems.getProblemQuery().getProblems()) {
            Annotation[] annotations;
            Class<?> aClass = problem.getClass();
            for (Annotation annotation : annotations = aClass.getAnnotations()) {
                String level;
                if (!(annotation instanceof DefaultSeverity)) continue;
                DefaultSeverity myAnnotation = (DefaultSeverity)annotation;
                CompilerProblemSeverity cps = myAnnotation.value();
                if (cps.equals((Object)CompilerProblemSeverity.ERROR)) {
                    level = "error";
                } else {
                    if (!cps.equals((Object)CompilerProblemSeverity.WARNING)) continue block5;
                    level = "warning";
                }
                CompilerMessage msg = new CompilerMessage(level, problem.getSourcePath(), problem.getLine() + 1, problem.getColumn());
                try {
                    String errText = (String)aClass.getField("DESCRIPTION").get(aClass);
                    while (errText.contains("${")) {
                        int start = errText.indexOf("${");
                        int end = errText.indexOf("}", start);
                        String token = errText.substring(start + 2, end);
                        String value = (String)aClass.getField(token).get(problem);
                        token = "${" + token + "}";
                        errText = errText.replace(token, value);
                    }
                    msg.setMessage(errText);
                    Tool.logMessage(msg);
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static void logMessage(CompilerMessage msg) {
        Logger logger = ThreadLocalToolkit.getLogger() != null ? ThreadLocalToolkit.getLogger() : new ConsoleLogger();
        try {
            if (msg.getLevel().equals("info")) {
                logger.logInfo(msg.getPath(), msg.getLine(), msg.getColumn(), msg.getMessage());
            } else if (msg.getLevel().equals("warning")) {
                logger.logWarning(msg.getPath(), msg.getLine(), msg.getColumn(), msg.getMessage());
            } else if (msg.getLevel().equals("error")) {
                logger.logError(msg.getPath(), msg.getLine(), msg.getColumn(), msg.getMessage());
            }
        }
        catch (Exception e) {
            System.out.println(msg.getMessage());
        }
    }

    public static class NoUpdateMessage
    extends CompilerMessage.CompilerInfo {
        private static final long serialVersionUID = 6943388392279226490L;
        public String name;

        public NoUpdateMessage(String name) {
            this.name = name;
        }
    }

    public static class FailedToLoadLicenseFile
    extends CompilerMessage.CompilerError {
        private static final long serialVersionUID = -2980033917773108328L;
        public String fileName;

        public FailedToLoadLicenseFile(String fileName) {
            this.fileName = fileName;
        }
    }
}

