/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.client;

import flex.messaging.MessageClient;
import flex.messaging.client.FlexClientOutboundQueueProcessor;
import flex.messaging.config.ThrottleSettings;
import flex.messaging.log.Log;
import flex.messaging.messages.Message;
import flex.messaging.services.messaging.MessageFrequency;
import flex.messaging.services.messaging.ThrottleManager;
import flex.messaging.util.StringUtils;
import java.util.concurrent.ConcurrentHashMap;

public class OutboundQueueThrottleManager {
    protected final ConcurrentHashMap<String, DestinationFrequency> destinationFrequencies = new ConcurrentHashMap();
    protected final FlexClientOutboundQueueProcessor processor;

    public OutboundQueueThrottleManager(FlexClientOutboundQueueProcessor processor) {
        this.processor = processor;
    }

    public void registerDestination(String destinationId, int outboundMaxClientFrequency, ThrottleSettings.Policy outboundPolicy) {
        DestinationFrequency frequency = this.destinationFrequencies.get(destinationId);
        if (frequency == null) {
            frequency = new DestinationFrequency(outboundMaxClientFrequency, outboundPolicy);
            this.destinationFrequencies.putIfAbsent(destinationId, frequency);
        }
    }

    public void registerSubscription(String destinationId, MessageClient.SubscriptionInfo si) {
        DestinationFrequency frequency = this.destinationFrequencies.get(destinationId);
        frequency.logMaxFrequencyDuringRegistration(frequency.outboundMaxClientFrequency, si);
    }

    public void unregisterSubscription(String destinationId, MessageClient.SubscriptionInfo si) {
        this.unregisterDestination(destinationId);
    }

    public void unregisterAllSubscriptions(String destinationId) {
        this.unregisterDestination(destinationId);
    }

    public ThrottleManager.ThrottleResult throttleOutgoingClientLevel(Message message) {
        String destinationId = message.getDestination();
        if (this.isDestinationRegistered(destinationId)) {
            DestinationFrequency frequency = this.destinationFrequencies.get(message.getDestination());
            int maxFrequency = frequency.getMaxFrequency(message);
            MessageFrequency messageFrequency = frequency.getMessageFrequency(message);
            if (messageFrequency != null) {
                ThrottleManager.ThrottleResult result = messageFrequency.checkLimit(maxFrequency, frequency.outboundPolicy);
                return result;
            }
        }
        return new ThrottleManager.ThrottleResult();
    }

    public void updateMessageFrequencyOutgoingClientLevel(Message message) {
        DestinationFrequency frequency;
        MessageFrequency messageFrequency;
        String destinationId = message.getDestination();
        if (this.isDestinationRegistered(destinationId) && (messageFrequency = (frequency = this.destinationFrequencies.get(message.getDestination())).getMessageFrequency(message)) != null) {
            messageFrequency.updateMessageFrequency();
        }
    }

    protected boolean isDestinationRegistered(String destinationId) {
        return this.destinationFrequencies.containsKey(destinationId);
    }

    protected void unregisterDestination(String destinationId) {
        if (this.isDestinationRegistered(destinationId)) {
            this.destinationFrequencies.remove(destinationId);
        }
    }

    class DestinationFrequency {
        protected final int outboundMaxClientFrequency;
        protected final MessageFrequency outboundClientFrequency;
        protected final ThrottleSettings.Policy outboundPolicy;

        DestinationFrequency(int outboundMaxClientFrequency, ThrottleSettings.Policy outboundPolicy) {
            this.outboundMaxClientFrequency = outboundMaxClientFrequency;
            this.outboundPolicy = outboundPolicy;
            this.outboundClientFrequency = new MessageFrequency(outboundMaxClientFrequency);
        }

        int getMaxFrequency(Message message) {
            return this.outboundMaxClientFrequency;
        }

        MessageFrequency getMessageFrequency(Message message) {
            return this.outboundClientFrequency;
        }

        void logMaxFrequencyDuringRegistration(int maxFrequency, MessageClient.SubscriptionInfo si) {
            if (Log.isDebug()) {
                Log.getLogger((String)"Transport.Throttle").debug("Outbound queue throttle manager for FlexClient '" + OutboundQueueThrottleManager.this.processor.getFlexClient().getId() + "' is using '" + maxFrequency + "' as the throttling limit for its subscription: " + StringUtils.NEWLINE + si);
            }
        }
    }
}

