/*
 * Decompiled with CFR 0.152.
 */
package flex.messaging.client;

import flex.messaging.Destination;
import flex.messaging.MessageClient;
import flex.messaging.MessageDestination;
import flex.messaging.client.FlexClient;
import flex.messaging.client.FlushResult;
import flex.messaging.client.OutboundQueueThrottleManager;
import flex.messaging.config.ConfigMap;
import flex.messaging.messages.Message;
import flex.messaging.services.messaging.ThrottleManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FlexClientOutboundQueueProcessor {
    private FlexClient client;
    private MessageClient lastMessageClient;
    private String endpointId;
    protected OutboundQueueThrottleManager outboundQueueThrottleManager;

    public void setEndpointId(String value) {
        this.endpointId = value;
    }

    public String getEndpointId() {
        return this.endpointId;
    }

    public void setFlexClient(FlexClient value) {
        this.client = value;
    }

    public FlexClient getFlexClient() {
        return this.client;
    }

    public OutboundQueueThrottleManager getOutboundQueueThrottleManager() {
        return this.outboundQueueThrottleManager;
    }

    public OutboundQueueThrottleManager getOrCreateOutboundQueueThrottleManager() {
        if (this.outboundQueueThrottleManager == null) {
            this.outboundQueueThrottleManager = new OutboundQueueThrottleManager(this);
        }
        return this.outboundQueueThrottleManager;
    }

    public void initialize(ConfigMap properties) {
    }

    public void add(List<Message> outboundQueue, Message message) {
        outboundQueue.add(message);
    }

    public FlushResult flush(List<Message> outboundQueue) {
        return this.flush(null, outboundQueue);
    }

    public FlushResult flush(MessageClient messageClient, List<Message> outboundQueue) {
        FlushResult flushResult = new FlushResult();
        ArrayList<Message> messagesToFlush = null;
        Iterator<Message> iter = outboundQueue.iterator();
        while (iter.hasNext()) {
            Message message = iter.next();
            if (messageClient != null && !message.getClientId().equals(messageClient.getClientId())) continue;
            if (this.isMessageExpired(message)) {
                iter.remove();
                continue;
            }
            MessageClient messageClientForCurrentMessage = messageClient == null ? this.getMessageClient(message) : messageClient;
            ThrottleManager.ThrottleResult throttleResult = this.throttleOutgoingDestinationLevel(messageClientForCurrentMessage, message, false);
            ThrottleManager.ThrottleResult.Result result = throttleResult.getResult();
            if (ThrottleManager.ThrottleResult.Result.OK == result && ThrottleManager.ThrottleResult.Result.OK == (result = (throttleResult = this.throttleOutgoingClientLevel(messageClientForCurrentMessage, message, false)).getResult())) {
                this.updateMessageFrequencyOutgoing(messageClientForCurrentMessage, message);
                if (messagesToFlush == null) {
                    messagesToFlush = new ArrayList<Message>();
                }
                messagesToFlush.add(message);
            }
            iter.remove();
        }
        flushResult.setMessages(messagesToFlush);
        return flushResult;
    }

    public boolean isMessageExpired(Message message) {
        return message.getTimeToLive() > 0L && System.currentTimeMillis() - message.getTimestamp() >= message.getTimeToLive();
    }

    protected ThrottleManager.ThrottleResult throttleOutgoingDestinationLevel(MessageClient msgClient, Message message, boolean buffered) {
        ThrottleManager throttleManager = this.getThrottleManager(msgClient);
        if (throttleManager != null) {
            if (buffered) {
                return throttleManager.throttleDestinationLevel(message, false);
            }
            return throttleManager.throttleOutgoingMessage(message);
        }
        return new ThrottleManager.ThrottleResult();
    }

    protected ThrottleManager.ThrottleResult throttleOutgoingClientLevel(MessageClient msgClient, Message message, boolean buffered) {
        if (this.outboundQueueThrottleManager != null) {
            ThrottleManager throttleManager;
            ThrottleManager.ThrottleResult throttleResult = this.outboundQueueThrottleManager.throttleOutgoingClientLevel(message);
            if (!buffered && (throttleManager = this.getThrottleManager(msgClient)) != null) {
                throttleManager.handleOutgoingThrottleResult(message, throttleResult, true);
            }
            return throttleResult;
        }
        return new ThrottleManager.ThrottleResult();
    }

    protected MessageClient getMessageClient(Message message) {
        if (this.lastMessageClient != null && message.getClientId().equals(this.lastMessageClient.getClientId())) {
            return this.lastMessageClient;
        }
        this.lastMessageClient = this.client.getMessageClient((String)message.getClientId());
        return this.lastMessageClient;
    }

    protected ThrottleManager getThrottleManager(MessageClient msgClient) {
        Destination destination = msgClient != null ? msgClient.getDestination() : null;
        return destination != null && destination instanceof MessageDestination ? ((MessageDestination)destination).getThrottleManager() : null;
    }

    protected void updateMessageFrequencyOutgoing(MessageClient msgClient, Message message) {
        ThrottleManager throttleManager = this.getThrottleManager(msgClient);
        if (throttleManager != null) {
            throttleManager.updateMessageFrequencyDestinationLevel(false);
        }
        if (this.outboundQueueThrottleManager != null) {
            this.outboundQueueThrottleManager.updateMessageFrequencyOutgoingClientLevel(message);
        }
    }
}

