/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.builder;

import flex2.compiler.CompilationUnit;
import flex2.compiler.mxml.MxmlConfiguration;
import flex2.compiler.mxml.builder.AbstractBuilder;
import flex2.compiler.mxml.builder.AnonymousObjectGraphBuilder;
import flex2.compiler.mxml.builder.ModelBuilder;
import flex2.compiler.mxml.dom.ArgumentsNode;
import flex2.compiler.mxml.dom.CDATANode;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.dom.RequestNode;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.AnonymousObjectGraph;
import flex2.compiler.mxml.rep.BindingExpression;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.util.CompilerMessage;

public class ServiceRequestBuilder
extends AnonymousObjectGraphBuilder {
    private String requestName;

    public ServiceRequestBuilder(CompilationUnit unit, TypeTable typeTable, MxmlConfiguration mxmlConfiguration, MxmlDocument document, String name) {
        super(unit, typeTable, mxmlConfiguration, document);
        this.setAllowTwoWayBind(false);
        this.requestName = name;
    }

    public void analyze(ArgumentsNode node) {
        this.processRequest(node);
    }

    public void analyze(RequestNode node) {
        this.processRequest(node);
    }

    public void processRequest(Node node) {
        this.graph = new AnonymousObjectGraph(this.document, this.typeTable.objectType, node.beginLine);
        if (node.getChildCount() == 1 && node.getChildAt(0) instanceof CDATANode) {
            CDATANode cdata = (CDATANode)node.getChildAt(0);
            if (cdata.image.length() > 0) {
                BindingExpression be = this.textParser.parseBindingExpression(cdata.image, cdata.beginLine);
                if (be != null) {
                    if (be.isTwoWayPrimary()) {
                        this.log(cdata, (CompilerMessage)new AbstractBuilder.TwoWayBindingNotAllowed());
                    } else {
                        be.setDestination(this.graph);
                    }
                } else {
                    this.log(cdata, (CompilerMessage)new ModelBuilder.OnlyScalarError(this.requestName));
                }
            }
        } else {
            this.processChildren(node, this.graph);
        }
    }
}

