/*
 * Decompiled with CFR 0.152.
 */
package flash.localization;

import flash.localization.ILocalizedText;
import flash.localization.ILocalizer;
import flash.localization.LocalizationManager;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XLRLocalizer
implements ILocalizer {
    private Map<String, XLRFile> filedict = new HashMap<String, XLRFile>();
    private Map<String, XLRNode> nodedict = new HashMap<String, XLRNode>();

    public XLRLocalizer() {
    }

    public XLRLocalizer(String path) {
        this.findFiles(new File(path), null);
    }

    public XLRTargetNode loadNode(Locale fileLocale, String fileId, Locale locale, String id) {
        String key = this.getKey(fileLocale, fileId);
        XLRFile f = this.filedict.get(key);
        if (f == null) {
            String resource = key.replaceAll("\\.", "/") + ".xlr";
            URL url = this.getClass().getClassLoader().getResource(resource);
            if (url != null) {
                f = new XLRFile(fileId, url);
                this.filedict.put(key, f);
            }
        }
        if (f != null) {
            f.load();
            XLRMessageNode messageNode = (XLRMessageNode)this.nodedict.get(id);
            if (messageNode != null) {
                XLRTargetNode targetNode = messageNode.getTarget(locale.toString());
                return targetNode;
            }
        }
        return null;
    }

    public XLRTargetNode checkPrefix(Locale fileLocale, String fileId, Locale locale, String id) {
        XLRTargetNode t = this.loadNode(fileLocale, fileId, locale, id);
        if (t == null) {
            int sep = fileId.lastIndexOf(36);
            if (sep == -1) {
                sep = fileId.lastIndexOf(46);
            }
            if (sep != -1) {
                t = this.checkPrefix(fileLocale, fileId.substring(0, sep), locale, id);
            }
        }
        return t;
    }

    public XLRTargetNode checkLocales(Locale locale, String id) {
        XLRTargetNode t = this.checkPrefix(locale, id, locale, id);
        if (t == null && locale.getCountry().length() > 0 && locale.getVariant().length() > 0) {
            t = this.checkPrefix(new Locale(locale.getLanguage(), locale.getCountry()), id, locale, id);
        }
        if (t == null && locale.getCountry().length() > 0) {
            t = this.checkPrefix(new Locale(locale.getLanguage()), id, locale, id);
        }
        if (t == null) {
            t = this.checkPrefix(null, id, locale, id);
        }
        return t;
    }

    public ILocalizedText getLocalizedText(Locale locale, String id) {
        XLRMessageNode messageNode = (XLRMessageNode)this.nodedict.get(id);
        XLRTargetNode targetNode = null;
        if (messageNode != null) {
            targetNode = messageNode.getTarget(locale.toString());
        }
        if (targetNode == null) {
            targetNode = this.checkLocales(locale, id);
        }
        if (targetNode == null) {
            return null;
        }
        return new XLRLocalizedText(targetNode);
    }

    private String getKey(Locale locale, String id) {
        String key = id;
        if (locale != null && locale.getLanguage().length() > 0) {
            key = key + "_" + locale.getLanguage();
            if (locale.getCountry().length() > 0) {
                key = key + "_" + locale.getCountry();
                if (locale.getVariant().length() > 0) {
                    key = key + "_" + locale.getVariant();
                }
            }
        }
        return key;
    }

    private void findFiles(File f, String relative) {
        try {
            if (!f.exists()) {
                return;
            }
            if (f.isDirectory()) {
                File[] files = f.listFiles();
                for (int i = 0; i < files.length; ++i) {
                    this.findFiles(files[i].getAbsoluteFile(), (relative == null ? "" : relative + ".") + files[i].getName());
                }
            } else {
                String id;
                if (!f.getName().endsWith(".xlr")) {
                    return;
                }
                String prefix = id = relative.substring(0, relative.length() - ".xlr".length());
                int dot = id.lastIndexOf(46);
                int underscore = -1;
                underscore = dot != -1 ? id.indexOf(95, dot) : id.indexOf(95);
                if (underscore != -1) {
                    prefix = id.substring(0, underscore);
                }
                this.filedict.put(id, new XLRFile(prefix, f.toURL()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class CDATAHandler
    implements LexicalHandler {
        private XLRHandler parentHandler;

        public CDATAHandler(XLRHandler h) {
            this.parentHandler = h;
        }

        public void startCDATA() throws SAXException {
            this.parentHandler.inCDATA = true;
        }

        public void endCDATA() throws SAXException {
            this.parentHandler.inCDATA = false;
        }

        public void startDTD(String s, String s1, String s2) throws SAXException {
        }

        public void endDTD() throws SAXException {
        }

        public void startEntity(String s) throws SAXException {
        }

        public void endEntity(String s) throws SAXException {
        }

        public void comment(char[] chars, int i, int i1) throws SAXException {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class XLRHandler
    extends DefaultHandler {
        public Stack<XLRNode> context = new Stack();
        private String fileLocale = null;
        private String base = null;
        private Map<String, XLRNode> nodedict;
        StringBuilder textBuffer = new StringBuilder(128);
        protected boolean inCDATA = false;

        public XLRHandler(Map<String, XLRNode> nodedict, String base) {
            this.nodedict = nodedict;
            this.base = base;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String locale;
            XLRNode current = null;
            if (this.context.size() > 0) {
                current = this.context.peek();
            }
            if ((locale = attributes.getValue("locale")) == null) {
                locale = this.fileLocale;
            }
            String text = attributes.getValue("text");
            XLRNode node = null;
            if ("messages".equals(qName)) {
                this.fileLocale = attributes.getValue("locale");
                if (attributes.getValue("idbase") != null) {
                    this.base = attributes.getValue("idbase");
                }
            } else if ("message".equals(qName)) {
                String id = attributes.getValue("id");
                if (this.base != null) {
                    id = this.base + "." + id;
                }
                if ((node = this.nodedict.get(id)) == null) {
                    node = new XLRMessageNode(id);
                    this.nodedict.put(id, node);
                }
                if (text != null && locale != null) {
                    XLRTargetNode targetNode = new XLRTargetNode(locale);
                    node.children.add(targetNode);
                    XLRTextNode textNode = new XLRTextNode(text);
                    targetNode.children.add(textNode);
                }
                this.context.push(node);
            } else if ("target".equals(qName)) {
                node = new XLRTargetNode(locale);
                if (text != null) {
                    node.children.add(new XLRTextNode(text));
                }
                current.children.add(node);
                this.context.push(node);
            } else if ("text".equals(qName)) {
                String value = attributes.getValue("value");
                node = new XLRTextNode(value);
                current.children.add(node);
                this.context.push(node);
            } else if ("variable".equals(qName)) {
                String name = attributes.getValue("name");
                node = new XLRVariableNode(name);
                current.children.add(node);
                this.context.push(node);
            } else if ("match".equals(qName)) {
                node = new XLRMatchNode(attributes.getValue("variable"), attributes.getValue("pattern"));
                if (text != null) {
                    node.children.add(new XLRTextNode(text));
                }
                current.children.add(node);
                this.context.push(node);
            } else if ("select".equals(qName)) {
                node = new XLRChoiceNode();
                current.children.add(node);
                this.context.push(node);
            } else {
                throw new SAXParseException("blorp", null);
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            XLRNode current = null;
            if (this.context.size() > 0) {
                current = this.context.pop();
            }
            if (!"messages".equals(qName)) {
                if ("text".equals(qName)) {
                    if (this.textBuffer.length() > 0) {
                        current.children.add(new XLRTextNode(this.textBuffer.toString()));
                    }
                } else if ("variable".equals(qName) && this.textBuffer.length() > 0) {
                    ((XLRVariableNode)current).varname = this.textBuffer.toString();
                }
            }
            this.textBuffer.setLength(0);
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            if (this.inCDATA) {
                this.textBuffer.append(ch, start, length);
            } else {
                String s = new String(ch, start, length).trim();
                if (s.length() > 0) {
                    this.textBuffer.append(s);
                }
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
        }

        @Override
        public void fatalError(SAXParseException e) throws SAXException {
            throw e;
        }
    }

    private class XLRMatchNode
    extends XLRNode {
        public String varname;
        public String text;
        public String pattern;

        public XLRMatchNode(String varname, String pattern) {
            this.text = null;
            this.pattern = null;
            this.varname = varname;
            this.pattern = pattern;
        }

        public boolean execute(StringBuilder buffer, String locale, Map parameters) {
            String value = null;
            if (this.varname != null && parameters.containsKey(this.varname) && parameters.get(this.varname) != null) {
                value = parameters.get(this.varname).toString();
            }
            if (value == null) {
                value = "";
            }
            boolean matched = false;
            matched = this.pattern == null ? (value != null && value.length() > 0 ? !value.equalsIgnoreCase("false") && !value.equals("0") : false) : value.matches(this.pattern);
            if (matched) {
                super.execute(buffer, locale, parameters);
                return true;
            }
            return false;
        }
    }

    private class XLRVariableNode
    extends XLRNode {
        public String varname;

        public XLRVariableNode(String name) {
            this.varname = name;
        }

        public boolean execute(StringBuilder buffer, String locale, Map parameters) {
            boolean success = false;
            if (this.varname != null) {
                boolean bl = success = parameters.containsKey(this.varname) && parameters.get(this.varname) != null;
                if (success) {
                    buffer.append(parameters.get(this.varname).toString());
                }
            }
            return success |= super.execute(buffer, locale, parameters);
        }
    }

    private class XLRTextNode
    extends XLRNode {
        public final String text;

        public XLRTextNode(String text) {
            this.text = text;
        }

        public boolean execute(StringBuilder buffer, String locale, Map parameters) {
            boolean success = false;
            if (this.text != null) {
                success = true;
                buffer.append(this.text);
            }
            boolean result = super.execute(buffer, locale, parameters);
            return success || result;
        }
    }

    private class XLRTargetNode
    extends XLRNode {
        public final String locale;

        public XLRTargetNode(String locale) {
            this.locale = locale;
        }

        public boolean matchesLocale(String locale) {
            return this.locale == null && locale == null || locale.equalsIgnoreCase(this.locale);
        }

        public boolean execute(StringBuilder buffer, String locale, Map parameters) {
            if (this.matchesLocale(locale)) {
                return super.execute(buffer, locale, parameters);
            }
            return false;
        }
    }

    private class XLRMessageNode
    extends XLRChoiceNode {
        public final String id;

        public XLRMessageNode(String id) {
            this.id = id;
        }

        public XLRTargetNode getTarget(String locale) {
            for (XLRNode node : this.children) {
                if (!(node instanceof XLRTargetNode) || !((XLRTargetNode)node).matchesLocale(locale)) continue;
                return (XLRTargetNode)node;
            }
            return null;
        }
    }

    private class XLRChoiceNode
    extends XLRNode {
        private XLRChoiceNode() {
        }

        public boolean execute(StringBuilder buffer, String locale, Map parameters) {
            for (XLRNode child : this.children) {
                if (!child.execute(buffer, locale, parameters)) continue;
                return true;
            }
            return false;
        }
    }

    private abstract class XLRNode {
        public LinkedList<XLRNode> children = new LinkedList();

        private XLRNode() {
        }

        public boolean execute(StringBuilder buffer, String locale, Map parameters) {
            boolean success = false;
            for (XLRNode child : this.children) {
                if (!child.execute(buffer, locale, parameters)) continue;
                success = true;
            }
            return success;
        }
    }

    private class XLRLocalizedText
    implements ILocalizedText {
        private XLRTargetNode node;

        public XLRLocalizedText(XLRTargetNode node) {
            this.node = node;
        }

        public String format(Map parameters) {
            String s;
            StringBuilder buffer = new StringBuilder();
            String string = s = this.node.execute(buffer, this.node.locale, parameters) ? buffer.toString() : null;
            if (s != null) {
                s = LocalizationManager.replaceInlineReferences(s, parameters);
            }
            return s;
        }
    }

    private class XLRFile {
        private boolean loaded = false;
        private final URL url;
        private final String prefix;

        public XLRFile(String prefix, URL url) {
            this.prefix = prefix;
            this.url = url;
        }

        public void load() {
            if (this.loaded) {
                return;
            }
            try {
                BufferedInputStream in = new BufferedInputStream(this.url.openStream());
                SAXParserFactory factory = SAXParserFactory.newInstance();
                factory.setNamespaceAware(false);
                XLRHandler xmlHandler = new XLRHandler(XLRLocalizer.this.nodedict, this.prefix);
                CDATAHandler cdataHandler = new CDATAHandler(xmlHandler);
                SAXParser parser = factory.newSAXParser();
                parser.setProperty("http://xml.org/sax/properties/lexical-handler", cdataHandler);
                parser.parse((InputStream)in, (DefaultHandler)xmlHandler);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.loaded = true;
        }
    }
}

