/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.compat;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.felix.scr.ScrInfo;
import org.apache.felix.scr.ScrService;
import org.apache.felix.scr.impl.compat.ScrCommand;
import org.apache.felix.scr.impl.compat.ScrServiceImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.runtime.ServiceComponentRuntime;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class Activator
implements BundleActivator {
    private volatile ServiceTracker<ServiceComponentRuntime, ServiceComponentRuntime> runtimeTracker;
    private volatile ServiceTracker<org.apache.felix.scr.info.ScrInfo, org.apache.felix.scr.info.ScrInfo> infoTracker;
    private final Map<Long, ServiceRegistration<ScrService>> scrServiceRegMap = new ConcurrentHashMap<Long, ServiceRegistration<ScrService>>();
    private final Map<Long, ServiceRegistration<ScrInfo>> scrCommandRegMap = new ConcurrentHashMap<Long, ServiceRegistration<ScrInfo>>();

    public void start(final BundleContext context) throws Exception {
        this.runtimeTracker = new ServiceTracker(context, ServiceComponentRuntime.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<ServiceComponentRuntime, ServiceComponentRuntime>(){

            public ServiceComponentRuntime addingService(ServiceReference<ServiceComponentRuntime> reference) {
                ServiceComponentRuntime runtime = (ServiceComponentRuntime)context.getService(reference);
                if (runtime != null) {
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put("service.description", "Apache Felix Compat ScrService");
                    ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
                    ScrServiceImpl service = new ScrServiceImpl(context, runtime);
                    Activator.this.scrServiceRegMap.put((Long)reference.getProperty("service.id"), context.registerService(ScrService.class, (Object)service, props));
                }
                return runtime;
            }

            public void modifiedService(ServiceReference<ServiceComponentRuntime> reference, ServiceComponentRuntime service) {
            }

            public void removedService(ServiceReference<ServiceComponentRuntime> reference, ServiceComponentRuntime service) {
                ServiceRegistration reg = (ServiceRegistration)Activator.this.scrServiceRegMap.remove(reference.getProperty("service.id"));
                if (reg != null) {
                    reg.unregister();
                }
                context.ungetService(reference);
            }
        });
        this.runtimeTracker.open();
        this.infoTracker = new ServiceTracker(context, org.apache.felix.scr.info.ScrInfo.class, (ServiceTrackerCustomizer)new ServiceTrackerCustomizer<org.apache.felix.scr.info.ScrInfo, org.apache.felix.scr.info.ScrInfo>(){

            public org.apache.felix.scr.info.ScrInfo addingService(ServiceReference<org.apache.felix.scr.info.ScrInfo> reference) {
                org.apache.felix.scr.info.ScrInfo runtime = (org.apache.felix.scr.info.ScrInfo)context.getService(reference);
                if (runtime != null) {
                    Hashtable<String, String> props = new Hashtable<String, String>();
                    ((Dictionary)props).put("service.description", "Apache Felix Compat SCR Info service");
                    ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
                    ScrCommand info = new ScrCommand(runtime);
                    Activator.this.scrCommandRegMap.put((Long)reference.getProperty("service.id"), context.registerService(ScrInfo.class, (Object)info, props));
                }
                return runtime;
            }

            public void modifiedService(ServiceReference<org.apache.felix.scr.info.ScrInfo> reference, org.apache.felix.scr.info.ScrInfo service) {
            }

            public void removedService(ServiceReference<org.apache.felix.scr.info.ScrInfo> reference, org.apache.felix.scr.info.ScrInfo service) {
                ServiceRegistration reg = (ServiceRegistration)Activator.this.scrCommandRegMap.remove(reference.getProperty("service.id"));
                if (reg != null) {
                    reg.unregister();
                }
                context.ungetService(reference);
            }
        });
        this.infoTracker.open();
    }

    public void stop(BundleContext context) throws Exception {
        if (this.infoTracker != null) {
            this.infoTracker.close();
            this.infoTracker = null;
        }
        if (this.runtimeTracker != null) {
            this.runtimeTracker.close();
            this.runtimeTracker = null;
        }
    }
}

