/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.sslfilter.internal;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.felix.http.sslfilter.internal.SslFilter;

class SslFilterResponse
extends HttpServletResponseWrapper {
    private final URL requestURL;
    private final String serverName;
    private final String serverProto;
    private final int serverPort;
    private final String clientProto;
    private final int clientPort;
    private final boolean rewriteAbsoluteUrls;

    public SslFilterResponse(HttpServletResponse response, HttpServletRequest request, SslFilter.Config config) throws MalformedURLException {
        super(response);
        int port;
        this.requestURL = new URL(request.getRequestURL().toString());
        this.serverName = request.getServerName();
        this.serverPort = request.getServerPort();
        String value = request.getHeader(config.ssl_forward_header());
        if ("X-Forwarded-Proto".equalsIgnoreCase(config.ssl_forward_header()) && "http".equalsIgnoreCase(value) || "X-Forwarded-SSL".equalsIgnoreCase(config.ssl_forward_header()) && !config.ssl_forward_value().equalsIgnoreCase(value)) {
            this.clientProto = "http";
            this.serverProto = "https";
        } else {
            this.clientProto = "https";
            this.serverProto = "http";
        }
        try {
            String fwdPort = request.getHeader("X-Forwarded-Port");
            port = Integer.valueOf(fwdPort);
        }
        catch (Exception e) {
            port = -1;
        }
        if (port > 0 && ("https".equals(this.clientProto) && port == 443 || "http".equals(this.clientProto) && port == 80)) {
            port = -1;
        }
        this.clientPort = port;
        this.rewriteAbsoluteUrls = config.rewrite_absolute_urls();
    }

    public void setHeader(String name, String value) {
        if ("Location".equalsIgnoreCase(name)) {
            String rewritten = null;
            try {
                rewritten = this.rewriteUrlIfNeeded(value);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (rewritten != null) {
                value = rewritten;
            }
        }
        super.setHeader(name, value);
    }

    public void sendRedirect(String location) throws IOException {
        String rewritten = null;
        try {
            rewritten = this.rewriteUrlIfNeeded(location);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        if (rewritten != null) {
            location = rewritten;
        }
        super.sendRedirect(location);
    }

    private int normalizePort(String protocol, int port) {
        if (port > 0) {
            return port;
        }
        if ("https".equalsIgnoreCase(protocol)) {
            return 443;
        }
        return 80;
    }

    private String rewriteUrlIfNeeded(String value) throws URISyntaxException {
        if (value == null || !this.rewriteAbsoluteUrls && value.contains("://")) {
            return null;
        }
        try {
            URI uri;
            if (value.startsWith(this.serverProto.concat("://"))) {
                uri = new URI(value);
            } else {
                URL url = new URL(this.requestURL, value);
                uri = url.toURI();
            }
            String actualProto = uri.getScheme();
            if (!this.serverName.equals(uri.getHost())) {
                return null;
            }
            if (this.normalizePort(this.serverProto, this.serverPort) != this.normalizePort(actualProto, uri.getPort())) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(this.clientProto);
            sb.append("://");
            sb.append(this.serverName);
            if (this.clientPort != -1) {
                sb.append(':');
                sb.append(this.clientPort);
            }
            if (uri.getRawPath() != null) {
                sb.append(uri.getRawPath());
            }
            if (uri.getRawQuery() != null) {
                sb.append('?');
                sb.append(uri.getRawQuery());
            }
            if (uri.getRawFragment() != null) {
                sb.append('#');
                sb.append(uri.getRawFragment());
            }
            return sb.toString();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

