/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.handler;

import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.felix.http.base.internal.context.ExtServletContext;
import org.apache.felix.http.base.internal.dispatch.RequestDispatcherProvider;
import org.apache.felix.http.base.internal.handler.HttpSessionWrapper;
import org.apache.felix.http.base.internal.handler.ServletContextWrapper;
import org.apache.felix.http.base.internal.util.UriUtils;
import org.osgi.service.useradmin.Authorization;

class ServletHandlerRequest
extends HttpServletRequestWrapper {
    private final String alias;
    private final ServletContextWrapper context;
    private String contextPath;
    private String pathInfo;
    private boolean pathInfoCalculated = false;

    public ServletHandlerRequest(HttpServletRequest req, ExtServletContext context, String alias) {
        super(req);
        this.context = new ServletContextWrapper(context, (RequestDispatcherProvider)req.getAttribute("org.apache.felix.http.requestDispatcherProvider"));
        this.alias = alias;
    }

    public String getAuthType() {
        String authType = (String)this.getAttribute("org.osgi.service.http.authentication.type");
        if (authType != null) {
            return authType;
        }
        return super.getAuthType();
    }

    public String getContextPath() {
        if (this.contextPath == null) {
            String context = super.getContextPath();
            String servlet = super.getServletPath();
            this.contextPath = context == null || context.length() == 0 ? servlet : (servlet == null || servlet.length() == 0 ? context : context + servlet);
        }
        return this.contextPath;
    }

    public String getPathInfo() {
        if (!this.pathInfoCalculated) {
            this.pathInfo = this.calculatePathInfo();
            this.pathInfoCalculated = true;
        }
        return this.pathInfo;
    }

    public String getPathTranslated() {
        String info = this.getPathInfo();
        return null == info ? null : this.getRealPath(info);
    }

    public String getRemoteUser() {
        String remoteUser = (String)this.getAttribute("org.osgi.service.http.authentication.remote.user");
        if (remoteUser != null) {
            return remoteUser;
        }
        return super.getRemoteUser();
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        boolean relPath;
        if (path == null) {
            return null;
        }
        boolean bl = relPath = !path.startsWith("/") && !"".equals(path);
        if (relPath) {
            path = UriUtils.concat(this.alias, path);
        }
        return super.getRequestDispatcher(path);
    }

    public ServletContext getServletContext() {
        return this.context;
    }

    public String getServletPath() {
        if ("/".equals(this.alias)) {
            return "";
        }
        return this.alias;
    }

    public HttpSession getSession(boolean create) {
        HttpSession session = super.getSession(create);
        if (session == null) {
            return null;
        }
        return new HttpSessionWrapper(session, this.context);
    }

    public boolean isUserInRole(String role) {
        Authorization authorization = (Authorization)this.getAttribute("org.osgi.service.useradmin.authorization");
        if (authorization != null) {
            return authorization.hasRole(role);
        }
        return super.isUserInRole(role);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "->" + super.getRequest();
    }

    private String calculatePathInfo() {
        String pathInfo = super.getPathInfo();
        if (pathInfo != null) {
            if (!"/".equals(this.alias) && pathInfo.startsWith(this.alias)) {
                pathInfo = pathInfo.substring(this.alias.length());
            }
            if (pathInfo.length() == 0) {
                pathInfo = null;
            }
        }
        return pathInfo;
    }
}

