/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.karaf.deployer.features;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.felix.karaf.deployer.features.FeatureTransformer;
import org.osgi.service.url.AbstractURLStreamHandlerService;

public class FeatureURLHandler
extends AbstractURLStreamHandlerService {
    private static Log logger = LogFactory.getLog(FeatureURLHandler.class);
    private static String SYNTAX = "feature: xml-uri";
    private URL featureXmlURL;

    public URLConnection openConnection(URL url) throws IOException {
        if (url.getPath() == null || url.getPath().trim().length() == 0) {
            throw new MalformedURLException("Path can not be null or empty. Syntax: " + SYNTAX);
        }
        this.featureXmlURL = new URL(url.getPath());
        logger.debug((Object)("Blueprint xml URL is: [" + this.featureXmlURL + "]"));
        return new Connection(url);
    }

    public URL getFeatureXmlURL() {
        return this.featureXmlURL;
    }

    public class Connection
    extends URLConnection {
        public Connection(URL url) {
            super(url);
        }

        public void connect() throws IOException {
        }

        public InputStream getInputStream() throws IOException {
            try {
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                FeatureTransformer.transform(FeatureURLHandler.this.featureXmlURL, os);
                os.close();
                return new ByteArrayInputStream(os.toByteArray());
            }
            catch (Exception e) {
                logger.error((Object)"Error opening blueprint xml url", (Throwable)e);
                throw (IOException)new IOException("Error opening blueprint xml url").initCause(e);
            }
        }
    }
}

