/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.drill.exec.expr.holders;

/**
 * Wrapper object for an individual value in Drill.
 *
 * ValueHolders are designed to be mutable wrapper objects for defining clean
 * APIs that access data in Drill. For performance, object creation is avoided
 * at all costs throughout execution. For this reason, ValueHolders are
 * disallowed from implementing any methods, this allows for them to be
 * replaced by their java primitive inner members during optimization of
 * run-time generated code.
 */
public interface ValueHolder {
}
