/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.sagemaker.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.sagemaker.model.transform.CollectionConfigurationMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class CollectionConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String collectionName;
    private Map<String, String> collectionParameters;

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public CollectionConfiguration withCollectionName(String collectionName) {
        this.setCollectionName(collectionName);
        return this;
    }

    public Map<String, String> getCollectionParameters() {
        return this.collectionParameters;
    }

    public void setCollectionParameters(Map<String, String> collectionParameters) {
        this.collectionParameters = collectionParameters;
    }

    public CollectionConfiguration withCollectionParameters(Map<String, String> collectionParameters) {
        this.setCollectionParameters(collectionParameters);
        return this;
    }

    public CollectionConfiguration addCollectionParametersEntry(String key, String value) {
        if (null == this.collectionParameters) {
            this.collectionParameters = new HashMap<String, String>();
        }
        if (this.collectionParameters.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.collectionParameters.put(key, value);
        return this;
    }

    public CollectionConfiguration clearCollectionParametersEntries() {
        this.collectionParameters = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCollectionName() != null) {
            sb.append("CollectionName: ").append(this.getCollectionName()).append(",");
        }
        if (this.getCollectionParameters() != null) {
            sb.append("CollectionParameters: ").append(this.getCollectionParameters());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CollectionConfiguration)) {
            return false;
        }
        CollectionConfiguration other = (CollectionConfiguration)obj;
        if (other.getCollectionName() == null ^ this.getCollectionName() == null) {
            return false;
        }
        if (other.getCollectionName() != null && !other.getCollectionName().equals(this.getCollectionName())) {
            return false;
        }
        if (other.getCollectionParameters() == null ^ this.getCollectionParameters() == null) {
            return false;
        }
        return other.getCollectionParameters() == null || other.getCollectionParameters().equals(this.getCollectionParameters());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCollectionName() == null ? 0 : this.getCollectionName().hashCode());
        hashCode = 31 * hashCode + (this.getCollectionParameters() == null ? 0 : this.getCollectionParameters().hashCode());
        return hashCode;
    }

    public CollectionConfiguration clone() {
        try {
            return (CollectionConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CollectionConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

