/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.executor.logging;

import lombok.Generated;
import org.apache.dolphinscheduler.api.executor.logging.LocalLogClient;
import org.apache.dolphinscheduler.api.executor.logging.RemoteLogClient;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.extract.common.transportor.LogResponseStatus;
import org.apache.dolphinscheduler.extract.common.transportor.TaskInstanceLogFileDownloadResponse;
import org.apache.dolphinscheduler.extract.common.transportor.TaskInstanceLogPageQueryResponse;
import org.apache.dolphinscheduler.plugin.task.api.utils.TaskTypeUtils;
import org.apache.dolphinscheduler.registry.api.RegistryClient;
import org.apache.dolphinscheduler.registry.api.enums.RegistryNodeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LogClientDelegate {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LogClientDelegate.class);
    @Autowired
    private LocalLogClient localLogClient;
    @Autowired
    private RemoteLogClient remoteLogClient;
    @Autowired
    private RegistryClient registryClient;

    public String getPartLogString(TaskInstance taskInstance, int skipLineNum, int limit) {
        LogClientDelegate.checkArgs(taskInstance);
        if (this.checkNodeExists(taskInstance)) {
            TaskInstanceLogPageQueryResponse response = this.localLogClient.getPartLog(taskInstance, skipLineNum, limit);
            if (response.getCode() == LogResponseStatus.SUCCESS) {
                return response.getLogContent();
            }
            log.warn("get part log string is not success for task instance {}; reason :{}", (Object)taskInstance.getId(), (Object)response.getMessage());
            return this.remoteLogClient.getPartLog(taskInstance, skipLineNum, limit);
        }
        return this.remoteLogClient.getPartLog(taskInstance, skipLineNum, limit);
    }

    public byte[] getWholeLogBytes(TaskInstance taskInstance) {
        LogClientDelegate.checkArgs(taskInstance);
        if (this.checkNodeExists(taskInstance)) {
            TaskInstanceLogFileDownloadResponse response = this.localLogClient.getWholeLog(taskInstance);
            if (response.getCode() == LogResponseStatus.SUCCESS) {
                return response.getLogBytes();
            }
            log.warn("get whole log bytes is not success for task instance {}; reason :{}", (Object)taskInstance.getId(), (Object)response.getMessage());
            return this.remoteLogClient.getWholeLog(taskInstance);
        }
        return this.remoteLogClient.getWholeLog(taskInstance);
    }

    private static void checkArgs(TaskInstance taskInstance) {
        if (taskInstance == null) {
            throw new IllegalArgumentException("canFetchLog task instance is null");
        }
    }

    private boolean checkNodeExists(TaskInstance taskInstance) {
        RegistryNodeType nodeType = TaskTypeUtils.isLogicTask((String)taskInstance.getTaskType()) ? RegistryNodeType.MASTER : RegistryNodeType.WORKER;
        boolean exists = this.registryClient.checkNodeExists(taskInstance.getHost(), nodeType);
        if (!exists) {
            log.warn("Node {} does not exist for task instance {}", (Object)taskInstance.getHost(), (Object)taskInstance.getId());
        }
        return exists;
    }
}

