/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.api.records;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.util.Records;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class ResourceOption {
    public static final int OVER_COMMIT_TIMEOUT_MILLIS_DEFAULT = -1;

    public static ResourceOption newInstance(Resource resource, int overCommitTimeout) {
        ResourceOption resourceOption = Records.newRecord(ResourceOption.class);
        resourceOption.setResource(resource);
        resourceOption.setOverCommitTimeout(overCommitTimeout);
        resourceOption.build();
        return resourceOption;
    }

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    public abstract Resource getResource();

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    protected abstract void setResource(Resource var1);

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    public abstract int getOverCommitTimeout();

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    protected abstract void setOverCommitTimeout(int var1);

    @InterfaceAudience.Private
    @InterfaceStability.Evolving
    protected abstract void build();

    public String toString() {
        return "Resource:" + this.getResource().toString() + ", overCommitTimeout:" + this.getOverCommitTimeout();
    }
}

