/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.storage.models.ObjectReplicationPolicyRule;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class ObjectReplicationPolicyProperties {
    @JsonProperty(value="policyId", access=JsonProperty.Access.WRITE_ONLY)
    private String policyId;
    @JsonProperty(value="enabledTime", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime enabledTime;
    @JsonProperty(value="sourceAccount", required=true)
    private String sourceAccount;
    @JsonProperty(value="destinationAccount", required=true)
    private String destinationAccount;
    @JsonProperty(value="rules")
    private List<ObjectReplicationPolicyRule> rules;
    private static final ClientLogger LOGGER = new ClientLogger(ObjectReplicationPolicyProperties.class);

    public String policyId() {
        return this.policyId;
    }

    public OffsetDateTime enabledTime() {
        return this.enabledTime;
    }

    public String sourceAccount() {
        return this.sourceAccount;
    }

    public ObjectReplicationPolicyProperties withSourceAccount(String sourceAccount) {
        this.sourceAccount = sourceAccount;
        return this;
    }

    public String destinationAccount() {
        return this.destinationAccount;
    }

    public ObjectReplicationPolicyProperties withDestinationAccount(String destinationAccount) {
        this.destinationAccount = destinationAccount;
        return this;
    }

    public List<ObjectReplicationPolicyRule> rules() {
        return this.rules;
    }

    public ObjectReplicationPolicyProperties withRules(List<ObjectReplicationPolicyRule> rules) {
        this.rules = rules;
        return this;
    }

    public void validate() {
        if (this.sourceAccount() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property sourceAccount in model ObjectReplicationPolicyProperties"));
        }
        if (this.destinationAccount() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property destinationAccount in model ObjectReplicationPolicyProperties"));
        }
        if (this.rules() != null) {
            this.rules().forEach(e -> e.validate());
        }
    }
}

