/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.storage.fluent;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.management.polling.PollResult;
import com.azure.core.util.Context;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.SyncPoller;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsDelete;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsGet;
import com.azure.resourcemanager.resources.fluentcore.collection.InnerSupportsListing;
import com.azure.resourcemanager.storage.fluent.models.BlobRestoreStatusInner;
import com.azure.resourcemanager.storage.fluent.models.CheckNameAvailabilityResultInner;
import com.azure.resourcemanager.storage.fluent.models.ListAccountSasResponseInner;
import com.azure.resourcemanager.storage.fluent.models.ListServiceSasResponseInner;
import com.azure.resourcemanager.storage.fluent.models.StorageAccountInner;
import com.azure.resourcemanager.storage.fluent.models.StorageAccountListKeysResultInner;
import com.azure.resourcemanager.storage.models.AccountSasParameters;
import com.azure.resourcemanager.storage.models.BlobRestoreParameters;
import com.azure.resourcemanager.storage.models.ListKeyExpand;
import com.azure.resourcemanager.storage.models.ServiceSasParameters;
import com.azure.resourcemanager.storage.models.StorageAccountCheckNameAvailabilityParameters;
import com.azure.resourcemanager.storage.models.StorageAccountCreateParameters;
import com.azure.resourcemanager.storage.models.StorageAccountExpand;
import com.azure.resourcemanager.storage.models.StorageAccountRegenerateKeyParameters;
import com.azure.resourcemanager.storage.models.StorageAccountUpdateParameters;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public interface StorageAccountsClient
extends InnerSupportsGet<StorageAccountInner>,
InnerSupportsListing<StorageAccountInner>,
InnerSupportsDelete<Void> {
    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<CheckNameAvailabilityResultInner>> checkNameAvailabilityWithResponseAsync(StorageAccountCheckNameAvailabilityParameters var1);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<CheckNameAvailabilityResultInner> checkNameAvailabilityAsync(StorageAccountCheckNameAvailabilityParameters var1);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public CheckNameAvailabilityResultInner checkNameAvailability(StorageAccountCheckNameAvailabilityParameters var1);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<CheckNameAvailabilityResultInner> checkNameAvailabilityWithResponse(StorageAccountCheckNameAvailabilityParameters var1, Context var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> createWithResponseAsync(String var1, String var2, StorageAccountCreateParameters var3);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<StorageAccountInner>, StorageAccountInner> beginCreateAsync(String var1, String var2, StorageAccountCreateParameters var3);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<StorageAccountInner>, StorageAccountInner> beginCreate(String var1, String var2, StorageAccountCreateParameters var3);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<StorageAccountInner>, StorageAccountInner> beginCreate(String var1, String var2, StorageAccountCreateParameters var3, Context var4);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StorageAccountInner> createAsync(String var1, String var2, StorageAccountCreateParameters var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public StorageAccountInner create(String var1, String var2, StorageAccountCreateParameters var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public StorageAccountInner create(String var1, String var2, StorageAccountCreateParameters var3, Context var4);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> deleteWithResponseAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> deleteAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void delete(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> deleteWithResponse(String var1, String var2, Context var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<StorageAccountInner>> getByResourceGroupWithResponseAsync(String var1, String var2, StorageAccountExpand var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StorageAccountInner> getByResourceGroupAsync(String var1, String var2, StorageAccountExpand var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StorageAccountInner> getByResourceGroupAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public StorageAccountInner getByResourceGroup(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<StorageAccountInner> getByResourceGroupWithResponse(String var1, String var2, StorageAccountExpand var3, Context var4);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<StorageAccountInner>> updateWithResponseAsync(String var1, String var2, StorageAccountUpdateParameters var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StorageAccountInner> updateAsync(String var1, String var2, StorageAccountUpdateParameters var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public StorageAccountInner update(String var1, String var2, StorageAccountUpdateParameters var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<StorageAccountInner> updateWithResponse(String var1, String var2, StorageAccountUpdateParameters var3, Context var4);

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<StorageAccountInner> listAsync();

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<StorageAccountInner> list();

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<StorageAccountInner> list(Context var1);

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedFlux<StorageAccountInner> listByResourceGroupAsync(String var1);

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<StorageAccountInner> listByResourceGroup(String var1);

    @ServiceMethod(returns=ReturnType.COLLECTION)
    public PagedIterable<StorageAccountInner> listByResourceGroup(String var1, Context var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<StorageAccountListKeysResultInner>> listKeysWithResponseAsync(String var1, String var2, ListKeyExpand var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StorageAccountListKeysResultInner> listKeysAsync(String var1, String var2, ListKeyExpand var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StorageAccountListKeysResultInner> listKeysAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public StorageAccountListKeysResultInner listKeys(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<StorageAccountListKeysResultInner> listKeysWithResponse(String var1, String var2, ListKeyExpand var3, Context var4);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<StorageAccountListKeysResultInner>> regenerateKeyWithResponseAsync(String var1, String var2, StorageAccountRegenerateKeyParameters var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<StorageAccountListKeysResultInner> regenerateKeyAsync(String var1, String var2, StorageAccountRegenerateKeyParameters var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public StorageAccountListKeysResultInner regenerateKey(String var1, String var2, StorageAccountRegenerateKeyParameters var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<StorageAccountListKeysResultInner> regenerateKeyWithResponse(String var1, String var2, StorageAccountRegenerateKeyParameters var3, Context var4);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ListAccountSasResponseInner>> listAccountSasWithResponseAsync(String var1, String var2, AccountSasParameters var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ListAccountSasResponseInner> listAccountSasAsync(String var1, String var2, AccountSasParameters var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ListAccountSasResponseInner listAccountSas(String var1, String var2, AccountSasParameters var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ListAccountSasResponseInner> listAccountSasWithResponse(String var1, String var2, AccountSasParameters var3, Context var4);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<ListServiceSasResponseInner>> listServiceSasWithResponseAsync(String var1, String var2, ServiceSasParameters var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<ListServiceSasResponseInner> listServiceSasAsync(String var1, String var2, ServiceSasParameters var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public ListServiceSasResponseInner listServiceSas(String var1, String var2, ServiceSasParameters var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<ListServiceSasResponseInner> listServiceSasWithResponse(String var1, String var2, ServiceSasParameters var3, Context var4);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> failoverWithResponseAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginFailoverAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginFailover(String var1, String var2);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginFailover(String var1, String var2, Context var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> failoverAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void failover(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void failover(String var1, String var2, Context var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> hierarchicalNamespaceMigrationWithResponseAsync(String var1, String var2, String var3);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginHierarchicalNamespaceMigrationAsync(String var1, String var2, String var3);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginHierarchicalNamespaceMigration(String var1, String var2, String var3);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginHierarchicalNamespaceMigration(String var1, String var2, String var3, Context var4);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> hierarchicalNamespaceMigrationAsync(String var1, String var2, String var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void hierarchicalNamespaceMigration(String var1, String var2, String var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void hierarchicalNamespaceMigration(String var1, String var2, String var3, Context var4);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> abortHierarchicalNamespaceMigrationWithResponseAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<Void>, Void> beginAbortHierarchicalNamespaceMigrationAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginAbortHierarchicalNamespaceMigration(String var1, String var2);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<Void>, Void> beginAbortHierarchicalNamespaceMigration(String var1, String var2, Context var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> abortHierarchicalNamespaceMigrationAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void abortHierarchicalNamespaceMigration(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void abortHierarchicalNamespaceMigration(String var1, String var2, Context var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Flux<ByteBuffer>>> restoreBlobRangesWithResponseAsync(String var1, String var2, BlobRestoreParameters var3);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public PollerFlux<PollResult<BlobRestoreStatusInner>, BlobRestoreStatusInner> beginRestoreBlobRangesAsync(String var1, String var2, BlobRestoreParameters var3);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BlobRestoreStatusInner>, BlobRestoreStatusInner> beginRestoreBlobRanges(String var1, String var2, BlobRestoreParameters var3);

    @ServiceMethod(returns=ReturnType.LONG_RUNNING_OPERATION)
    public SyncPoller<PollResult<BlobRestoreStatusInner>, BlobRestoreStatusInner> beginRestoreBlobRanges(String var1, String var2, BlobRestoreParameters var3, Context var4);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<BlobRestoreStatusInner> restoreBlobRangesAsync(String var1, String var2, BlobRestoreParameters var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobRestoreStatusInner restoreBlobRanges(String var1, String var2, BlobRestoreParameters var3);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public BlobRestoreStatusInner restoreBlobRanges(String var1, String var2, BlobRestoreParameters var3, Context var4);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Response<Void>> revokeUserDelegationKeysWithResponseAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Mono<Void> revokeUserDelegationKeysAsync(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void revokeUserDelegationKeys(String var1, String var2);

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> revokeUserDelegationKeysWithResponse(String var1, String var2, Context var3);
}

