/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.monitor.models.AccessMode;
import com.azure.resourcemanager.monitor.models.AccessModeSettingsExclusion;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

public final class AccessModeSettings {
    @JsonProperty(value="queryAccessMode", required=true)
    private AccessMode queryAccessMode;
    @JsonProperty(value="ingestionAccessMode", required=true)
    private AccessMode ingestionAccessMode;
    @JsonProperty(value="exclusions")
    private List<AccessModeSettingsExclusion> exclusions;
    private static final ClientLogger LOGGER = new ClientLogger(AccessModeSettings.class);

    public AccessMode queryAccessMode() {
        return this.queryAccessMode;
    }

    public AccessModeSettings withQueryAccessMode(AccessMode queryAccessMode) {
        this.queryAccessMode = queryAccessMode;
        return this;
    }

    public AccessMode ingestionAccessMode() {
        return this.ingestionAccessMode;
    }

    public AccessModeSettings withIngestionAccessMode(AccessMode ingestionAccessMode) {
        this.ingestionAccessMode = ingestionAccessMode;
        return this;
    }

    public List<AccessModeSettingsExclusion> exclusions() {
        return this.exclusions;
    }

    public AccessModeSettings withExclusions(List<AccessModeSettingsExclusion> exclusions) {
        this.exclusions = exclusions;
        return this;
    }

    public void validate() {
        if (this.queryAccessMode() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property queryAccessMode in model AccessModeSettings"));
        }
        if (this.ingestionAccessMode() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property ingestionAccessMode in model AccessModeSettings"));
        }
        if (this.exclusions() != null) {
            this.exclusions().forEach(e -> e.validate());
        }
    }
}

