/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.service.expand;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.dolphinscheduler.common.enums.CommandType;
import org.apache.dolphinscheduler.common.utils.DateUtils;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.common.utils.placeholder.BusinessTimeUtils;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.dao.mapper.ProjectParameterMapper;
import org.apache.dolphinscheduler.extract.master.command.ICommandParam;
import org.apache.dolphinscheduler.plugin.task.api.enums.DataType;
import org.apache.dolphinscheduler.plugin.task.api.enums.Direct;
import org.apache.dolphinscheduler.plugin.task.api.model.Property;
import org.apache.dolphinscheduler.plugin.task.api.parameters.AbstractParameters;
import org.apache.dolphinscheduler.plugin.task.api.utils.MapUtils;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.apache.dolphinscheduler.plugin.task.api.utils.PropertyUtils;
import org.apache.dolphinscheduler.plugin.task.api.utils.VarPoolUtils;
import org.apache.dolphinscheduler.service.exceptions.ServiceException;
import org.apache.dolphinscheduler.service.expand.CuringParamsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CuringParamsServiceImpl
implements CuringParamsService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CuringParamsServiceImpl.class);
    @Autowired
    private ProjectParameterMapper projectParameterMapper;

    @Override
    public String convertParameterPlaceholders(String val, Map<String, Property> allParamMap) {
        Map<String, String> paramMap = allParamMap.entrySet().stream().filter(entry -> Objects.nonNull(((Property)entry.getValue()).getValue())).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Property)entry.getValue()).getValue()));
        return ParameterUtils.convertParameterPlaceholders((String)val, paramMap);
    }

    @Override
    public String curingGlobalParams(Integer workflowInstanceId, Map<String, String> globalParamMap, List<Property> globalParamList, CommandType commandType, Date scheduleTime, String timezone) {
        String val;
        if (globalParamList == null || globalParamList.isEmpty()) {
            return null;
        }
        HashMap<String, String> globalMap = new HashMap<String, String>();
        if (globalParamMap != null) {
            globalMap.putAll(globalParamMap);
        }
        HashMap<String, String> allParamMap = new HashMap<String, String>();
        Map timeParams = BusinessTimeUtils.getBusinessTime((CommandType)commandType, (Date)scheduleTime, (String)timezone);
        if (timeParams != null) {
            allParamMap.putAll(timeParams);
        }
        allParamMap.putAll(globalMap);
        Set entries = allParamMap.entrySet();
        HashMap resolveMap = new HashMap();
        for (Map.Entry entry : entries) {
            val = (String)entry.getValue();
            if (!val.contains("$")) continue;
            String str = val;
            resolveMap.put(entry.getKey(), str);
        }
        globalMap.putAll(resolveMap);
        for (Property property : globalParamList) {
            val = (String)globalMap.get(property.getProp());
            if (val == null) continue;
            property.setValue(val);
        }
        return JSONUtils.toJsonString(globalParamList);
    }

    @Override
    public Map<String, Property> parseWorkflowStartParam(@Nullable Map<String, String> cmdParam) {
        if (cmdParam == null || !cmdParam.containsKey("StartParams")) {
            return new HashMap<String, Property>();
        }
        String startParamJson = cmdParam.get("StartParams");
        List propertyList = PropertyUtils.startParamsTransformPropertyList((String)startParamJson);
        if (CollectionUtils.isEmpty((Collection)propertyList)) {
            return new HashMap<String, Property>();
        }
        return propertyList.stream().collect(Collectors.toMap(Property::getProp, Function.identity()));
    }

    @Override
    public Map<String, Property> parseWorkflowFatherParam(@Nullable Map<String, String> cmdParam) {
        if (cmdParam == null || !cmdParam.containsKey("fatherParams")) {
            return new HashMap<String, Property>();
        }
        String startParamJson = cmdParam.get("fatherParams");
        Map startParamMap = JSONUtils.toMap((String)startParamJson);
        return startParamMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new Property((String)entry.getKey(), Direct.IN, DataType.VARCHAR, (String)entry.getValue())));
    }

    @Override
    public Map<String, Property> paramParsingPreparation(@NonNull TaskInstance taskInstance, @NonNull AbstractParameters parameters, @NonNull WorkflowInstance workflowInstance, String projectName, String workflowDefinitionName) {
        List<Property> varPools;
        if (taskInstance == null) {
            throw new NullPointerException("taskInstance is marked non-null but is null");
        }
        if (parameters == null) {
            throw new NullPointerException("parameters is marked non-null but is null");
        }
        if (workflowInstance == null) {
            throw new NullPointerException("workflowInstance is marked non-null but is null");
        }
        HashMap<String, Property> prepareParamsMap = new HashMap<String, Property>();
        ICommandParam commandParam = (ICommandParam)JSONUtils.parseObject((String)workflowInstance.getCommandParam(), ICommandParam.class);
        if (commandParam == null) {
            throw new ServiceException(String.format("Failed to parse command parameter for workflow instance %s", workflowInstance.getId()));
        }
        String timeZone = commandParam.getTimeZone();
        Map<String, String> builtInParams = this.setBuiltInParamsMap(taskInstance, workflowInstance, timeZone, projectName, workflowDefinitionName);
        this.safePutAll(prepareParamsMap, ParameterUtils.getUserDefParamsMap(builtInParams));
        Map<String, Property> projectParams = this.getProjectParameterMap(taskInstance.getProjectCode());
        this.safePutAll(prepareParamsMap, projectParams);
        Map<String, Property> globalParams = this.parseGlobalParamsMap(workflowInstance);
        this.safePutAll(prepareParamsMap, globalParams);
        Map localParams = parameters.getInputLocalParametersMap();
        this.safePutAll(prepareParamsMap, localParams);
        if (CollectionUtils.isNotEmpty((Collection)commandParam.getCommandParams())) {
            Map<String, Property> commandParamsMap = commandParam.getCommandParams().stream().filter(prop -> StringUtils.isNotBlank((CharSequence)prop.getProp())).collect(Collectors.toMap(Property::getProp, Function.identity(), (v1, v2) -> v2));
            this.safePutAll(prepareParamsMap, commandParamsMap);
        }
        if (CollectionUtils.isNotEmpty(varPools = this.parseVarPool(taskInstance))) {
            for (Property varPool : varPools) {
                Property targetParam;
                if (StringUtils.isBlank((CharSequence)varPool.getProp()) || (targetParam = (Property)prepareParamsMap.get(varPool.getProp())) == null || !Direct.IN.equals((Object)targetParam.getDirect())) continue;
                targetParam.setValue(varPool.getValue());
            }
        }
        Map<String, Property> businessParams = this.preBuildBusinessParams(workflowInstance);
        this.safePutAll(prepareParamsMap, businessParams);
        this.resolvePlaceholders(prepareParamsMap);
        return prepareParamsMap;
    }

    private void safePutAll(Map<String, Property> target, Map<String, Property> source) {
        if (MapUtils.isEmpty(source)) {
            return;
        }
        source.forEach((key, value) -> {
            if (StringUtils.isNotBlank((CharSequence)key) && value != null) {
                target.put((String)key, (Property)value);
            } else {
                log.warn("Skipped invalid parameter entry: key='{}', value={}", key, value);
            }
        });
    }

    private void resolvePlaceholders(Map<String, Property> paramsMap) {
        for (Property prop : paramsMap.values()) {
            String val = prop.getValue();
            if (!StringUtils.isNotEmpty((CharSequence)val) || !val.contains("$")) continue;
            prop.setValue(this.convertParameterPlaceholders(val, paramsMap));
        }
    }

    private Map<String, String> setBuiltInParamsMap(@NonNull TaskInstance taskInstance, WorkflowInstance workflowInstance, String timeZone, String projectName, String workflowDefinitionName) {
        if (taskInstance == null) {
            throw new NullPointerException("taskInstance is marked non-null but is null");
        }
        CommandType commandType = workflowInstance.getCmdTypeIfComplement();
        Date scheduleTime = workflowInstance.getScheduleTime();
        Map params = BusinessTimeUtils.getBusinessTime((CommandType)commandType, (Date)scheduleTime, (String)timeZone);
        if (StringUtils.isNotBlank((CharSequence)taskInstance.getExecutePath())) {
            params.put("system.task.execute.path", taskInstance.getExecutePath());
        }
        params.put("system.task.instance.id", Integer.toString(taskInstance.getId()));
        params.put("system.task.definition.name", taskInstance.getName());
        params.put("system.task.definition.code", Long.toString(taskInstance.getTaskCode()));
        params.put("system.workflow.instance.id", Integer.toString(taskInstance.getWorkflowInstanceId()));
        params.put("system.workflow.definition.name", workflowDefinitionName);
        params.put("system.workflow.definition.code", Long.toString(workflowInstance.getWorkflowDefinitionCode()));
        params.put("system.project.name", projectName);
        params.put("system.project.code", Long.toString(workflowInstance.getProjectCode()));
        return params;
    }

    private Map<String, Property> parseGlobalParamsMap(WorkflowInstance workflowInstance) {
        LinkedHashMap<String, Property> globalParametersMaps = new LinkedHashMap<String, Property>();
        if (StringUtils.isNotEmpty((CharSequence)workflowInstance.getGlobalParams())) {
            JSONUtils.toList((String)workflowInstance.getGlobalParams(), Property.class).forEach(property -> globalParametersMaps.put(property.getProp(), (Property)property));
        }
        return globalParametersMaps;
    }

    private List<Property> parseVarPool(TaskInstance taskInstance) {
        if (StringUtils.isNotEmpty((CharSequence)taskInstance.getVarPool())) {
            return VarPoolUtils.deserializeVarPool((String)taskInstance.getVarPool());
        }
        return Collections.emptyList();
    }

    @Override
    public Map<String, Property> preBuildBusinessParams(WorkflowInstance workflowInstance) {
        HashMap<String, Property> paramsMap = new HashMap<String, Property>();
        if (workflowInstance.getScheduleTime() != null) {
            Date date = workflowInstance.getScheduleTime();
            String dateTime = DateUtils.format((Date)date, (String)"yyyyMMddHHmmss", null);
            Property p = new Property();
            p.setValue(dateTime);
            p.setProp("system.datetime");
            paramsMap.put("system.datetime", p);
        }
        return paramsMap;
    }

    @Override
    public Map<String, Property> getProjectParameterMap(long projectCode) {
        HashMap<String, Property> result = new HashMap<String, Property>(16);
        List projectParameterList = this.projectParameterMapper.queryByProjectCode(projectCode);
        projectParameterList.forEach(projectParameter -> {
            Property property = new Property(projectParameter.getParamName(), Direct.IN, Enum.valueOf(DataType.class, projectParameter.getParamDataType()), projectParameter.getParamValue());
            result.put(projectParameter.getParamName(), property);
        });
        return result;
    }
}

