/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.connection.ui;

import java.util.Arrays;
import java.util.Comparator;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.directory.studio.connection.ui.ConnectionParameterPage;
import org.apache.directory.studio.connection.ui.ConnectionUIConstants;
import org.apache.directory.studio.connection.ui.ConnectionUIPlugin;
import org.apache.directory.studio.connection.ui.Messages;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public final class ConnectionParameterPageManager {
    private ConnectionParameterPageManager() {
    }

    public static ConnectionParameterPage[] getConnectionParameterPages() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = registry.getExtensionPoint("org.apache.directory.studio.connectionparameterpages");
        IConfigurationElement[] members = extensionPoint.getConfigurationElements();
        ConcurrentHashMap<String, ConnectionParameterPage> pageMap = new ConcurrentHashMap<String, ConnectionParameterPage>();
        IConfigurationElement[] iConfigurationElementArray = members;
        int n = members.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement member = iConfigurationElementArray[n2];
            try {
                ConnectionParameterPage page = (ConnectionParameterPage)member.createExecutableExtension("class");
                page.setPageId(member.getAttribute("id"));
                page.setPageName(member.getAttribute("name"));
                page.setPageDescription(member.getAttribute("description"));
                page.setPageDependsOnId(member.getAttribute("dependsOnId"));
                pageMap.put(page.getPageId(), page);
            }
            catch (Exception e) {
                ConnectionUIPlugin.getDefault().getLog().log((IStatus)new Status(4, ConnectionUIConstants.PLUGIN_ID, 1, String.valueOf(Messages.getString("ConnectionParameterPageManager.UnableCreateConnectionParamPage")) + member.getAttribute("class"), (Throwable)e));
            }
            ++n2;
        }
        ConnectionParameterPage[] pages = pageMap.values().toArray(new ConnectionParameterPage[0]);
        Comparator pageComparator = (page1, page2) -> {
            ConnectionParameterPage page;
            String dependsOnId1 = page1.getPageDependsOnId();
            String dependsOnId2 = page2.getPageDependsOnId();
            do {
                if (dependsOnId1 == null && dependsOnId2 != null) {
                    return -1;
                }
                if (dependsOnId2 == null && dependsOnId1 != null) {
                    return 1;
                }
                if (dependsOnId1 != null && dependsOnId1.equals(page2.getPageId())) {
                    return 1;
                }
                if (dependsOnId2 == null || !dependsOnId2.equals(page1.getPageId())) continue;
                return -1;
            } while ((dependsOnId1 = (page = (ConnectionParameterPage)pageMap.get(dependsOnId1)) != null && !page.getPageDependsOnId().equals(dependsOnId1) ? page.getPageDependsOnId() : null) != null && !dependsOnId1.equals(page1.getPageId()));
            dependsOnId1 = page1.getPageDependsOnId();
            dependsOnId2 = page2.getPageDependsOnId();
            do {
                if (dependsOnId1 == null && dependsOnId2 != null) {
                    return -1;
                }
                if (dependsOnId2 == null && dependsOnId1 != null) {
                    return 1;
                }
                if (dependsOnId1 != null && dependsOnId1.equals(page2.getPageId())) {
                    return 1;
                }
                if (dependsOnId2 == null || !dependsOnId2.equals(page1.getPageId())) continue;
                return -1;
            } while ((dependsOnId2 = (page = (ConnectionParameterPage)pageMap.get(dependsOnId2)) == null ? null : page.getPageDependsOnId()) != null && !dependsOnId2.equals(page2.getPageId()));
            return 0;
        };
        Arrays.sort(pages, pageComparator);
        return pages;
    }
}

