/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio;

import org.apache.directory.studio.ApplicationActionBarAdvisor;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    private IEditorPart lastActiveEditor = null;
    private IPerspectiveDescriptor lastPerspective = null;
    private IWorkbenchPage lastActivePage;
    private String lastEditorTitle = "";
    private IAdaptable lastInput;
    private IPropertyListener editorPropertyListener = new IPropertyListener(){

        public void propertyChanged(Object source, int propId) {
            if (propId == 1 && ApplicationWorkbenchWindowAdvisor.this.lastActiveEditor != null) {
                String newTitle = ApplicationWorkbenchWindowAdvisor.this.lastActiveEditor.getTitle();
                if (!ApplicationWorkbenchWindowAdvisor.this.lastEditorTitle.equals(newTitle)) {
                    ApplicationWorkbenchWindowAdvisor.this.recomputeTitle();
                }
            }
        }
    };

    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new ApplicationActionBarAdvisor(configurer);
    }

    public void preWindowOpen() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        configurer.setInitialSize(new Point(950, 708));
        configurer.setShowCoolBar(true);
        configurer.setShowStatusLine(false);
        configurer.setShowPerspectiveBar(true);
        configurer.setShowProgressIndicator(true);
        configurer.setShowFastViewBars(true);
        this.hookTitleUpdateListeners(configurer);
    }

    private void hookTitleUpdateListeners(IWorkbenchWindowConfigurer configurer) {
        configurer.getWindow().addPageListener(new IPageListener(){

            public void pageActivated(IWorkbenchPage page) {
                ApplicationWorkbenchWindowAdvisor.this.updateTitle(false);
            }

            public void pageClosed(IWorkbenchPage page) {
                ApplicationWorkbenchWindowAdvisor.this.updateTitle(false);
            }

            public void pageOpened(IWorkbenchPage page) {
            }
        });
        configurer.getWindow().addPerspectiveListener((IPerspectiveListener)new PerspectiveAdapter(){

            public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                ApplicationWorkbenchWindowAdvisor.this.updateTitle(false);
            }

            public void perspectiveSavedAs(IWorkbenchPage page, IPerspectiveDescriptor oldPerspective, IPerspectiveDescriptor newPerspective) {
                ApplicationWorkbenchWindowAdvisor.this.updateTitle(false);
            }

            public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
                ApplicationWorkbenchWindowAdvisor.this.updateTitle(false);
            }
        });
        configurer.getWindow().getPartService().addPartListener(new IPartListener2(){

            public void partActivated(IWorkbenchPartReference ref) {
                if (ref instanceof IEditorReference) {
                    ApplicationWorkbenchWindowAdvisor.this.updateTitle(false);
                }
            }

            public void partBroughtToTop(IWorkbenchPartReference ref) {
                if (ref instanceof IEditorReference) {
                    ApplicationWorkbenchWindowAdvisor.this.updateTitle(false);
                }
            }

            public void partClosed(IWorkbenchPartReference ref) {
                ApplicationWorkbenchWindowAdvisor.this.updateTitle(false);
            }

            public void partDeactivated(IWorkbenchPartReference ref) {
            }

            public void partOpened(IWorkbenchPartReference ref) {
            }

            public void partHidden(IWorkbenchPartReference ref) {
                if (ref.getPart(false) == ApplicationWorkbenchWindowAdvisor.this.lastActiveEditor && ApplicationWorkbenchWindowAdvisor.this.lastActiveEditor != null) {
                    ApplicationWorkbenchWindowAdvisor.this.updateTitle(true);
                }
            }

            public void partVisible(IWorkbenchPartReference ref) {
                if (ref.getPart(false) == ApplicationWorkbenchWindowAdvisor.this.lastActiveEditor && ApplicationWorkbenchWindowAdvisor.this.lastActiveEditor != null) {
                    ApplicationWorkbenchWindowAdvisor.this.updateTitle(false);
                }
            }

            public void partInputChanged(IWorkbenchPartReference ref) {
            }
        });
    }

    private String computeTitle() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        IWorkbenchPage currentPage = configurer.getWindow().getActivePage();
        IEditorPart activeEditor = null;
        if (currentPage != null) {
            activeEditor = this.lastActiveEditor;
        }
        String title = null;
        IProduct product = Platform.getProduct();
        if (product != null) {
            title = product.getName();
        }
        if (title == null) {
            title = "";
        }
        if (currentPage != null) {
            IAdaptable input;
            if (activeEditor != null) {
                this.lastEditorTitle = activeEditor.getTitleToolTip();
                title = NLS.bind((String)"{0} - {1}", (Object)this.lastEditorTitle, (Object)title);
            }
            IPerspectiveDescriptor persp = currentPage.getPerspective();
            String label = "";
            if (persp != null) {
                label = persp.getLabel();
            }
            if ((input = currentPage.getInput()) != null) {
                label = currentPage.getLabel();
            }
            if (label != null && !label.equals("")) {
                title = NLS.bind((String)"{0} - {1}", (Object)label, (Object)title);
            }
        }
        return title;
    }

    private void recomputeTitle() {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        String oldTitle = configurer.getTitle();
        String newTitle = this.computeTitle();
        if (!newTitle.equals(oldTitle)) {
            configurer.setTitle(newTitle);
        }
    }

    private void updateTitle(boolean editorHidden) {
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        IWorkbenchWindow window = configurer.getWindow();
        IEditorPart activeEditor = null;
        IWorkbenchPage currentPage = window.getActivePage();
        IPerspectiveDescriptor persp = null;
        IAdaptable input = null;
        if (currentPage != null) {
            activeEditor = currentPage.getActiveEditor();
            persp = currentPage.getPerspective();
            input = currentPage.getInput();
        }
        if (editorHidden) {
            activeEditor = null;
        }
        if (activeEditor == this.lastActiveEditor && currentPage == this.lastActivePage && persp == this.lastPerspective && input == this.lastInput) {
            return;
        }
        if (this.lastActiveEditor != null) {
            this.lastActiveEditor.removePropertyListener(this.editorPropertyListener);
        }
        this.lastActiveEditor = activeEditor;
        this.lastActivePage = currentPage;
        this.lastPerspective = persp;
        this.lastInput = input;
        if (activeEditor != null) {
            activeEditor.addPropertyListener(this.editorPropertyListener);
        }
        this.recomputeTitle();
    }
}

