/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor;

import org.apache.directory.studio.common.ui.CommonUIPlugin;
import org.apache.directory.studio.ldapbrowser.common.BrowserCommonActivator;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetContentProvider;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.EntryEditorWidgetFilter;
import org.apache.directory.studio.ldapbrowser.common.widgets.entryeditor.Messages;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.apache.directory.studio.valueeditors.IValueEditor;
import org.apache.directory.studio.valueeditors.ValueEditorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public class EntryEditorWidgetLabelProvider
extends LabelProvider
implements ITableLabelProvider,
IFontProvider,
IColorProvider {
    private TreeViewer viewer;
    private ValueEditorManager valueEditorManager;

    public EntryEditorWidgetLabelProvider(TreeViewer viewer, ValueEditorManager valueEditorManager) {
        this.viewer = viewer;
        this.valueEditorManager = valueEditorManager;
    }

    public void dispose() {
        super.dispose();
        this.valueEditorManager = null;
    }

    public final String getColumnText(Object obj, int index) {
        if (obj instanceof IValue) {
            IValue value = (IValue)obj;
            switch (index) {
                case 0: {
                    return value.getAttribute().getDescription();
                }
                case 1: {
                    IValueEditor vp = this.valueEditorManager.getCurrentValueEditor(value);
                    String dv = vp.getDisplayValue(value);
                    return dv;
                }
            }
            return "";
        }
        if (obj instanceof IAttribute) {
            IAttribute attribute = (IAttribute)obj;
            if (index == 0) {
                return NLS.bind((String)Messages.getString("EntryEditorWidgetLabelProvider.AttributeLabel"), (Object)attribute.getDescription(), (Object)this.getNumberOfValues(attribute));
            }
            return "";
        }
        return "";
    }

    private int getNumberOfValues(IAttribute attribute) {
        EntryEditorWidgetContentProvider contentProvider = (EntryEditorWidgetContentProvider)this.viewer.getContentProvider();
        EntryEditorWidgetFilter filter = (EntryEditorWidgetFilter)this.viewer.getFilters()[0];
        int count = 0;
        Object[] objectArray = contentProvider.getChildren(attribute);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object child = objectArray[n2];
            if (filter.select((Viewer)this.viewer, attribute, child)) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    public final Image getColumnImage(Object element, int index) {
        return null;
    }

    public Font getFont(Object element) {
        IAttribute attribute = null;
        IValue value = null;
        if (element instanceof IAttribute) {
            attribute = (IAttribute)element;
        } else if (element instanceof IValue) {
            value = (IValue)element;
            attribute = value.getAttribute();
        }
        if (value != null && value.isEmpty()) {
            FontData[] fontData = Display.getDefault().getSystemFont().getFontData();
            FontData fontDataBoldItalic = new FontData(fontData[0].getName(), fontData[0].getHeight(), 3);
            return BrowserCommonActivator.getDefault().getFont(new FontData[]{fontDataBoldItalic});
        }
        if (attribute != null && value == null && !attribute.isConsistent()) {
            FontData[] fontData = Display.getDefault().getSystemFont().getFontData();
            FontData fontDataBoldItalic = new FontData(fontData[0].getName(), fontData[0].getHeight(), 3);
            return BrowserCommonActivator.getDefault().getFont(new FontData[]{fontDataBoldItalic});
        }
        if (attribute != null) {
            if (attribute.isObjectClassAttribute()) {
                FontData[] fontData = PreferenceConverter.getFontDataArray((IPreferenceStore)BrowserCommonActivator.getDefault().getPreferenceStore(), (String)"objectClassFont");
                return BrowserCommonActivator.getDefault().getFont(fontData);
            }
            if (attribute.isMustAttribute()) {
                FontData[] fontData = PreferenceConverter.getFontDataArray((IPreferenceStore)BrowserCommonActivator.getDefault().getPreferenceStore(), (String)"mustAttributeFont");
                return BrowserCommonActivator.getDefault().getFont(fontData);
            }
            if (attribute.isOperationalAttribute()) {
                FontData[] fontData = PreferenceConverter.getFontDataArray((IPreferenceStore)BrowserCommonActivator.getDefault().getPreferenceStore(), (String)"operationalAttributeFont");
                return BrowserCommonActivator.getDefault().getFont(fontData);
            }
            FontData[] fontData = PreferenceConverter.getFontDataArray((IPreferenceStore)BrowserCommonActivator.getDefault().getPreferenceStore(), (String)"mayAttributeFont");
            return BrowserCommonActivator.getDefault().getFont(fontData);
        }
        return null;
    }

    public Color getForeground(Object element) {
        IAttribute attribute = null;
        IValue value = null;
        if (element instanceof IAttribute) {
            attribute = (IAttribute)element;
        } else if (element instanceof IValue) {
            value = (IValue)element;
            attribute = value.getAttribute();
        }
        if (value != null && value.isEmpty()) {
            return CommonUIPlugin.getDefault().getColor("errorColor");
        }
        if (attribute != null && value == null && !attribute.isConsistent()) {
            return CommonUIPlugin.getDefault().getColor("errorColor");
        }
        if (attribute != null) {
            if (attribute.isObjectClassAttribute()) {
                return this.getColorIfNotDefaultElseNull("objectClassColor");
            }
            if (attribute.isMustAttribute()) {
                return this.getColorIfNotDefaultElseNull("mustAttributeColor");
            }
            if (attribute.isOperationalAttribute()) {
                return this.getColorIfNotDefaultElseNull("operationalAttributeColor");
            }
            return this.getColorIfNotDefaultElseNull("mayAttributeColor");
        }
        return null;
    }

    private Color getColorIfNotDefaultElseNull(String color) {
        BrowserCommonActivator plugin = BrowserCommonActivator.getDefault();
        IPreferenceStore preferenceStore = plugin.getPreferenceStore();
        if (preferenceStore.isDefault(color)) {
            return null;
        }
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)preferenceStore, (String)color);
        return plugin.getColor(rgb);
    }

    public Color getBackground(Object element) {
        return null;
    }
}

