/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.studio.ldapbrowser.common.actions;

import org.apache.directory.studio.connection.core.Utils;
import org.apache.directory.studio.ldapbrowser.common.actions.BrowserAction;
import org.apache.directory.studio.ldapbrowser.common.actions.Messages;
import org.apache.directory.studio.ldapbrowser.core.model.IAttribute;
import org.apache.directory.studio.ldapbrowser.core.model.IValue;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class PropertiesAction
extends BrowserAction {
    @Override
    public String getText() {
        return Messages.getString("PropertiesAction.Properties");
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    @Override
    public String getCommandId() {
        return "org.eclipse.ui.file.properties";
    }

    @Override
    public boolean isEnabled() {
        return this.getSelectedEntries().length + this.getSelectedSearchResults().length + this.getSelectedBookmarks().length + this.getSelectedSearches().length == 1 || this.getSelectedAttributes().length + this.getSelectedValues().length == 1 || this.getSelectedAttributeHierarchies().length == 1 && this.getSelectedAttributeHierarchies()[0].size() == 1;
    }

    @Override
    public void run() {
        IValue element = null;
        String pageId = null;
        String title = null;
        if (this.getSelectedValues().length == 1) {
            element = this.getSelectedValues()[0];
            pageId = "org.apache.directory.studio.ldapbrowser.ui.dialogs.properties.ValuePropertyPage";
            title = this.getSelectedValues()[0].toString();
        } else if (this.getSelectedAttributes().length == 1) {
            element = this.getSelectedAttributes()[0];
            pageId = "org.apache.directory.studio.ldapbrowser.ui.dialogs.properties.AttributePropertyPage";
            title = this.getSelectedAttributes()[0].toString();
        } else if (this.getSelectedAttributeHierarchies().length == 1) {
            IAttribute att = this.getSelectedAttributeHierarchies()[0].getAttribute();
            element = att;
            pageId = "org.apache.directory.studio.ldapbrowser.ui.dialogs.properties.AttributePropertyPage";
            title = att.toString();
        } else if (this.getSelectedSearches().length == 1) {
            element = this.getSelectedSearches()[0];
            pageId = "org.apache.directory.studio.ldapbrowser.ui.dialogs.properties.SearchPropertyPage";
            title = this.getSelectedSearches()[0].getName();
        } else if (this.getSelectedBookmarks().length == 1) {
            element = this.getSelectedBookmarks()[0];
            pageId = "org.apache.directory.studio.ldapbrowser.ui.dialogs.properties.BookmarkPropertyPage";
            title = this.getSelectedBookmarks()[0].getName();
        } else if (this.getSelectedEntries().length == 1) {
            element = this.getSelectedEntries()[0];
            pageId = "org.apache.directory.studio.ldapbrowser.ui.dialogs.properties.EntryPropertyPage";
            title = this.getSelectedEntries()[0].getDn().getName();
        } else if (this.getSelectedSearchResults().length == 1) {
            element = this.getSelectedSearchResults()[0];
            pageId = "org.apache.directory.studio.ldapbrowser.ui.dialogs.properties.EntryPropertyPage";
            title = this.getSelectedSearchResults()[0].getDn().getName();
        }
        if (element != null) {
            PreferenceDialog dialog = PreferencesUtil.createPropertyDialogOn((Shell)this.getShell(), (IAdaptable)element, (String)pageId, null, null);
            if (dialog != null) {
                title = Utils.shorten((String)title, (int)30);
            }
            dialog.getShell().setText(NLS.bind((String)Messages.getString("PropertiesAction.PropertiesForX"), (Object)title));
            dialog.open();
        }
    }
}

