/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.api.ldap.codec.actions.controls;

import org.apache.directory.api.asn1.DecoderException;
import org.apache.directory.api.asn1.ber.grammar.GrammarAction;
import org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.directory.api.i18n.I18n;
import org.apache.directory.api.ldap.codec.api.ControlFactory;
import org.apache.directory.api.ldap.codec.api.LdapMessageContainer;
import org.apache.directory.api.ldap.model.message.Control;
import org.apache.directory.api.ldap.model.message.Message;
import org.apache.directory.api.ldap.model.message.controls.OpaqueControl;
import org.apache.directory.api.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreControlValue
extends GrammarAction<LdapMessageContainer<Message>> {
    private static final Logger LOG = LoggerFactory.getLogger(StoreControlValue.class);

    public StoreControlValue() {
        super("Store the control value");
    }

    public void action(LdapMessageContainer<Message> container) throws DecoderException {
        TLV tlv = container.getCurrentTLV();
        Control control = container.getCurrentControl();
        BerValue value = tlv.getValue();
        if (tlv.getLength() >= 0) {
            ControlFactory<?> factory = container.getControlFactory();
            if (factory == null) {
                ((OpaqueControl)control).setEncodedValue(value.getData());
            } else {
                factory.decodeValue(control, value.getData());
            }
        }
        container.setGrammarEndAllowed(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug(I18n.msg((I18n)I18n.MSG_08203_CONTROL_VALUE, (Object[])new Object[]{Strings.dumpBytes((byte[])value.getData())}));
        }
    }
}

